/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.newsfeed;

import java.awt.Component;
import java.util.List;
import java.util.ListIterator;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.ui_data.newsfeed.NewsFeedController;
import org.scilab.modules.ui_data.newsfeed.NewsFeedTabFactory;
import org.scilab.modules.ui_data.newsfeed.NewsFeedUIMessages;
import org.scilab.modules.ui_data.newsfeed.NewsFeedWidget;
import org.scilab.modules.ui_data.newsfeed.actions.CloseAction;
import org.scilab.modules.ui_data.newsfeed.actions.HelpAction;
import org.scilab.modules.ui_data.newsfeed.actions.UpdateAction;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class NewsFeedTab
extends SwingScilabDockablePanel
implements SimpleTab {
    public static final String NEWSFEED_UUID = "DC0957B3-81DA-4E39-B0B5-E93B35412162";
    public static final String NEWSFEED_HELP_ID = "newsfeed";
    private static NewsFeedTab instance = null;
    private NewsFeedWidget newsFeedWidget;
    private NewsFeedController newsFeedController = new NewsFeedController();

    public static NewsFeedTab getInstance() {
        if (instance == null) {
            instance = new NewsFeedTab();
        }
        return instance;
    }

    private NewsFeedTab() {
        super(NewsFeedUIMessages.NEWS_FEED, NEWSFEED_UUID);
        this.newsFeedWidget = new NewsFeedWidget(this.newsFeedController);
        this.newsFeedController.addNewsFeedEventListener(this.newsFeedWidget);
        this.setContentPane(this.newsFeedWidget);
        this.addMenuBar(this.createMenuBar());
        this.addToolBar(this.createToolBar());
        TextBox textBox = ScilabTextBox.createTextBox();
        this.addInfoBar(textBox);
        this.registerClosingOperation();
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
        this.setAssociatedXMLIDForHelp(NEWSFEED_HELP_ID);
        this.startNewsFeed();
    }

    public static void displayTab() {
        WindowsConfigurationManager.restoreWindow((String)NEWSFEED_UUID);
    }

    public void startNewsFeed() {
        this.newsFeedController.start();
    }

    public void updateNewsFeed() {
        this.newsFeedController.updateNewsFeed();
    }

    public void closeTab() {
        this.stopNewsFeed();
        instance = null;
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public SwingScilabWindow getParentWindow() {
        return (SwingScilabWindow)SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(UiDataMessages.FILE);
        menu.setMnemonic(70);
        menu.add(CloseAction.createMenuItem());
        menu.add(UpdateAction.createMenuItem());
        menuBar.add(menu);
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(NewsFeedUIMessages.NEWS_FEED_HELP_LABEL);
        menu2.setMnemonic(63);
        menu2.add(HelpAction.createMenuItem());
        menuBar.add(menu2);
        return menuBar;
    }

    private ToolBar createToolBar() {
        ToolBar toolBar = ScilabToolBar.createToolBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)toolBar.getAsSimpleToolBar();
        swingScilabToolBar.add((Component)UpdateAction.createPushButton());
        swingScilabToolBar.addSeparator();
        swingScilabToolBar.add((Component)HelpAction.createPushButton());
        return toolBar;
    }

    private void registerClosingOperation() {
        ClosingOperationsManager.registerClosingOperation((SwingScilabDockablePanel)this, (ClosingOperationsManager.ClosingOperation)new ClosingOperationsManager.ClosingOperation(){

            public int canClose() {
                return 1;
            }

            public void destroy() {
                NewsFeedTab.this.closeTab();
            }

            public String askForClosing(List<SwingScilabDockablePanel> list) {
                return null;
            }

            public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
            }
        });
        ClosingOperationsManager.addDependencyWithRoot((SwingScilabDockablePanel)this);
    }

    private void stopNewsFeed() {
        this.newsFeedController.stop();
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)NewsFeedTabFactory.getInstance());
    }
}

