/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data;

import javax.swing.ImageIcon;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.types.ScilabTypeEnumDescription;
import org.scilab.modules.ui_data.variablebrowser.ScilabVariableBrowser;

public class BrowseVar {
    public static final int ICON_COLUMN_INDEX = 0;
    public static final int NAME_COLUMN_INDEX = 1;
    public static final int SIZE_COLUMN_INDEX = 2;
    public static final int TYPE_DESC_COLUMN_INDEX = 3;
    public static final int VISIBILITY_COLUMN_INDEX = 4;
    public static final int BYTES_COLUMN_INDEX = 5;
    public static final int FROM_SCILAB_COLUMN_INDEX = 6;
    public static final int TYPE_COLUMN_INDEX = 7;
    public static final int NB_ROWS_INDEX = 8;
    public static final int NB_COLS_INDEX = 9;
    public static final String[] COLUMNNAMES = new String[]{"", Messages.gettext((String)"Name"), Messages.gettext((String)"Value"), Messages.gettext((String)"Type"), Messages.gettext((String)"Visibility"), Messages.gettext((String)"Memory"), Messages.gettext((String)"User"), Messages.gettext((String)"Type int value"), "", ""};
    public static final int[] COLUMNSALIGNMENT = new int[]{-1, 2, 4, 4, 4, 4, 4, 4};
    private static final ImageIcon NO_ICON = new ImageIcon(FindIconHelper.findIcon((String)"noicon"));
    private static final ImageIcon DOUBLE_ICON = new ImageIcon(FindIconHelper.findIcon((String)"double"));
    private static final ImageIcon POLYNOMIAL_ICON = new ImageIcon(FindIconHelper.findIcon((String)"polynomial"));
    private static final ImageIcon BOOLEAN_ICON = new ImageIcon(FindIconHelper.findIcon((String)"boolean"));
    private static final ImageIcon SPARSE_ICON = new ImageIcon(FindIconHelper.findIcon((String)"sparse"));
    private static final ImageIcon INT_ICON = new ImageIcon(FindIconHelper.findIcon((String)"int"));
    private static final ImageIcon HANDLE_ICON = new ImageIcon(FindIconHelper.findIcon((String)"handle"));
    private static final ImageIcon STRING_ICON = new ImageIcon(FindIconHelper.findIcon((String)"string"));
    private static final ImageIcon FUNCTION_ICON = new ImageIcon(FindIconHelper.findIcon((String)"function"));
    private static final ImageIcon LIST_ICON = new ImageIcon(FindIconHelper.findIcon((String)"list"));
    private static final ImageIcon TLIST_ICON = new ImageIcon(FindIconHelper.findIcon((String)"tlist"));
    private static final ImageIcon MLIST_ICON = new ImageIcon(FindIconHelper.findIcon((String)"mlist"));
    private static final ImageIcon CELL_ICON = new ImageIcon(FindIconHelper.findIcon((String)"cell"));
    private static final ImageIcon USER_ICON = new ImageIcon(FindIconHelper.findIcon((String)"user"));
    private static final ImageIcon FPTR_ICON = new ImageIcon(FindIconHelper.findIcon((String)"fptr"));

    private BrowseVar() {
    }

    private static ImageIcon getIconFromType(int n) {
        switch (n) {
            case 1: {
                return DOUBLE_ICON;
            }
            case 2: {
                return POLYNOMIAL_ICON;
            }
            case 4: {
                return BOOLEAN_ICON;
            }
            case 5: 
            case 6: 
            case 7: {
                return SPARSE_ICON;
            }
            case 8: {
                return INT_ICON;
            }
            case 9: {
                return HANDLE_ICON;
            }
            case 10: {
                return STRING_ICON;
            }
            case 11: 
            case 13: {
                return FUNCTION_ICON;
            }
            case 15: {
                return LIST_ICON;
            }
            case 16: {
                return TLIST_ICON;
            }
            case 17: 
            case 18: {
                return MLIST_ICON;
            }
            case 19: {
                return CELL_ICON;
            }
            case 128: {
                return USER_ICON;
            }
            case 130: {
                return FPTR_ICON;
            }
        }
        return NO_ICON;
    }

    public static void openVariableBrowser() {
        ScilabVariableBrowser.openVariableBrowser();
    }

    public static void setVariableBrowserData(String[] stringArray, long[] lArray, int[] nArray, int[] nArray2, String[] stringArray2, String[] stringArray3, int[] nArray3, int[] nArray4, String[] stringArray4, boolean[] blArray) {
        Object[][] objectArray = new Object[stringArray.length][COLUMNNAMES.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i][0] = BrowseVar.getIconFromType(nArray[i]);
            objectArray[i][1] = stringArray[i];
            objectArray[i][2] = stringArray3[i];
            objectArray[i][3] = ScilabTypeEnumDescription.getTypeDescriptionFromId((int)nArray[i]);
            if (nArray[i] == ScilabTypeEnum.sci_ints.swigValue() && nArray2[i] != 0) {
                objectArray[i][3] = String.valueOf(objectArray[i][3]) + " " + nArray2[i];
            }
            if (!(nArray[i] != ScilabTypeEnum.sci_tlist.swigValue() && nArray[i] != ScilabTypeEnum.sci_mlist.swigValue() || stringArray2[i].equals(""))) {
                String string = ScilabTypeEnumDescription.getListTypeDescription((String)stringArray2[i]);
                objectArray[i][3] = string + " (" + String.valueOf(objectArray[i][3]) + ")";
            }
            objectArray[i][4] = stringArray4[i];
            objectArray[i][5] = BrowseVar.humanReadableByteCount(lArray[i], true);
            objectArray[i][6] = blArray[i];
            objectArray[i][7] = nArray[i];
            objectArray[i][8] = nArray3[i];
            objectArray[i][9] = nArray4[i];
        }
        ScilabVariableBrowser.setVariableBrowserData(objectArray);
    }

    public static String humanReadableByteCount(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1000 : 1024;
        if (l < (long)n) {
            return l + " B";
        }
        int n3 = (int)(Math.log(l) / Math.log(n));
        String string = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.1f %sB", (double)l / Math.pow(n, n3), string);
    }

    public static void updateVariableBrowserData() {
        ScilabVariableBrowser.updateVariableBrowser();
    }

    public static boolean isVariableBrowserOpened() {
        return ScilabVariableBrowser.isBrowseVarOpened();
    }

    public static void closeVariableBrowser() {
        ScilabVariableBrowser.closeVariableBrowser();
    }
}

