/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.utils;

import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.SurfaceData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.CallRenderer;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.utils.AxesHandler;
import org.scilab.modules.renderer.utils.CommonHandler;
import org.scilab.modules.renderer.utils.DatatipCommon;
import org.scilab.modules.renderer.utils.LegendHandler;
import org.scilab.modules.renderer.utils.ObjectSearcher;

public class EntityPicker {
    private static final int EPS = 2;

    public Integer pick(Integer n, Integer n2, Integer n3) {
        Integer[] integerArray = new Integer[]{n2, n3};
        Integer[] integerArray2 = AxesHandler.clickedAxes(n, integerArray);
        if (integerArray2 == null) {
            return null;
        }
        double[] dArray = new double[]{n2.doubleValue(), n3.doubleValue(), 1.0};
        for (Integer n4 : integerArray2) {
            Integer[] integerArray3;
            double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates(n4, dArray);
            if (AxesHandler.isZoomBoxEnabled(n4).booleanValue() && !AxesHandler.isInZoomBoxBounds(n4, dArray2[0], dArray2[1]).booleanValue() || (integerArray3 = new ObjectSearcher().search(n4, 15)) == null) continue;
            for (int i = 0; i < integerArray3.length; ++i) {
                if (!CommonHandler.isVisible(integerArray3[i]).booleanValue()) continue;
                if (CommonHandler.isLineEnabled(integerArray3[i]).booleanValue() && this.isOverLine(n4, integerArray3[i], n2, n3) != -1) {
                    return integerArray3[i];
                }
                if (CommonHandler.isMarkEnabled(integerArray3[i]).booleanValue() && this.isOverMark(n4, integerArray3[i], n2, n3) != -1) {
                    return integerArray3[i];
                }
                if (CommonHandler.isLineEnabled(integerArray3[i]).booleanValue() || this.isOverDot(n4, integerArray3[i], n2, n3) == -1) continue;
                return integerArray3[i];
            }
        }
        return null;
    }

    public static DatatipCommon.Segment getSegment(Integer n, int n2) {
        double[] dArray = (double[])PolylineData.getDataX((int)n);
        double[] dArray2 = (double[])PolylineData.getDataY((int)n);
        double[] dArray3 = (double[])PolylineData.getDataZ((int)n);
        if (dArray.length == 1) {
            return new DatatipCommon.Segment(0, dArray[0], dArray[0], dArray2[0], dArray2[0], dArray3[0], dArray3[0]);
        }
        if (n2 <= 0) {
            return new DatatipCommon.Segment(0, dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1]);
        }
        if (n2 >= dArray.length - 1) {
            return new DatatipCommon.Segment(dArray.length - 2, dArray[dArray.length - 2], dArray[dArray.length - 1], dArray2[dArray2.length - 2], dArray2[dArray2.length - 1], dArray3[dArray3.length - 2], dArray3[dArray3.length - 1]);
        }
        return new DatatipCommon.Segment(n2, dArray[n2], dArray[n2 + 1], dArray2[n2], dArray2[n2 + 1], dArray2[n2], dArray2[n2 + 1]);
    }

    public static double[] getSegment(Integer n, Integer n2, int n3, int n4, int n5) {
        Integer n6 = new ObjectSearcher().searchParent(n2, 1);
        double[][] dArray = EntityPicker.getPixelsData(n6, n2);
        double[] dArray2 = dArray[n3];
        double[] dArray3 = dArray[n3 + 1];
        double d = dArray3[0] - dArray2[0];
        double d2 = dArray3[1] - dArray2[1];
        double d3 = ((double)n4 - dArray2[0]) * d + ((double)n5 - dArray2[1]) * d2;
        double[] dArray4 = new double[]{n3, 0.0};
        if (0.0 <= d3) {
            double d4 = d * d + d2 * d2;
            dArray4[1] = d3 <= d4 ? d3 / d4 : 1.0;
        }
        return dArray4;
    }

    public static double[][] getPixelsData(Integer n, Integer n2) {
        int n3;
        double[] dArray;
        double[] dArray2 = (double[])PolylineData.getDataX((int)n2);
        double[] dArray3 = (double[])PolylineData.getDataY((int)n2);
        double[] dArray4 = (double[])PolylineData.getDataZ((int)n2);
        int n4 = dArray2.length;
        if (PolylineData.isXShiftSet((int)n2) != 0) {
            dArray = (double[])PolylineData.getShiftX((int)n2);
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = n3;
                dArray2[n5] = dArray2[n5] + dArray[n3];
            }
        }
        if (PolylineData.isYShiftSet((int)n2) != 0) {
            dArray = (double[])PolylineData.getShiftY((int)n2);
            for (n3 = 0; n3 < n4; ++n3) {
                int n6 = n3;
                dArray3[n6] = dArray3[n6] + dArray[n3];
            }
        }
        if (PolylineData.isZShiftSet((int)n2) != 0) {
            dArray = (double[])PolylineData.getShiftZ((int)n2);
            for (n3 = 0; n3 < n4; ++n3) {
                int n7 = n3;
                dArray4[n7] = dArray4[n7] + dArray[n3];
            }
        }
        return CallRenderer.getPixelFrom3dCoordinates(n, dArray2, dArray3, dArray4);
    }

    public static double[] getNearestSegmentIndex(double[][] dArray, double d, double d2) {
        if (dArray != null && dArray.length >= 1) {
            double d3;
            double[] dArray2;
            int n = 0;
            double d4 = Double.MAX_VALUE;
            for (int i = 0; i < dArray.length - 1; ++i) {
                double d5;
                dArray2 = dArray[i];
                double d6 = d - dArray2[0];
                double[] dArray3 = dArray[i + 1];
                double d7 = dArray3[0] - dArray2[0];
                d3 = d2 - dArray2[1];
                double d8 = dArray3[1] - dArray2[1];
                double d9 = d6 * d7 + d3 * d8;
                double d10 = 0.0 <= d9 ? (d9 <= (d5 = d7 * d7 + d8 * d8) ? d6 * d6 + d3 * d3 - d9 * d9 / d5 : (d - dArray3[0]) * (d - dArray3[0]) + (d2 - dArray3[1]) * (d2 - dArray3[1])) : d6 * d6 + d3 * d3;
                if (!(d10 < d4)) continue;
                d4 = d10;
                n = i;
            }
            double[] dArray4 = dArray[n];
            dArray2 = dArray[n + 1];
            double d11 = dArray2[0] - dArray4[0];
            double d12 = dArray2[1] - dArray4[1];
            double d13 = (d - dArray4[0]) * d11 + (d2 - dArray4[1]) * d12;
            double[] dArray5 = new double[]{n, 0.0};
            if (0.0 <= d13) {
                d3 = d11 * d11 + d12 * d12;
                dArray5[1] = d13 <= d3 ? d13 / d3 : 1.0;
            }
            return dArray5;
        }
        return null;
    }

    public static double[] getNearestSegmentIndex(double[][] dArray, double d, double d2, double d3) {
        if (dArray != null && dArray.length >= 1) {
            double d4;
            double[] dArray2;
            int n = 0;
            double d5 = Double.MAX_VALUE;
            for (int i = 0; i < dArray.length - 1; ++i) {
                double d6;
                dArray2 = dArray[i];
                double d7 = d - dArray2[0];
                double[] dArray3 = dArray[i + 1];
                double d8 = dArray3[0] - dArray2[0];
                d4 = d2 - dArray2[1];
                double d9 = dArray3[1] - dArray2[1];
                double d10 = d3 - dArray2[2];
                double d11 = dArray3[2] - dArray2[2];
                double d12 = d7 * d8 + d4 * d9 + d10 * d11;
                double d13 = 0.0 <= d12 ? (d12 <= (d6 = d8 * d8 + d9 * d9 + d11 * d11) ? d7 * d7 + d4 * d4 + d10 * d10 - d12 * d12 / d6 : (d - dArray3[0]) * (d - dArray3[0]) + (d2 - dArray3[1]) * (d2 - dArray3[1]) + (d3 - dArray3[2]) * (d3 - dArray3[2])) : d7 * d7 + d4 * d4 + d10 * d10;
                if (!(d13 < d5)) continue;
                d5 = d13;
                n = i;
            }
            double[] dArray4 = dArray[n];
            dArray2 = dArray[n + 1];
            double d14 = dArray2[0] - dArray4[0];
            double d15 = dArray2[1] - dArray4[1];
            double d16 = dArray2[2] - dArray4[2];
            double d17 = (d - dArray4[0]) * d14 + (d2 - dArray4[1]) * d15 + (d3 - dArray4[2]) * d16;
            double[] dArray5 = new double[]{n, 0.0};
            if (0.0 <= d17) {
                d4 = d14 * d14 + d15 * d15 + d16 * d16;
                dArray5[1] = d17 <= d4 ? d17 / d4 : 1.0;
            }
            return dArray5;
        }
        return null;
    }

    public static double[] getNearestSegmentIndex(Integer n, Integer n2, int n3, int n4) {
        return EntityPicker.getNearestSegmentIndex(EntityPicker.getPixelsData(n, n2), (double)n3, (double)n4);
    }

    public static double[] getNearestSegmentIndex(Integer n, double d, double d2, double d3) {
        return EntityPicker.getNearestSegmentIndex(DatatipCommon.getPolylineDataMatrix(n, false), d, d2, d3);
    }

    public static double[] getNearestSegmentIndex(Integer n, double d, double d2) {
        return EntityPicker.getNearestSegmentIndex(DatatipCommon.getPolylineDataMatrix(n, true), d, d2);
    }

    private int isOverLine(Integer n, Integer n2, int n3, int n4) {
        double[][] dArray = EntityPicker.getPixelsData(n, n2);
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d;
            double d2;
            double[] dArray2 = dArray[i];
            double d3 = (double)n3 - dArray2[0];
            double[] dArray3 = dArray[i + 1];
            double d4 = dArray3[0] - dArray2[0];
            double d5 = (double)n4 - dArray2[1];
            double d6 = dArray3[1] - dArray2[1];
            double d7 = d3 * d4 + d5 * d6;
            if (!(0.0 <= d7) || !(d7 <= (d2 = d4 * d4 + d6 * d6)) || !((d = d3 * d3 + d5 * d5 - d7 * d7 / d2) <= 4.0)) continue;
            return i;
        }
        return -1;
    }

    private int isOverDot(Integer n, Integer n2, int n3, int n4) {
        double[][] dArray = EntityPicker.getPixelsData(n, n2);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs((double)n3 - dArray[i][0]) <= 3.0) || !(Math.abs((double)n4 - dArray[i][1]) <= 3.0)) continue;
            return i;
        }
        return -1;
    }

    private int isOverBar(Integer n, Integer n2, int n3, int n4, int n5) {
        double[][] dArray = EntityPicker.getPixelsData(n, n2);
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs((double)n3 - dArray[i][0]) <= (double)n5) || !(Math.abs((double)n4 - dArray[i][1]) <= 2.0)) continue;
            return i;
        }
        return -1;
    }

    private int isOverMark(Integer n, Integer n2, int n3, int n4) {
        double[][] dArray = EntityPicker.getPixelsData(n, n2);
        Integer n5 = CommonHandler.getMarkSize(n2);
        Integer n6 = CommonHandler.getMarkSizeUnit(n2);
        int n7 = n6 == 1 ? 8 + 2 * n5 : n5;
        n7 /= 2;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs((double)n3 - dArray[i][0]) <= (double)n7) || !(Math.abs((double)n4 - dArray[i][1]) <= (double)n7)) continue;
            return i;
        }
        return -1;
    }

    public PickedPoint pickPoint(Integer n, int n2, int n3) {
        PickedPoint pickedPoint = new PickedPoint(-1, false);
        Integer[] integerArray = new Integer[]{n2, n3};
        Integer n4 = new ObjectSearcher().searchParent(n, 8);
        Integer[] integerArray2 = AxesHandler.clickedAxes(n4, integerArray);
        if (integerArray2 == null) {
            return pickedPoint;
        }
        for (Integer n5 : integerArray2) {
            if (CommonHandler.isMarkEnabled(n).booleanValue()) {
                pickedPoint.point = this.isOverMark(n5, n, n2, n3);
                if (pickedPoint.point != -1) {
                    return pickedPoint;
                }
            }
            if (CommonHandler.isLineEnabled(n).booleanValue()) {
                pickedPoint.point = this.isOverLine(n5, n, n2, n3);
                pickedPoint.isSegment = true;
            } else {
                pickedPoint.point = this.isOverDot(n5, n, n2, n3);
            }
            if (pickedPoint.point == -1) continue;
            return pickedPoint;
        }
        return pickedPoint;
    }

    private boolean isInDefaultView(Axes axes) {
        Double[] doubleArray = axes.getRotationAngles();
        return doubleArray[0] == 0.0 && doubleArray[1] == 270.0;
    }

    private double[] transformPoint(Axes axes, double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        return AxesDrawer.compute2dViewCoordinates(axes, dArray);
    }

    public LegendInfo pickLegend(Integer n, Integer[] integerArray) {
        Integer[] integerArray2 = AxesHandler.clickedAxes(n, integerArray);
        if (integerArray2 == null) {
            return null;
        }
        Integer n2 = null;
        Integer doubleArray2 = null;
        for (Integer doubleArray3 : integerArray2) {
            n2 = LegendHandler.searchLegend(doubleArray3);
            if (n2 == null) continue;
            doubleArray2 = doubleArray3;
            break;
        }
        if (n2 == null) {
            return null;
        }
        Integer[] integerArray3 = new Integer[]{0, 0};
        Double[] doubleArray = new Double[]{0.0, 0.0};
        Double[] doubleArray3 = new Double[]{0.0, 0.0};
        Double[] doubleArray4 = new Double[]{0.0, 0.0};
        Double[] doubleArray5 = new Double[]{0.0, 0.0, 0.0, 0.0};
        Double[] doubleArray6 = new Double[]{0.0, 0.0};
        AxesContainer axesContainer = (AxesContainer)GraphicController.getController().getObjectFromId(n);
        integerArray3 = axesContainer.getAxesSize();
        Double[] doubleArray7 = (Double[])GraphicController.getController().getProperty(doubleArray2, 186);
        doubleArray4 = (Double[])GraphicController.getController().getProperty(n2, 80);
        Integer[] integerArray4 = (Integer[])GraphicController.getController().getProperty(n2, 234);
        doubleArray3[0] = ((double)integerArray[0].intValue() - doubleArray7[0] * (double)integerArray3[0].intValue()) / (doubleArray7[2] * (double)integerArray3[0].intValue());
        doubleArray3[1] = ((double)integerArray[1].intValue() - doubleArray7[1] * (double)integerArray3[1].intValue()) / (doubleArray7[3] * (double)integerArray3[1].intValue());
        doubleArray6 = (Double[])GraphicController.getController().getProperty(n2, 81);
        doubleArray5[0] = doubleArray4[0];
        doubleArray5[1] = doubleArray4[1];
        doubleArray5[2] = doubleArray4[0] + doubleArray6[0];
        doubleArray5[3] = doubleArray4[1] + doubleArray6[1];
        Double d = doubleArray6[1] / (1.0 * (double)integerArray4.length);
        if (doubleArray3[0] >= doubleArray5[0] && doubleArray3[0] <= doubleArray5[2] && doubleArray3[1] >= doubleArray5[1] && doubleArray3[1] <= doubleArray5[3]) {
            Integer n3 = 0;
            while (n3 < integerArray4.length) {
                if (doubleArray3[1] >= doubleArray5[1] + (double)n3.intValue() * d && doubleArray3[1] <= doubleArray5[1] + (double)(n3 + 1) * d) {
                    return new LegendInfo(n2, integerArray4[integerArray4.length - 1 - n3]);
                }
                Integer n4 = n3;
                n3 = n3 + 1;
            }
        }
        return null;
    }

    public static AxesHandler.axisTo pickLabel(Integer n, Integer[] integerArray) {
        Integer[] integerArray2 = AxesHandler.clickedAxes(n, integerArray);
        if (integerArray2 == null) {
            return null;
        }
        Double d = 0.0;
        int n2 = 0;
        double[] dArray = new double[3];
        for (Integer n3 : integerArray2) {
            Integer[] integerArray3 = new Integer[]{(Integer)GraphicController.getController().getProperty(n3, 115), (Integer)GraphicController.getController().getProperty(n3, 132), (Integer)GraphicController.getController().getProperty(n3, 149), (Integer)GraphicController.getController().getProperty(n3, 163)};
            boolean[] blArray = new boolean[]{(Boolean)GraphicController.getController().getProperty(n3, 117), (Boolean)GraphicController.getController().getProperty(n3, 134)};
            Integer n4 = 0;
            while (n4 < 4) {
                Double[] doubleArray = (Double[])GraphicController.getController().getProperty(integerArray3[n4], 232);
                d = (Double)GraphicController.getController().getProperty(integerArray3[n4], 230);
                n2 = (int)(d * 2.0 / Math.PI) % 2;
                if (n2 == 1) {
                    doubleArray = EntityPicker.rotateCorners(doubleArray);
                }
                dArray[0] = integerArray[0].intValue();
                dArray[1] = integerArray[1].intValue();
                dArray[2] = 1.0;
                double[] dArray2 = CallRenderer.get2dViewFromPixelCoordinates(n3, dArray);
                dArray2[0] = CommonHandler.InverseLogScale(dArray2[0], blArray[0]);
                dArray2[1] = CommonHandler.InverseLogScale(dArray2[1], blArray[1]);
                if ((dArray2[0] >= doubleArray[0] && dArray2[0] <= doubleArray[6] || dArray2[0] <= doubleArray[0] && dArray2[0] >= doubleArray[6]) && (dArray2[1] >= doubleArray[1] && dArray2[1] <= doubleArray[4] || dArray2[1] <= doubleArray[1] && dArray2[1] >= doubleArray[4])) {
                    switch (n4) {
                        case 0: {
                            return AxesHandler.axisTo.__X__;
                        }
                        case 1: {
                            return AxesHandler.axisTo.__Y__;
                        }
                        case 2: {
                            return AxesHandler.axisTo.__Z__;
                        }
                        case 3: {
                            return AxesHandler.axisTo.__TITLE__;
                        }
                    }
                }
                Integer n5 = n4;
                n4 = n4 + 1;
            }
        }
        return null;
    }

    private static Double[] rotateCorners(Double[] doubleArray) {
        Integer n = doubleArray.length;
        Double[] doubleArray2 = new Double[n.intValue()];
        Integer n2 = 0;
        while (n2 < n - 3) {
            doubleArray2[n2.intValue() + 3] = doubleArray[n2];
            Integer n3 = n2;
            n2 = n2 + 1;
        }
        doubleArray2[0] = doubleArray[n - 3];
        doubleArray2[1] = doubleArray[n - 2];
        doubleArray2[2] = doubleArray[n - 1];
        return doubleArray2;
    }

    public SurfaceInfo pickSurface(Integer n, Integer[] integerArray) {
        Integer[] integerArray2;
        for (Integer n2 : integerArray2 = AxesHandler.clickedAxes(n, integerArray)) {
            Axes axes = (Axes)GraphicController.getController().getObjectFromId(n2);
            if (axes == null) {
                return null;
            }
            double[][] dArray = axes.getScaleTranslateFactors();
            Vector3d vector3d = AxesDrawer.unProject(axes, new Vector3d((double)(1.0f * (float)integerArray[0].intValue()), (double)(1.0f * (float)integerArray[1].intValue()), 0.0));
            Vector3d vector3d2 = AxesDrawer.unProject(axes, new Vector3d((double)(1.0f * (float)integerArray[0].intValue()), (double)(1.0f * (float)integerArray[1].intValue()), 1.0));
            vector3d = new Vector3d((vector3d.getX() - dArray[1][0]) / dArray[0][0], (vector3d.getY() - dArray[1][1]) / dArray[0][1], (vector3d.getZ() - dArray[1][2]) / dArray[0][2]);
            vector3d2 = new Vector3d((vector3d2.getX() - dArray[1][0]) / dArray[0][0], (vector3d2.getY() - dArray[1][1]) / dArray[0][1], (vector3d2.getZ() - dArray[1][2]) / dArray[0][2]);
            Vector3d vector3d3 = vector3d.minus(vector3d2).getNormalized();
            Integer[] integerArray3 = new Integer[]{14, 6, 10};
            Integer[] integerArray4 = new ObjectSearcher().searchMultiple(n, integerArray3);
            double d = Double.NEGATIVE_INFINITY;
            SurfaceInfo surfaceInfo = new SurfaceInfo();
            if (integerArray4 == null) continue;
            for (int i = 0; i < integerArray4.length; ++i) {
                double d2 = SurfaceData.pickSurface((int)integerArray4[i], (double)vector3d.getX(), (double)vector3d.getY(), (double)vector3d.getZ(), (double)vector3d3.getX(), (double)vector3d3.getY(), (double)vector3d3.getZ());
                if (!(d2 > d)) continue;
                d = d2;
                surfaceInfo.surface = integerArray4[i];
            }
            if (surfaceInfo.surface == null) continue;
            surfaceInfo.point = new Vector3d(vector3d.plus(vector3d3.times(d)));
            return surfaceInfo;
        }
        return null;
    }

    public Integer pickDatatip(Integer n, Integer[] integerArray) {
        Integer[] integerArray2 = AxesHandler.clickedAxes(n, integerArray);
        if (integerArray2 == null) {
            return null;
        }
        for (Integer n2 : integerArray2) {
            Integer[] integerArray3 = new ObjectSearcher().search(n2, 338, true);
            if (integerArray3 == null) continue;
            int n3 = integerArray[0];
            int n4 = integerArray[1];
            for (int i = 0; i < integerArray3.length; ++i) {
                Double[] doubleArray = (Double[])GraphicController.getController().getProperty(integerArray3[i], 339);
                double[] dArray = new double[]{doubleArray[0], doubleArray[1], doubleArray[2]};
                double[] dArray2 = CallRenderer.getPixelFrom3dCoordinates(n2, dArray);
                Integer n5 = CommonHandler.getMarkSize(integerArray3[i]);
                Integer n6 = CommonHandler.getMarkSizeUnit(integerArray3[i]);
                int n7 = n6 == 1 ? 8 + 2 * n5 : n5;
                n7 /= 2;
                if (!(Math.abs((double)n3 - dArray2[0]) <= (double)n7) || !(Math.abs((double)n4 - dArray2[1]) <= (double)n7)) continue;
                return integerArray3[i];
            }
        }
        return null;
    }

    public static class PickedPoint {
        public int point;
        public boolean isSegment;

        PickedPoint(int n, boolean bl) {
            this.point = n;
            this.isSegment = bl;
        }

        public String toString() {
            return "Point: " + this.point + ", isSegment=" + this.isSegment;
        }
    }

    public static class LegendInfo {
        public Integer legend = null;
        public Integer polyline = null;

        LegendInfo(Integer n, Integer n2) {
            this.legend = n;
            this.polyline = n2;
        }
    }

    public class SurfaceInfo {
        public Integer surface = null;
        public Vector3d point = null;
    }
}

