/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.util;

import com.jogamp.opengl.util.GLBuffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

public final class BufferAllocation {
    private static final int REMAINING_MEMORY = 0x2000000;

    private BufferAllocation() {
    }

    public static ByteBuffer newByteBuffer(int n) throws OutOfMemoryException {
        BufferAllocation.haveFreeMemory(n);
        ByteBuffer byteBuffer = GLBuffers.newDirectByteBuffer((int)n);
        if (byteBuffer.limit() != n) {
            throw new OutOfMemoryException();
        }
        return byteBuffer;
    }

    public static IntBuffer newIntBuffer(int n) throws OutOfMemoryException {
        BufferAllocation.haveFreeMemory(n * 32 / 8);
        IntBuffer intBuffer = GLBuffers.newDirectIntBuffer((int)n);
        if (intBuffer.limit() != n) {
            throw new OutOfMemoryException();
        }
        return intBuffer;
    }

    public static FloatBuffer newFloatBuffer(int n) throws OutOfMemoryException {
        BufferAllocation.haveFreeMemory(n * 32 / 8);
        FloatBuffer floatBuffer = GLBuffers.newDirectFloatBuffer((int)n);
        if (floatBuffer.limit() != n) {
            throw new OutOfMemoryException();
        }
        return floatBuffer;
    }

    private static void haveFreeMemory(int n) throws OutOfMemoryException {
        long l;
        long l2;
        long l3 = Runtime.getRuntime().maxMemory();
        long l4 = l3 - (l2 = Runtime.getRuntime().totalMemory()) + (l = Runtime.getRuntime().freeMemory());
        if (l4 < (long)(n + 0x2000000)) {
            Runtime.getRuntime().gc();
            l2 = Runtime.getRuntime().totalMemory();
            l = Runtime.getRuntime().freeMemory();
        }
        if ((l4 = l3 - l2 + l) < (long)(n + 0x2000000)) {
            throw new OutOfMemoryException();
        }
    }
}

