/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.datatip;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.polyline.Polyline;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;

public class DatatipDisplayModeManager {
    List<Integer> clicked_datatips = new LinkedList<Integer>();
    Integer hover = 0;
    private Map<Integer, Position> datatips = new HashMap<Integer, Position>();

    public DatatipDisplayModeManager(Component component) {
        if (component != null) {
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DatatipDisplayModeManager.this.onMouseClick(mouseEvent.getX(), mouseEvent.getY());
                }
            });
            component.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    DatatipDisplayModeManager.this.onMouseMove(mouseEvent.getX(), mouseEvent.getY());
                }
            });
        }
    }

    public void add(Integer n) {
        GraphicController graphicController = GraphicController.getController();
        Datatip datatip = (Datatip)graphicController.getObjectFromId(n);
        Double[] doubleArray = datatip.getTipData();
        Integer n2 = (Integer)graphicController.getProperty(n, 32);
        Axes axes = (Axes)graphicController.getObjectFromId(n2);
        if (axes != null) {
            double[] dArray = AxesDrawer.computePixelFrom3dCoordinates(axes, new double[]{doubleArray[0], doubleArray[1], doubleArray[2]});
            this.datatips.put(n, new Position(dArray[0], dArray[1]));
        }
    }

    public void remove(Integer n) {
        this.datatips.remove(n);
        this.clicked_datatips.remove(n);
    }

    public boolean needDraw(Integer n) {
        this.add(n);
        GraphicController graphicController = GraphicController.getController();
        Integer n2 = (Integer)graphicController.getProperty(n, 24);
        Integer n3 = (Integer)graphicController.getProperty(n2, 360);
        Polyline.DatatipDisplayMode datatipDisplayMode = Polyline.DatatipDisplayMode.intToEnum((Integer)n3);
        switch (datatipDisplayMode) {
            case ALWAYS: {
                return true;
            }
            case MOUSECLICK: {
                return this.clicked_datatips.contains(n);
            }
            case MOUSEOVER: {
                return this.hover.equals(n);
            }
        }
        return true;
    }

    private Integer get(int n, int n2) {
        for (Map.Entry<Integer, Position> entry : this.datatips.entrySet()) {
            Integer n3 = entry.getKey();
            Position position = entry.getValue();
            double d = (position.x - (double)n * 1.0) * (position.x - (double)n * 1.0);
            double d2 = (position.y - (double)n2 * 1.0) * (position.y - (double)n2 * 1.0);
            if (!(d + d2 < 20.0)) continue;
            return n3;
        }
        return 0;
    }

    public void onMouseMove(int n, int n2) {
        Integer n3 = this.get(n, n2);
        if (n3 > 0) {
            if (!this.hover.equals(n3)) {
                this.hover = n3;
                GraphicController.getController().setProperty(n3, 30, (Object)0);
            }
        } else if (this.hover != 0) {
            GraphicController.getController().setProperty(this.hover, 30, (Object)0);
            this.hover = 0;
        }
    }

    public void onMouseClick(int n, int n2) {
        Integer n3 = this.get(n, n2);
        if (n3 > 0) {
            if (this.clicked_datatips.contains(n3)) {
                this.clicked_datatips.remove(n3);
            } else {
                this.clicked_datatips.add(n3);
            }
            GraphicController.getController().setProperty(n3, 30, (Object)0);
        }
    }

    static class Position {
        public double x;
        public double y;

        public Position(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

