/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.axes.ruler;

import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.IllegalFormatConversionException;
import java.util.UnknownFormatConversionException;
import org.scilab.forge.scirenderer.ruler.RulerSpriteFactory;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.axes.AxisProperty;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.textObject.FormattedText;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.FormattedTextSpriteDrawer;
import org.scilab.modules.renderer.utils.textRendering.FontManager;

public class AxesRulerSpriteFactory
implements RulerSpriteFactory {
    private static final String MULTIPLICATION_SYMBOL = "x";
    private static final float EXPONENT_SIZE_RATIO = 0.4f;
    private final AxisProperty axisProperty;
    private final ColorMap colorMap;

    public AxesRulerSpriteFactory(Axes axes, int n) {
        ColorMap colorMap;
        this.axisProperty = axes.getAxes()[n];
        try {
            GraphicController graphicController = GraphicController.getController();
            AxesContainer axesContainer = (AxesContainer)graphicController.getObjectFromId(axes.getParentFigure());
            colorMap = axesContainer.getColorMap();
        }
        catch (NullPointerException nullPointerException) {
            colorMap = null;
        }
        this.colorMap = colorMap;
    }

    public Texture create(double d, DecimalFormat decimalFormat, TextureManager textureManager) {
        if (d == 0.0) {
            d = 0.0;
        }
        if (this.axisProperty.getAutoTicks().booleanValue()) {
            AxesRulerSpriteFactory.setScilabStyle(decimalFormat);
            if (this.axisProperty.getLogFlag().booleanValue()) {
                return this.createScientificStyleSprite(d, textureManager);
            }
            String string = null;
            if (this.axisProperty.getFormat().isEmpty()) {
                string = decimalFormat.format(d);
            } else {
                Double[] doubleArray = this.axisProperty.getSTFactors();
                double d2 = doubleArray[0] * (d - doubleArray[1]);
                try {
                    string = String.format(this.axisProperty.getFormat(), d2);
                }
                catch (IllegalFormatConversionException illegalFormatConversionException) {
                    try {
                        string = String.format(this.axisProperty.getFormat(), (int)d2);
                    }
                    catch (IllegalFormatConversionException illegalFormatConversionException2) {
                        string = decimalFormat.format(d);
                    }
                }
                catch (UnknownFormatConversionException unknownFormatConversionException) {
                    string = decimalFormat.format(d);
                }
            }
            return this.createSimpleSprite(string, textureManager);
        }
        FormattedText formattedText = this.getTextAtValue(d);
        if (formattedText != null && formattedText.getText() != null && !formattedText.getText().isEmpty()) {
            FormattedTextSpriteDrawer formattedTextSpriteDrawer = new FormattedTextSpriteDrawer(this.colorMap, formattedText);
            Texture texture = textureManager.createTexture();
            texture.setMagnificationFilter(Texture.Filter.LINEAR);
            texture.setMinifyingFilter(Texture.Filter.LINEAR);
            texture.setDrawer((TextureDrawer)formattedTextSpriteDrawer);
            return texture;
        }
        return null;
    }

    public static void setScilabStyle(DecimalFormat decimalFormat) {
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setExponentSeparator("e");
        decimalFormatSymbols.setGroupingSeparator('\u00a0');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    private Texture createScientificStyleSprite(double d, TextureManager textureManager) {
        Integer n = (int)Math.floor(Math.log10(d));
        Double d2 = d / Math.pow(10.0, n.intValue());
        final TextEntity textEntity = (d2 = Double.valueOf((double)Math.round(d2 * 1000000.0) * 1.0E-6)) != 1.0 ? new TextEntity(d2.toString() + "x10") : new TextEntity("10");
        Font font = FontManager.getSciFontManager().getFontFromIndex(this.axisProperty.getFontStyle(), this.axisProperty.getFontSize());
        textEntity.setTextAntiAliased(true);
        textEntity.setTextUseFractionalMetrics(this.axisProperty.getFontFractional().booleanValue());
        textEntity.setTextColor(ColorFactory.createColor(this.colorMap, this.axisProperty.getFontColor()));
        textEntity.setFont(font);
        final Dimension dimension = textEntity.getSize();
        final TextEntity textEntity2 = new TextEntity(n.toString());
        Font font2 = FontManager.getSciFontManager().getFontFromIndex(this.axisProperty.getFontStyle(), this.axisProperty.getFontSize() * (double)0.4f);
        textEntity2.setTextAntiAliased(true);
        textEntity2.setTextUseFractionalMetrics(this.axisProperty.getFontFractional().booleanValue());
        textEntity2.setTextColor(ColorFactory.createColor(this.colorMap, this.axisProperty.getFontColor()));
        textEntity2.setFont(font2);
        final int n2 = (int)textEntity2.getLayout().getBounds().getHeight();
        final Dimension dimension2 = textEntity2.getSize();
        Texture texture = textureManager.createTexture();
        texture.setDrawer(new TextureDrawer(){

            public void draw(TextureDrawingTools textureDrawingTools) {
                textureDrawingTools.draw(textEntity, 0, n2);
                textureDrawingTools.draw(textEntity2, dimension.width, 0);
            }

            public Dimension getTextureSize() {
                return new Dimension(dimension2.width + dimension.width, n2 + dimension.height);
            }

            public TextureDrawer.OriginPosition getOriginPosition() {
                return TextureDrawer.OriginPosition.UPPER_LEFT;
            }
        });
        return texture;
    }

    private Texture createSimpleSprite(String string, TextureManager textureManager) {
        Font font = FontManager.getSciFontManager().getFontFromIndex(this.axisProperty.getFontStyle(), this.axisProperty.getFontSize());
        final TextEntity textEntity = new TextEntity(string);
        textEntity.setTextAntiAliased(true);
        textEntity.setTextUseFractionalMetrics(this.axisProperty.getFontFractional().booleanValue());
        textEntity.setTextColor(ColorFactory.createColor(this.colorMap, this.axisProperty.getFontColor()));
        textEntity.setFont(font);
        Texture texture = textureManager.createTexture();
        texture.setDrawer(new TextureDrawer(){

            public void draw(TextureDrawingTools textureDrawingTools) {
                textureDrawingTools.draw(textEntity, 0, 0);
            }

            public Dimension getTextureSize() {
                return textEntity.getSize();
            }

            public TextureDrawer.OriginPosition getOriginPosition() {
                return TextureDrawer.OriginPosition.UPPER_LEFT;
            }
        });
        return texture;
    }

    private FormattedText getTextAtValue(double d) {
        Double[] doubleArray = this.axisProperty.getTicksLocations();
        int n = -1;
        for (int i = 0; i < doubleArray.length; ++i) {
            if (doubleArray[i] != d) continue;
            n = i;
            break;
        }
        if (n == -1 || n >= this.axisProperty.getTicksLabels().size()) {
            return null;
        }
        return (FormattedText)this.axisProperty.getTicksLabels().get(n);
    }
}

