/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.ObjectStreamException;
import java.nio.DoubleBuffer;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabDoubleReference
extends ScilabDouble {
    private final DoubleBuffer realBuffer;
    private final DoubleBuffer imaginaryBuffer;
    private final int nbRows;
    private final int nbCols;

    ScilabDoubleReference(String string, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, int n, int n2) {
        this.realBuffer = doubleBuffer;
        this.imaginaryBuffer = doubleBuffer2;
        this.nbRows = n;
        this.nbCols = n2;
        this.varName = string;
        this.byref = true;
        this.swaped = false;
    }

    @Override
    public boolean isEmpty() {
        return this.nbRows == 0 || this.nbCols == 0;
    }

    @Override
    public boolean isReal() {
        return this.imaginaryBuffer == null || this.imaginaryBuffer.capacity() == 0;
    }

    @Override
    public Object getRawRealPart() {
        return this.realBuffer;
    }

    @Override
    public Object getRawImaginaryPart() {
        return this.imaginaryBuffer;
    }

    public DoubleBuffer getRealBuffer() {
        return this.realBuffer;
    }

    public DoubleBuffer getImaginaryBuffer() {
        return this.imaginaryBuffer;
    }

    @Override
    public double[][] getRealPart() {
        double[][] dArray = new double[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(dArray, this.realBuffer);
        return dArray;
    }

    @Override
    public void setRealPart(double[][] dArray) {
        ScilabTypeUtils.setPart(this.realBuffer, dArray);
    }

    @Override
    public double[][] getImaginaryPart() {
        double[][] dArray = new double[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(dArray, this.imaginaryBuffer);
        return dArray;
    }

    @Override
    public void setImaginaryPart(double[][] dArray) {
        ScilabTypeUtils.setPart(this.imaginaryBuffer, dArray);
    }

    @Override
    public double getRealElement(int n, int n2) {
        return this.realBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public double getImaginaryElement(int n, int n2) {
        return this.imaginaryBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public void setRealElement(int n, int n2, double d) {
        this.realBuffer.put(n + this.nbRows * n2, d);
    }

    @Override
    public void setImaginaryElement(int n, int n2, double d) {
        this.imaginaryBuffer.put(n + this.nbRows * n2, d);
    }

    @Override
    public void setElement(int n, int n2, double d, double d2) {
        this.realBuffer.put(n + this.nbRows * n2, d);
        this.imaginaryBuffer.put(n + this.nbRows * n2, d);
    }

    private Object readResolve() throws ObjectStreamException {
        return new ScilabDouble(this.varName, this.realPart, this.imaginaryPart, this.swaped);
    }

    @Override
    public int getHeight() {
        return this.nbRows;
    }

    @Override
    public int getWidth() {
        return this.nbCols;
    }
}

