/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;

public class ScilabImageConverter
implements ExternalImageConverter {
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private final StringBuilder buffer = new StringBuilder(8192);
    private final DocbookTagConverter conv;

    public ScilabImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/scilab";
    }

    @Override
    public boolean mustRegenerate() {
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getFileWithScilabCode() {
        if (this.buffer.length() != 0) {
            File file;
            try {
                file = File.createTempFile("help-", ".sce", new File(ScilabCommons.getTMPDIR()));
            }
            catch (IOException iOException) {
                System.err.println("Cannot generate the file with Scilab code to execute:\n" + String.valueOf(iOException));
                return null;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                String string;
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));){
                    fileOutputStream.write(BOM);
                    bufferedWriter.write(this.buffer.toString());
                    bufferedWriter.flush();
                    string = file.getAbsolutePath();
                }
                return string;
            }
            catch (Exception exception) {
                System.err.println("Cannot generate the file with Scilab code to execute:\n" + String.valueOf(exception));
                return null;
            }
        }
        return null;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        return this.convertToPNG(string, string2, map, file, string3);
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder(8192);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3).append("\n");
            }
            string2 = this.convertToPNG(file.getName(), stringBuilder.toString(), map, file2, string);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                System.err.println("Problem when exporting Scilab code to " + String.valueOf(file2) + "!\n" + exception.toString());
                return null;
            }
        }
        bufferedReader.close();
        return string2;
    }

    private final String convertToPNG(String string, String string2, Map<String, String> map, File file, String string3) {
        this.buffer.append("function _generate_image_from_doc\n");
        this.buffer.append("__olddrv__=driver();\n");
        this.buffer.append("mprintf(\"Generate image " + string3 + " from Scilab code from file " + new File(string).getName() + "\\n\");");
        this.buffer.append("driver(\"png\");\n");
        this.buffer.append("xinit(\"").append(file.getAbsolutePath()).append("\");\n");
        this.buffer.append("scf();\n");
        this.buffer.append(string2).append("\n");
        this.buffer.append("gcf().anti_aliasing=\"2x\";\n");
        this.buffer.append("xend();\n");
        this.buffer.append("driver(__olddrv__);\n");
        this.buffer.append("endfunction\n");
        this.buffer.append("_generate_image_from_doc();\n");
        this.buffer.append("clear _generate_image_from_doc;\n");
        return this.conv.generateImageCode(string2, this.conv.getBaseImagePath() + string3, map);
    }
}

