/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;
import org.scilab.modules.helptools.image.Image;
import org.scilab.modules.helptools.image.ImageConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MathMLImageConverter
implements ExternalImageConverter {
    private static final Graphics2D TEMPGRAPHIC = new BufferedImage(1, 1, 2).createGraphics();
    private final DocbookTagConverter conv;

    public MathMLImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/mathml";
    }

    @Override
    public boolean mustRegenerate() {
        return true;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        Image image;
        Document document = null;
        try {
            document = MathMLParserSupport.parseString((String)string2);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        String string4 = map.get("fontsize");
        int n = 16;
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        if ((image = MathMLImageConverter.convertMathML(document, n)) != null && ImageConverter.convertIconToPNG(image.icon, file)) {
            return this.conv.generateImageCode(image, this.conv.getBaseImagePath() + string3, map);
        }
        return null;
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        Image image;
        Document document = null;
        try {
            document = MathMLParserSupport.parseFile((File)file);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        String string2 = map.get("fontsize");
        int n = 16;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if ((image = MathMLImageConverter.convertMathML(document, n)) != null && ImageConverter.convertIconToPNG(image.icon, file2)) {
            return this.conv.generateImageCode(image, this.conv.getBaseImagePath() + string, map);
        }
        return null;
    }

    private static Image convertMathML(Document document, int n) {
        LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        layoutContextImpl.setParameter(Parameter.MATHSIZE, (Object)n);
        JEuclidView jEuclidView = new JEuclidView((Node)document, (LayoutContext)layoutContextImpl, TEMPGRAPHIC);
        int n2 = (int)Math.ceil(jEuclidView.getWidth());
        int n3 = (int)Math.ceil(jEuclidView.getAscentHeight());
        int n4 = (int)Math.ceil(jEuclidView.getDescentHeight()) + n3;
        if (n2 <= 0 || n4 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 255, 255, 0));
        graphics2D.fillRect(0, 0, n2, n4);
        jEuclidView.draw(graphics2D, 0.0f, (float)n3);
        graphics2D.dispose();
        return new Image(new ImageIcon(bufferedImage), n2, n4, n3, n4 - n3);
    }
}

