/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;
import org.scilab.modules.helptools.image.Image;
import org.scilab.modules.helptools.image.ImageConverter;

public class LaTeXImageConverter
implements ExternalImageConverter {
    private final DocbookTagConverter conv;

    public LaTeXImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/latex";
    }

    @Override
    public boolean mustRegenerate() {
        return true;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        TeXIcon teXIcon = null;
        try {
            Image image;
            TeXFormula teXFormula = new TeXFormula(string2);
            String string4 = map.get("style");
            String string5 = map.get("alt");
            if (string5 == null) {
                map.put("alt", string2);
            }
            int n = 0;
            if (string4 != null && string4.equals("text")) {
                n = 2;
            }
            String string6 = map.get("fontsize");
            int n2 = 16;
            if (string6 != null) {
                try {
                    n2 = Integer.parseInt(string6);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((image = new Image((Icon)(teXIcon = teXFormula.createTeXIcon(n, (float)n2)), teXIcon.getIconWidth(), teXIcon.getIconHeight(), teXIcon.getIconHeight() - teXIcon.getIconDepth(), teXIcon.getIconDepth())) != null && ImageConverter.convertIconToPNG(image.icon, file)) {
                return this.conv.generateImageCode(image, this.conv.getBaseImagePath() + string3, map);
            }
        }
        catch (ParseException parseException) {
            System.err.println("LaTeX code in\n" + string + "\nhas generated an error: " + parseException.getMessage());
        }
        return null;
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            bl = true;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        if (bl) {
            return this.convertToImage(file.getName(), stringBuilder.toString(), map, file2, string);
        }
        return null;
    }
}

