/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.c;

import java.io.IOException;
import org.scilab.modules.helptools.c.AbstractCCodeHandler;

public class HTMLCCodeHandler
extends AbstractCCodeHandler {
    private static final int BUFCAPACITY = 8192;
    private static HTMLCCodeHandler handler = new HTMLCCodeHandler();
    protected Appendable buffer = new StringBuilder(8192);

    protected HTMLCCodeHandler() {
    }

    public static AbstractCCodeHandler getInstance() {
        ((StringBuilder)HTMLCCodeHandler.handler.buffer).setLength(0);
        return handler;
    }

    public static String replaceEntity(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&#0060;").replaceAll(">", "&#0062;").replaceAll("\"", "&#0034;").replaceAll("'", "&#0039;");
    }

    @Override
    public void handleDefault(String string) throws IOException {
        this.buffer.append("<span class=\"cdefault\">");
        this.buffer.append(HTMLCCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleComment(String string) throws IOException {
        this.buffer.append("<span class=\"ccomment\">");
        this.buffer.append(HTMLCCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleNothing(String string) throws IOException {
        this.buffer.append(string);
    }

    @Override
    public void handleString(String string) throws IOException {
        this.buffer.append("<span class=\"cstring\">");
        this.buffer.append(HTMLCCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleNumber(String string) throws IOException {
        this.buffer.append("<span class=\"cnumber\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleKeyword(String string) throws IOException {
        this.buffer.append("<span class=\"ckeyword\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleType(String string) throws IOException {
        this.buffer.append("<span class=\"ctype\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleModifier(String string) throws IOException {
        this.buffer.append("<span class=\"cmodifier\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handlePreprocessor(String string) throws IOException {
        this.buffer.append("<span class=\"cpreprocessor\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOpenClose(String string) throws IOException {
        this.buffer.append("<span class=\"copenclose\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOperator(String string) throws IOException {
        this.buffer.append("<span class=\"coperator\">");
        this.buffer.append(HTMLCCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleId(String string) throws IOException {
        this.buffer.append("<span class=\"cid\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    public String toString() {
        return this.buffer.toString();
    }
}

