/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_export;

import org.scilab.modules.graphic_export.Export;
import org.scilab.modules.graphic_export.ExportParams;
import org.scilab.modules.graphic_export.FileExporter;
import org.scilab.modules.localization.Messages;

public class Driver {
    private static String driver = "Rec";
    private static String filename;

    public static boolean setDriver(String string) {
        String string2 = string.toLowerCase();
        if (!(string2.equals("x11") || string2.equals("rec") || string2.equals("null") || Export.getType(string2) != -1)) {
            return false;
        }
        driver = string;
        return true;
    }

    public static String getDriver() {
        return driver;
    }

    public static void setPath(String string) {
        filename = string;
    }

    public static boolean isImageRendering() {
        return !driver.equalsIgnoreCase("X11") && !driver.equalsIgnoreCase("Rec") && !driver.equals("null");
    }

    public static void setDefaultVisitor(int n) {
        if (Driver.isImageRendering()) {
            Export.setVisitor(n, Export.getType(driver), new ExportParams(-1.0f, 0, true));
        }
    }

    public static String end(int n) {
        if (filename == null) {
            return Messages.gettext((String)"xinit must be called before xend.");
        }
        if (Driver.isImageRendering()) {
            String string = FileExporter.headlessFileExport(n, filename, driver, -1.0f, 0);
            filename = null;
            return string;
        }
        return "";
    }
}

