/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.DirectoryCollection;
import net.sf.saxon.resource.JarCollection;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class StandardCollectionFinder
implements CollectionFinder {
    @Override
    public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
        String regex;
        URI resolvedURI;
        AbstractResourceCollection.checkNotNull(collectionURI, context);
        URIQueryParameters params = null;
        String query = null;
        try {
            URI relativeURI = new URI(ResolveURI.escapeSpaces(collectionURI));
            query = relativeURI.getQuery();
            if (query != null) {
                int q = collectionURI.indexOf(63);
                params = new URIQueryParameters(query, context.getConfiguration());
                collectionURI = ResolveURI.escapeSpaces(collectionURI.substring(0, q));
            }
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid relative URI " + Err.wrap(collectionURI, 4) + " passed to collection() function").withErrorCode("FODC0004").withXPathContext(context);
        }
        try {
            resolvedURI = new URI(collectionURI);
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
        String protocols = (String)context.getConfiguration().getConfigurationProperty(Feature.ALLOWED_PROTOCOLS);
        boolean allow = "all".equals(protocols);
        if (!allow) {
            for (String protocol : protocols.split("\\s+")) {
                if (!resolvedURI.getScheme().equalsIgnoreCase(protocol)) continue;
                allow = true;
                break;
            }
        }
        if (!allow) {
            throw new XPathException("URI scheme '" + resolvedURI.getScheme() + "' has been disallowed");
        }
        if ("file".equals(resolvedURI.getScheme())) {
            File file = new File(resolvedURI);
            StandardCollectionFinder.checkFileExists(file, resolvedURI, context);
            if (file.isDirectory()) {
                return new DirectoryCollection(context.getConfiguration(), collectionURI, file, params);
            }
        }
        if ((regex = context.getConfiguration().getConfigurationProperty(Feature.ZIP_URI_PATTERN)) == null) {
            regex = "^jar:|\\.jar$|\\.zip$|\\.docx$|\\.xlsx$";
        }
        if (this.isJarFileURI(collectionURI) || ARegularExpression.compile(regex, "").containsMatch(StringView.of(collectionURI).tidy())) {
            return new JarCollection(context, collectionURI, params);
        }
        return new CatalogCollection(context.getConfiguration(), collectionURI);
    }

    protected boolean isJarFileURI(String collectionURI) {
        return collectionURI.endsWith(".jar") || collectionURI.endsWith(".zip") || collectionURI.endsWith(".docx") || collectionURI.startsWith("jar:");
    }

    public static void checkFileExists(File file, URI resolvedURI, XPathContext context) throws XPathException {
        if (!file.exists()) {
            throw new XPathException("The file or directory " + resolvedURI + " does not exist").withErrorCode("FODC0002").withXPathContext(context);
        }
    }
}

