/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.CurrentMergeGroup;
import net.sf.saxon.functions.CurrentMergeKey;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.PushableFunction;
import net.sf.saxon.functions.Put;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root_1;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerValue;

public class SystemFunctionCall
extends StaticFunctionCall
implements Negatable {
    public SystemFunctionCall(SystemFunction target, Expression[] arguments) {
        super(target, arguments);
    }

    @Override
    public void setRetainedStaticContext(RetainedStaticContext rsc) {
        super.setRetainedStaticContext(rsc);
        this.getTargetFunction().setRetainedStaticContext(rsc);
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        SystemFunction target = this.getTargetFunction();
        if ((target.getDetails().properties & 0x200) == 0) {
            return super.preEvaluate(visitor);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        this.checkFunctionCall(this.getTargetFunction(), visitor);
        this.getTargetFunction().supplyTypeInformation(visitor, contextInfo, this.getArguments());
        if ((this.getTargetFunction().getDetails().properties & 0x200) == 0) {
            return this.preEvaluateIfConstant(visitor);
        }
        return this;
    }

    @Override
    public SystemFunction getTargetFunction() {
        return (SystemFunction)super.getTargetFunction();
    }

    @Override
    public int getIntrinsicDependencies() {
        int properties = this.getTargetFunction().getDetails().properties;
        int dep = 0;
        if ((properties & 0x200) != 0) {
            dep = 1024;
        }
        if ((properties & 0x5804) != 0) {
            if ((properties & 0x4000) != 0) {
                dep |= 0x10;
            }
            if ((properties & 4) != 0) {
                dep |= 2;
            }
            if ((properties & 0x800) != 0) {
                dep |= 4;
            }
            if ((properties & 0x1000) != 0) {
                dep |= 8;
            }
        }
        if ((properties & 8) != 0) {
            dep |= 0x800;
        }
        if ((properties & 0x20) != 0) {
            dep |= 0x800;
        }
        if (this.isCallOn(RegexGroup.class) || this.isCallOn(CurrentMergeGroup.class) || this.isCallOn(CurrentMergeKey.class)) {
            dep |= 0x20;
        }
        return dep;
    }

    @Override
    protected int computeCardinality() {
        return this.getTargetFunction().getCardinality(this.getArguments());
    }

    @Override
    protected int computeSpecialProperties() {
        return this.getTargetFunction().getSpecialProperties(this.getArguments());
    }

    @Override
    public int getNetCost() {
        return this.getTargetFunction().getNetCost();
    }

    @Override
    public Expression getScopingExpression() {
        if (this.isCallOn(RegexGroup.class)) {
            for (Expression parent = this.getParentExpression(); parent != null; parent = parent.getParentExpression()) {
                if (!(parent instanceof AnalyzeString)) continue;
                return parent;
            }
            return null;
        }
        return super.getScopingExpression();
    }

    @Override
    public boolean isLiftable(boolean forStreaming) {
        return super.isLiftable(forStreaming) && !this.isCallOn(CurrentMergeGroup.class) && !this.isCallOn(CurrentMergeKey.class) && (!forStreaming || !this.isCallOn(MapFunctionSet.MapEntry.class));
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression sfo;
        Expression sfo2;
        int properties = this.getTargetFunction().getDetails().properties;
        if ((properties & 0x20000) != 0 && (sfo2 = this.getTargetFunction().makeOptimizedFunctionCall(visitor, contextInfo, this.getArguments())) != null) {
            sfo2.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, sfo2);
            return sfo2;
        }
        Expression sf = super.optimize(visitor, contextInfo);
        if (sf == this && (sfo = this.getTargetFunction().makeOptimizedFunctionCall(visitor, contextInfo, this.getArguments())) != null) {
            sfo.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, sfo);
            return sfo;
        }
        Optimizer opt = visitor.obtainOptimizer();
        if (sf instanceof SystemFunctionCall && opt.isOptionSet(32768)) {
            BuiltInFunctionSet.Entry details = ((SystemFunctionCall)sf).getTargetFunction().getDetails();
            if ((details.properties & 0x400) != 0) {
                this.setArg(0, this.getArg(0).unordered(true, visitor.isOptimizeForStreaming()));
            }
            if (this.getArity() <= details.resultIfEmpty.length) {
                for (int i = 0; i < this.getArity(); ++i) {
                    if (!Literal.isEmptySequence(this.getArg(i)) || details.resultIfEmpty[i] == null) continue;
                    return Literal.makeLiteral(details.resultIfEmpty[i].materialize(), this);
                }
            }
        }
        return sf;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.isCallOn(Error.class);
    }

    @Override
    public ItemType getItemType() {
        return this.getTargetFunction().getResultItemType(this.getArguments());
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression[] args = new Expression[this.getArity()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getArg(i).copy(rebindings);
        }
        SystemFunction target = this.getTargetFunction();
        if (target instanceof StatefulSystemFunction) {
            target = ((StatefulSystemFunction)((Object)target)).copy();
        }
        return target.makeFunctionCall(args);
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        SystemFunction fn = this.getTargetFunction();
        if ((fn.getDetails().properties & 0x100) != 0) {
            return this.getArg(0).getIntegerBounds();
        }
        return fn.getIntegerBounds();
    }

    @Override
    public boolean isNegatable(TypeHierarchy th) {
        return this.isCallOn(NotFn.class) || this.isCallOn(BooleanFn.class) || this.isCallOn(Empty.class) || this.isCallOn(Exists.class);
    }

    @Override
    public Expression negate() {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof NotFn) {
            Expression arg = this.getArg(0);
            if (arg.getItemType() == BuiltInAtomicType.BOOLEAN && arg.getCardinality() == 16384) {
                return arg;
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), arg);
        }
        if (fn instanceof BooleanFn) {
            return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (fn instanceof Exists) {
            return SystemFunction.makeCall("empty", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (fn instanceof Empty) {
            return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), this.getArg(0));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof Reverse) {
            return this.getArg(0);
        }
        if (fn instanceof TreatFn) {
            this.setArg(0, this.getArg(0).unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (this.isCallOn(Doc.class) || this.isCallOn(DocumentFn.class) || this.isCallOn(CollectionFn.class)) {
            this.getArg(0).addToPathMap(pathMap, pathMapNodeSet);
            return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        if (this.isCallOn(KeyFn.class)) {
            return ((KeyFn)this.getTargetFunction()).addToPathMap(pathMap, pathMapNodeSet);
        }
        return super.addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public Pattern toPattern(Configuration config) throws XPathException {
        SystemFunction fn = this.getTargetFunction();
        if (fn instanceof Root_1 && (this.getArg(0) instanceof ContextItemExpression || this.getArg(0) instanceof ItemChecker && ((ItemChecker)this.getArg(0)).getBaseExpression() instanceof ContextItemExpression)) {
            return new NodeSetPattern(this);
        }
        return super.toPattern(config);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        this.makeElaborator().elaborateForPush().processLeavingTail(output, context);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return super.call(context, arguments);
    }

    @Override
    public String getExpressionName() {
        return "sysFuncCall";
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getTargetFunction() instanceof Put;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        if (this.getFunctionName().hasURI(NamespaceUri.FN)) {
            out.startElement("fn", this);
            String localPart = this.getFunctionName().getLocalPart();
            out.emitAttribute("name", localPart);
            this.getTargetFunction().exportAttributes(out);
            if (localPart.equals("concat") && "JS".equals(out.getOptions().target) && out.getOptions().targetVersion == 2 && this.getArity() == 1 && this.getArg(0) instanceof Block) {
                for (Operand o : this.getArg(0).operands()) {
                    if (o.getChildExpression() instanceof Literal) {
                        for (Item item : ((Literal)o.getChildExpression()).getGroundedValue().asIterable()) {
                            Literal.exportValue(item, out);
                        }
                        continue;
                    }
                    o.getChildExpression().export(out);
                }
            } else {
                for (Operand o : this.operands()) {
                    o.getChildExpression().export(out);
                }
            }
            this.getTargetFunction().exportAdditionalArguments(this, out);
            out.endElement();
        } else {
            out.startElement("ifCall", this);
            out.emitAttribute("name", this.getFunctionName());
            out.emitAttribute("type", this.getTargetFunction().getFunctionItemType().getResultType().toAlphaCode());
            this.getTargetFunction().exportAttributes(out);
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            this.getTargetFunction().exportAdditionalArguments(this, out);
            out.endElement();
        }
    }

    @Override
    public Elaborator getElaborator() {
        SystemFunction fn = this.getTargetFunction();
        Elaborator fnElaborator = fn.getElaborator();
        if (fnElaborator != null) {
            return fnElaborator;
        }
        return new SystemFunctionCallElaborator();
    }

    public static class SystemFunctionCallElaborator
    extends FunctionCall.FunctionCallElaborator {
        @Override
        public void setExpression(Expression expr) {
            super.setExpression(expr);
            this.allocateArgumentEvaluators((FunctionCall)expr, false);
        }

        @Override
        public PullEvaluator elaborateForPull() {
            SystemFunctionCall expr = (SystemFunctionCall)this.getExpression();
            SystemFunction fn = expr.getTargetFunction();
            switch (this.argumentEvaluators.length) {
                case 0: {
                    return context -> {
                        try {
                            return fn.call(context, StackFrame.EMPTY_ARRAY_OF_SEQUENCE).iterate();
                        }
                        catch (XPathException err) {
                            throw err.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
                case 1: {
                    return context -> {
                        try {
                            return fn.call(context, new Sequence[]{this.argumentEvaluators[0].evaluate(context)}).iterate();
                        }
                        catch (XPathException err) {
                            throw err.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
                case 2: {
                    return context -> {
                        try {
                            return fn.call(context, new Sequence[]{this.argumentEvaluators[0].evaluate(context), this.argumentEvaluators[1].evaluate(context)}).iterate();
                        }
                        catch (XPathException err) {
                            throw err.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
            }
            return context -> {
                try {
                    return fn.call(context, this.evaluateArguments(context)).iterate();
                }
                catch (XPathException err) {
                    throw err.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                }
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall expr = (SystemFunctionCall)this.getExpression();
            SystemFunction fn = expr.getTargetFunction();
            switch (this.argumentEvaluators.length) {
                case 0: {
                    return context -> {
                        try {
                            return fn.call(context, StackFrame.EMPTY_ARRAY_OF_SEQUENCE).head();
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
                case 1: {
                    return context -> {
                        try {
                            return fn.call(context, new Sequence[]{this.argumentEvaluators[0].evaluate(context)}).head();
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
                case 2: {
                    return context -> {
                        try {
                            return fn.call(context, new Sequence[]{this.argumentEvaluators[0].evaluate(context), this.argumentEvaluators[1].evaluate(context)}).head();
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    };
                }
            }
            return context -> {
                try {
                    return fn.call(context, this.evaluateArguments(context)).head();
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                }
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            SystemFunctionCall expr = (SystemFunctionCall)this.getExpression();
            SystemFunction fn = expr.getTargetFunction();
            if (fn instanceof PushableFunction) {
                return (output, context) -> {
                    Sequence[] actualArgs = this.evaluateArguments(context);
                    try {
                        ((PushableFunction)((Object)fn)).process(output, context, actualArgs);
                    }
                    catch (XPathException e) {
                        throw e.maybeWithLocation(expr.getLocation()).maybeWithFailingExpression(expr).maybeWithContext(context);
                    }
                    return null;
                };
            }
            return super.elaborateForPush();
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            SystemFunctionCall expr = (SystemFunctionCall)this.getExpression();
            if (expr.isVacuousExpression()) {
                PullEvaluator eval = this.elaborateForPull();
                return (context, pul) -> eval.iterate(context).next();
            }
            throw new UnsupportedOperationException("Expression " + expr.toShortString() + " is not an updating expression");
        }
    }

    public static abstract class Optimized
    extends SystemFunctionCall {
        public Optimized(SystemFunction target, Expression[] arguments) {
            super(target, arguments);
        }

        @Override
        public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
            return this;
        }
    }
}

