/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.utils.shapes.geometry;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;

public final class CubeFactory {
    private static final int VERTEX_SIZE = 4;

    private CubeFactory() {
    }

    public static Geometry createCube(Canvas canvas) {
        return CubeFactory.createCube(canvas, 1);
    }

    public static Geometry createCube(Canvas canvas, int n) {
        return CubeFactory.createCube(canvas, n, false);
    }

    public static Geometry createCube(Canvas canvas, int n, boolean bl) {
        Object object;
        if (n < 1) {
            return null;
        }
        int n2 = n + 1;
        FloatBuffer floatBuffer = FloatBuffer.allocate(6 * n2 * n2 * 4);
        FloatBuffer floatBuffer2 = FloatBuffer.allocate(6 * n2 * n2 * 4);
        IntBuffer intBuffer = IntBuffer.allocate(36 * n * n);
        IntBuffer intBuffer2 = IntBuffer.allocate(48 * n * n);
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            for (int n4 : new int[]{-1, 1}) {
                int n5;
                int n6;
                object = CubeFactory.getVectorPermutation(i, 0.0f, 0.0f, n4);
                for (n6 = 0; n6 < n2; ++n6) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        float f = 2.0f * (float)n6 / (float)n - 1.0f;
                        float f2 = 2.0f * (float)n5 / (float)n - 1.0f;
                        floatBuffer.put(CubeFactory.getVectorPermutation(i, f, f2, n4));
                        floatBuffer2.put((float[])object);
                    }
                }
                for (n6 = 0; n6 < n; ++n6) {
                    for (n5 = 0; n5 < n; ++n5) {
                        int n7 = n3 + n5 + n6 * n2;
                        intBuffer.put(n7);
                        intBuffer.put(n7 + 1);
                        intBuffer.put(n7 + n2);
                        intBuffer.put(n7 + 1);
                        intBuffer.put(n7 + n2 + 1);
                        intBuffer.put(n7 + n2);
                        intBuffer2.put(n7);
                        intBuffer2.put(n7 + 1);
                        intBuffer2.put(n7 + 1);
                        intBuffer2.put(n7 + n2 + 1);
                        intBuffer2.put(n7 + n2 + 1);
                        intBuffer2.put(n7 + n2);
                        intBuffer2.put(n7 + n2);
                        intBuffer2.put(n7);
                    }
                }
                n3 += n2 * n2;
            }
        }
        floatBuffer.rewind();
        floatBuffer2.rewind();
        intBuffer.rewind();
        BuffersManager buffersManager = canvas.getBuffersManager();
        Object object2 = buffersManager.createElementsBuffer();
        ElementsBuffer elementsBuffer = buffersManager.createElementsBuffer();
        IndicesBuffer indicesBuffer = buffersManager.createIndicesBuffer();
        object2.setData(floatBuffer, 4);
        elementsBuffer.setData(floatBuffer2, 4);
        indicesBuffer.setData(intBuffer);
        DefaultGeometry defaultGeometry = new DefaultGeometry();
        defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
        defaultGeometry.setVertices((ElementsBuffer)object2);
        defaultGeometry.setNormals(elementsBuffer);
        defaultGeometry.setIndices(indicesBuffer);
        if (bl) {
            object = buffersManager.createIndicesBuffer();
            object.setData(intBuffer2);
            defaultGeometry.setWireIndices((IndicesBuffer)object);
            defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
            defaultGeometry.setPolygonOffsetMode(true);
        }
        return defaultGeometry;
    }

    private static float[] getVectorPermutation(int n, float f, float f2, float f3) {
        switch (n % 3) {
            case 0: {
                return new float[]{f, f2, f3, 1.0f};
            }
            case 1: {
                return new float[]{f3, f, f2, 1.0f};
            }
            case 2: {
                return new float[]{f2, f3, f, 1.0f};
            }
        }
        return null;
    }
}

