/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import java.util.Stack;
import javax.swing.event.EventListenerList;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.TransformationStack;
import org.scilab.forge.scirenderer.tranformations.TransformationStackListener;

public class TransformationStackImpl
implements TransformationStack {
    private final EventListenerList listeners = new EventListenerList();
    private final Stack<Transformation> stack = new Stack();

    @Override
    public void addListener(TransformationStackListener transformationStackListener) {
        this.listeners.add(TransformationStackListener.class, transformationStackListener);
    }

    @Override
    public void removeListener(TransformationStackListener transformationStackListener) {
        this.listeners.remove(TransformationStackListener.class, transformationStackListener);
    }

    @Override
    public Transformation peek() {
        if (this.stack.isEmpty()) {
            return TransformationFactory.getIdentity();
        }
        return this.stack.peek();
    }

    @Override
    public void push(Transformation transformation) {
        if (transformation != null) {
            this.stack.push(transformation);
            this.fireChanged(TransformationStack.TransformationStackEvent.PUSHED, transformation);
        }
    }

    @Override
    public void pushRightMultiply(Transformation transformation) {
        this.push(this.peek().rightTimes(transformation));
    }

    @Override
    public void pushLeftMultiply(Transformation transformation) {
        this.push(this.peek().leftTimes(transformation));
    }

    @Override
    public Transformation pop() {
        Transformation transformation = this.stack.pop();
        if (transformation == null) {
            transformation = TransformationFactory.getIdentity();
        }
        this.fireChanged(TransformationStack.TransformationStackEvent.POPPED, transformation);
        return transformation;
    }

    @Override
    public void clear() {
        this.stack.clear();
        this.fireChanged(TransformationStack.TransformationStackEvent.CLEARED, this.peek());
    }

    protected void fireChanged(TransformationStack.TransformationStackEvent transformationStackEvent, Transformation transformation) {
        for (TransformationStackListener transformationStackListener : (TransformationStackListener[])this.listeners.getListeners(TransformationStackListener.class)) {
            transformationStackListener.changed(this, transformationStackEvent, transformation);
        }
    }
}

