/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector3f;

public class Rotation {
    private static final int MAX_SELF_OPERATION = 16;
    private int opCount;
    private double a;
    private double b;
    private double c;
    private double d;
    private double[] rotationMatrix;

    public Rotation() {
        this.a = 1.0;
        this.b = 0.0;
        this.c = 0.0;
        this.d = 0.0;
        this.normalize();
    }

    public Rotation(Rotation rotation) {
        this.a = rotation.a;
        this.b = rotation.b;
        this.c = rotation.c;
        this.d = rotation.d;
        this.normalize();
    }

    public Rotation(double d, Vector3d vector3d) {
        double d2 = Math.cos(d / 2.0);
        Vector3d vector3d2 = vector3d.getNormalized().times(Math.sin(d / 2.0));
        this.a = d2;
        this.b = vector3d2.getX();
        this.c = vector3d2.getY();
        this.d = vector3d2.getZ();
        this.normalize();
    }

    public Rotation(double d, Vector3f vector3f) {
        this(d, vector3f.asDouble());
    }

    public static Rotation getDegreeRotation(double d, Vector3d vector3d) {
        int n = (int)d;
        if (d == (double)n) {
            if ((n %= 360) == 0) {
                return new Rotation(1.0, 0.0, 0.0, 0.0);
            }
            if (n == 180) {
                Vector3d vector3d2 = vector3d.getNormalized();
                return new Rotation(0.0, vector3d2.getX(), vector3d2.getY(), vector3d2.getZ());
            }
            return new Rotation((double)n / 180.0 * Math.PI, vector3d);
        }
        d = (d / 180.0 - 2.0 * Math.floor(d / 360.0)) * Math.PI;
        return new Rotation(d, vector3d);
    }

    private Rotation(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.normalize();
    }

    public Rotation(float[] fArray) {
        if (fArray != null && fArray.length == 4) {
            this.a = fArray[0];
            this.b = fArray[1];
            this.c = fArray[2];
            this.d = fArray[3];
        } else {
            this.a = 1.0;
            this.b = 0.0;
            this.c = 0.0;
            this.d = 0.0;
        }
        this.normalize();
    }

    public Rotation(double[] dArray) {
        if (dArray != null && dArray.length == 4) {
            this.a = dArray[0];
            this.b = dArray[1];
            this.c = dArray[2];
            this.d = dArray[3];
        } else {
            this.a = 1.0;
            this.b = 0.0;
            this.c = 0.0;
            this.d = 0.0;
        }
        this.normalize();
    }

    public Rotation getInverse() {
        return new Rotation(this.a, -this.b, -this.c, -this.d);
    }

    public boolean isIdentity() {
        return this.a == 1.0;
    }

    public double[] getRotationMatrix() {
        return (double[])this.rotationMatrix.clone();
    }

    public double[] getUnRotateMatrix() {
        return new double[]{this.rotationMatrix[0], this.rotationMatrix[4], this.rotationMatrix[8], this.rotationMatrix[12], this.rotationMatrix[1], this.rotationMatrix[5], this.rotationMatrix[9], this.rotationMatrix[13], this.rotationMatrix[2], this.rotationMatrix[6], this.rotationMatrix[10], this.rotationMatrix[14], this.rotationMatrix[3], this.rotationMatrix[7], this.rotationMatrix[11], this.rotationMatrix[15]};
    }

    public Rotation multiply(Rotation rotation) {
        double d = this.a * rotation.a - this.b * rotation.b - this.c * rotation.c - this.d * rotation.d;
        double d2 = this.a * rotation.b + this.b * rotation.a + this.c * rotation.d - this.d * rotation.c;
        double d3 = this.a * rotation.c - this.b * rotation.d + this.c * rotation.a + this.d * rotation.b;
        double d4 = this.a * rotation.d + this.b * rotation.c - this.c * rotation.b + this.d * rotation.a;
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.selfCheck();
        return this;
    }

    private void selfCheck() {
        if (this.opCount++ > 16) {
            this.normalize();
        } else {
            this.computeRotationMatrix();
        }
    }

    private void normalize() {
        this.opCount = 0;
        double d = 1.0 / Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d);
        this.a *= d;
        this.b *= d;
        this.c *= d;
        this.d *= d;
        this.computeRotationMatrix();
    }

    public Rotation times(Rotation rotation) {
        return new Rotation(this).multiply(rotation);
    }

    public Vector3d conjugate(Vector3d vector3d) {
        return new Vector3d(this.rotationMatrix[0] * vector3d.getX() + this.rotationMatrix[4] * vector3d.getY() + this.rotationMatrix[8] * vector3d.getZ(), this.rotationMatrix[1] * vector3d.getX() + this.rotationMatrix[5] * vector3d.getY() + this.rotationMatrix[9] * vector3d.getZ(), this.rotationMatrix[2] * vector3d.getX() + this.rotationMatrix[6] * vector3d.getY() + this.rotationMatrix[10] * vector3d.getZ());
    }

    public Vector3d conjugateInverse(Vector3d vector3d) {
        return new Vector3d(this.rotationMatrix[0] * vector3d.getX() + this.rotationMatrix[1] * vector3d.getY() + this.rotationMatrix[2] * vector3d.getZ(), this.rotationMatrix[4] * vector3d.getX() + this.rotationMatrix[5] * vector3d.getY() + this.rotationMatrix[6] * vector3d.getZ(), this.rotationMatrix[8] * vector3d.getX() + this.rotationMatrix[9] * vector3d.getY() + this.rotationMatrix[10] * vector3d.getZ());
    }

    private void computeRotationMatrix() {
        double d = this.a * this.a;
        double d2 = this.b * this.b;
        double d3 = this.c * this.c;
        double d4 = this.d * this.d;
        this.rotationMatrix = new double[]{d + d2 - d3 - d4, 2.0 * (this.b * this.c - this.a * this.d), 2.0 * (this.a * this.c + this.b * this.d), 0.0, 2.0 * (this.a * this.d + this.b * this.c), d - d2 + d3 - d4, 2.0 * (this.c * this.d - this.a * this.b), 0.0, 2.0 * (this.b * this.d - this.a * this.c), 2.0 * (this.a * this.b + this.c * this.d), d - d2 - d3 + d4, 0.0, 0.0, 0.0, 0.0, 1.0};
    }

    public String toString() {
        return "(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ")";
    }

    public Vector3d getVectorY() {
        return new Vector3d(this.rotationMatrix[1], this.rotationMatrix[5], this.rotationMatrix[9]);
    }

    public Rotation power(double d) {
        double d2 = this.a;
        double d3 = Math.sqrt(this.b * this.b + this.c * this.c + this.d * this.d);
        if (d3 < 0.001) {
            return new Rotation();
        }
        double d4 = (d - 1.0) * Math.atan2(d3, d2);
        double d5 = d2 * Math.cos(d4) - d3 * Math.sin(d4);
        double d6 = Math.cos(d4) + Math.sin(d4) * (d2 / d3);
        return new Rotation(d5, d6 * this.b, d6 * this.c, d6 * this.d);
    }

    public double[] getData() {
        return new double[]{this.a, this.b, this.c, this.d};
    }

    public float[] getDataAsFloatArray() {
        return new float[]{(float)this.a, (float)this.b, (float)this.c, (float)this.d};
    }

    public int hashCode() {
        int n = 0;
        n += 7 * new Double(this.a).hashCode();
        n += 17 * new Double(this.b).hashCode();
        n += 29 * new Double(this.c).hashCode();
        return n += 37 * new Double(this.d).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rotation)) {
            return false;
        }
        Rotation rotation = (Rotation)object;
        return rotation != null && this.a == rotation.a && this.b == rotation.b && this.c == rotation.c && this.d == rotation.d;
    }
}

