/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler.graduations;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class TinyIntervalFormat
extends DecimalFormat {
    private static final DecimalFormat simpleFormat = new DecimalFormat("0.######");
    private DecimalFormat fracFormat;

    public TinyIntervalFormat(String string, String string2) {
        super(string);
        this.fracFormat = new DecimalFormat(string2);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double[] dArray = TinyIntervalFormat.getParts(d);
        if (dArray[1] == 0.0) {
            return super.format(d, stringBuffer, fieldPosition);
        }
        if (dArray[0] != 0.0) {
            stringBuffer = dArray[0] < 10.0 ? simpleFormat.format(dArray[0], stringBuffer, fieldPosition) : super.format(dArray[0], stringBuffer, fieldPosition);
            if (dArray[1] > 0.0) {
                stringBuffer.append("+");
            } else if (dArray[1] < 0.0) {
                stringBuffer.append("-");
            }
            return this.fracFormat.format(Math.abs(dArray[1]), stringBuffer, fieldPosition);
        }
        return this.fracFormat.format(dArray[1], stringBuffer, fieldPosition);
    }

    @Override
    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        super.setDecimalFormatSymbols(decimalFormatSymbols);
        this.fracFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        simpleFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    private static final double[] getParts(double d) {
        double d2 = 1.0;
        double d3 = d;
        double d4 = d3 - (double)Math.round(d3);
        while (Math.abs(d4) > 0.01) {
            d2 *= 10.0;
            d4 = (d3 *= 10.0) - (double)Math.round(d3);
        }
        return new double[]{(double)Math.round(d3) / d2, d4 / d2};
    }
}

