/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler.graduations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scilab.forge.scirenderer.ruler.graduations.AbstractGraduations;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;
import org.scilab.forge.scirenderer.ruler.graduations.LinearGraduations;

public final class LogarithmicGraduations
extends AbstractGraduations
implements Graduations {
    private final int stepExponent;
    private List<Double> allValues;
    private Graduations subGraduation;
    private Graduations moreGraduation;
    private Graduations alternativeGraduation;

    private LogarithmicGraduations(Graduations graduations, int n) {
        super(graduations);
        this.stepExponent = n;
    }

    private LogarithmicGraduations(double d, boolean bl, double d2, boolean bl2) {
        super(d, bl, d2, bl2);
        if (d != d2) {
            this.stepExponent = 1;
        } else {
            this.stepExponent = 0;
            this.allValues = new ArrayList<Double>();
            this.allValues.add(d);
        }
    }

    public static LogarithmicGraduations create(double d, double d2) {
        return LogarithmicGraduations.create(d, true, d2, true);
    }

    public static LogarithmicGraduations create(double d, boolean bl, double d2, boolean bl2) {
        if (d < d2) {
            return new LogarithmicGraduations(d, bl, d2, bl2);
        }
        return new LogarithmicGraduations(d2, bl2, d, bl);
    }

    @Override
    public List<Double> getAllValues() {
        if (this.allValues == null) {
            this.allValues = new ArrayList<Double>();
            int n = (int)Math.ceil(Math.log10(this.getLowerBound()));
            double d = Math.pow(10.0, n);
            double d2 = Math.pow(10.0, this.stepExponent);
            if (d == this.getLowerBound() && !this.isLowerBoundIncluded()) {
                d *= d2;
            }
            while (this.contain(d) && !Double.isInfinite(d)) {
                this.allValues.add(d);
                d *= d2;
            }
        }
        return this.allValues;
    }

    @Override
    public List<Double> getNewValues() {
        return this.getAllValues();
    }

    @Override
    public Graduations getMore() {
        if (this.moreGraduation == null) {
            this.moreGraduation = new LinLogGraduation(this);
        }
        return this.moreGraduation;
    }

    @Override
    public Graduations getAlternative() {
        if (this.alternativeGraduation == null) {
            int n = 3 + this.stepExponent - this.stepExponent % 3;
            this.alternativeGraduation = new LogarithmicGraduations(this, n);
        }
        return this.alternativeGraduation;
    }

    @Override
    public Graduations getSubGraduations() {
        if (this.subGraduation == null) {
            this.subGraduation = this.stepExponent > 1 ? new LogarithmicGraduations(this, this.stepExponent / 3) : new LinLogGraduation(this).getSubGraduations();
        }
        return this.subGraduation;
    }

    @Override
    public List<Double> getSubGraduations(int n) {
        if (this.subValues == null) {
            List<Double> list = this.getAllValues();
            if (n == 0 || list.size() == 0) {
                this.subValues = new ArrayList();
            } else {
                Collections.sort(list);
                this.subValues = new ArrayList();
                for (int i = 0; i < list.size() - 1; ++i) {
                    double d = Math.log10(list.get(i));
                    double d2 = Math.log10(list.get(i + 1));
                    double d3 = (d2 - d) / (double)(n + 1);
                    double d4 = d;
                    for (int j = 0; j <= n; ++j) {
                        this.subValues.add(Math.pow(10.0, d4));
                        d4 += d3;
                    }
                }
                this.subValues.add(list.get(list.size() - 1));
            }
        }
        return this.subValues;
    }

    @Override
    public int getSubDensity() {
        if (this.stepExponent >= 3) {
            return 3;
        }
        if (this.stepExponent == 2) {
            return this.stepExponent;
        }
        return this.getSubGraduations().getSubDensity();
    }

    @Override
    public String toString() {
        Object object = super.toString();
        object = (String)object + "; stepExponent=" + this.stepExponent + "; parent=" + String.valueOf(this.getParentGraduations());
        return object;
    }

    private class LinLogGraduation
    extends AbstractGraduations
    implements Graduations {
        private Graduations alternativeLLGraduation;
        private Graduations moreLLGraduation;
        private Graduations subLLGraduation;
        private List<Double> allValues;
        private List<Double> newValues;
        private final List<Graduations> graduationsList;

        public LinLogGraduation(LogarithmicGraduations logarithmicGraduations2) {
            super(logarithmicGraduations2);
            this.graduationsList = this.computeGraduationsList();
        }

        private LinLogGraduation(Graduations graduations, List<Graduations> list) {
            super(graduations);
            this.graduationsList = list;
        }

        @Override
        public List<Double> getAllValues() {
            if (this.allValues == null) {
                this.allValues = new ArrayList<Double>();
                for (Graduations graduations : this.graduationsList) {
                    this.allValues.addAll(graduations.getAllValues());
                }
                this.allValues.addAll(this.getLogarithmicParent().getAllValues());
            }
            return this.allValues;
        }

        @Override
        public List<Double> getNewValues() {
            block4: {
                if (this.newValues != null) break block4;
                this.newValues = new ArrayList<Double>();
                if (this.getParentGraduations() instanceof LogarithmicGraduations) {
                    for (Graduations graduations : this.graduationsList) {
                        this.newValues.addAll(graduations.getAllValues());
                    }
                } else {
                    for (Graduations graduations : this.graduationsList) {
                        this.newValues.addAll(graduations.getNewValues());
                    }
                }
            }
            return this.newValues;
        }

        @Override
        public Graduations getMore() {
            if (this.moreLLGraduation == null) {
                ArrayList<Graduations> arrayList = new ArrayList<Graduations>();
                for (Graduations graduations : this.graduationsList) {
                    Graduations graduations2 = graduations.getMore();
                    if (graduations2 == null) continue;
                    arrayList.add(graduations2);
                }
                if (!arrayList.isEmpty()) {
                    this.moreLLGraduation = new LinLogGraduation(this, arrayList);
                }
            }
            return this.moreLLGraduation;
        }

        @Override
        public Graduations getAlternative() {
            if (this.alternativeLLGraduation == null) {
                ArrayList<Graduations> arrayList = new ArrayList<Graduations>();
                for (Graduations graduations : this.graduationsList) {
                    Graduations graduations2 = graduations.getAlternative();
                    if (graduations2 == null) continue;
                    arrayList.add(graduations2);
                }
                if (!arrayList.isEmpty()) {
                    this.alternativeLLGraduation = new LinLogGraduation(this, arrayList);
                }
            }
            return this.alternativeLLGraduation;
        }

        @Override
        public Graduations getSubGraduations() {
            if (this.subLLGraduation == null) {
                ArrayList<Graduations> arrayList = new ArrayList<Graduations>();
                for (Graduations graduations : this.graduationsList) {
                    Graduations graduations2 = graduations.getSubGraduations();
                    if (graduations2 == null) continue;
                    arrayList.add(graduations2);
                }
                this.subLLGraduation = arrayList.isEmpty() ? this.getMore().getSubGraduations() : new LinLogGraduation(this, arrayList);
            }
            return this.subLLGraduation;
        }

        @Override
        public int getSubDensity() {
            return 0;
        }

        private List<Graduations> computeGraduationsList() {
            ArrayList<Graduations> arrayList = new ArrayList<Graduations>();
            double d = Math.ceil(Math.log10(this.getLowerBound()));
            double d2 = Math.floor(Math.log10(this.getUpperBound()));
            double d3 = Math.pow(10.0, d);
            double d4 = Math.pow(10.0, d2);
            if (d > d2) {
                arrayList.add(LinearGraduations.create(this, this.getLowerBound(), true, this.getUpperBound(), true));
            } else {
                if (d3 != this.getLowerBound()) {
                    arrayList.add(LinearGraduations.create(this, this.getLowerBound(), true, d3, false));
                }
                if (d != d2) {
                    for (double d5 = d; d5 < Math.min(d2, 310.0); d5 += 1.0) {
                        arrayList.add(LinearGraduations.create(this, Math.pow(10.0, d5), false, Math.pow(10.0, d5 + 1.0), false));
                    }
                }
                if (d4 != this.getUpperBound()) {
                    arrayList.add(LinearGraduations.create(this, d4, false, this.getUpperBound(), true));
                }
            }
            return arrayList;
        }

        private Graduations getLogarithmicParent() {
            Graduations graduations = this.getParentGraduations();
            while (!(graduations instanceof LogarithmicGraduations)) {
                graduations = graduations.getParentGraduations();
            }
            return graduations;
        }
    }
}

