/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.renderer;

import com.jogamp.opengl.GL2;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.renderer.JoGLRenderer;
import org.scilab.forge.scirenderer.renderer.Renderer;
import org.scilab.forge.scirenderer.renderer.RendererManager;

public class JoGLRendererManager
implements RendererManager {
    private final Set<JoGLRenderer> rendererSet = new HashSet<JoGLRenderer>();
    private final Stack<JoGLRenderer> deadRendererSet = new Stack();

    @Override
    public Renderer createRenderer() {
        JoGLRenderer joGLRenderer = new JoGLRenderer();
        this.rendererSet.add(joGLRenderer);
        return joGLRenderer;
    }

    @Override
    public void dispose(Renderer renderer) {
        if (renderer != null && renderer instanceof JoGLRenderer) {
            JoGLRenderer joGLRenderer = (JoGLRenderer)renderer;
            this.rendererSet.remove(joGLRenderer);
            this.deadRendererSet.push(joGLRenderer);
        }
    }

    public void dispose(JoGLDrawingTools joGLDrawingTools, Renderer renderer) {
        if (renderer != null && renderer instanceof JoGLRenderer) {
            JoGLRenderer joGLRenderer = (JoGLRenderer)renderer;
            joGLRenderer.dispose(joGLDrawingTools.getGl().getGL2());
            this.rendererSet.remove(joGLRenderer);
            this.deadRendererSet.push(joGLRenderer);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, Renderer renderer) {
        if (renderer != null && renderer instanceof JoGLRenderer) {
            ((JoGLRenderer)renderer).draw(joGLDrawingTools);
        }
    }

    public void glReload() {
        for (JoGLRenderer joGLRenderer : this.rendererSet) {
            joGLRenderer.reload();
        }
    }

    public void glSynchronize(GL2 gL2) {
        while (!this.deadRendererSet.isEmpty()) {
            this.deadRendererSet.pop().dispose(gL2);
        }
    }
}

