/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.drawer;

import com.jogamp.opengl.GL2;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLBuffersManager;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.Texture;

public final class JoGLShapeDrawer {
    private static JoGLShapeDrawer drawer;

    private JoGLShapeDrawer() {
    }

    public static JoGLShapeDrawer getDrawer() {
        if (drawer == null) {
            drawer = new JoGLShapeDrawer();
        }
        return drawer;
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance) throws SciRendererException {
        this.draw(joGLDrawingTools, geometry, appearance, AntiAliasing.ON);
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance, AntiAliasing antiAliasing) throws SciRendererException {
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        gL2.glFrontFace(2305);
        switch (geometry.getFaceCullingMode()) {
            case CW: {
                gL2.glEnable(2884);
                gL2.glCullFace(1028);
                break;
            }
            case CCW: {
                gL2.glEnable(2884);
                gL2.glCullFace(1029);
                break;
            }
            case BOTH: {
                gL2.glDisable(2884);
                break;
            }
            default: {
                gL2.glDisable(2884);
            }
        }
        gL2.glEnable(3058);
        gL2.glLogicOp(joGLDrawingTools.getGLPixelDrawingMode());
        if (joGLDrawingTools.getCanvas().getJoGLParameters().useVBO()) {
            this.vboDrawing(joGLDrawingTools, geometry, appearance, antiAliasing);
        } else {
            this.directDrawing(joGLDrawingTools, geometry, appearance);
        }
        gL2.glDisable(3058);
        GLShortCuts.useLineAppearance(gL2, null);
        gL2.glDisable(2884);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vboDrawing(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance, AntiAliasing antiAliasing) throws SciRendererException {
        Object object;
        int n;
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        JoGLBuffersManager joGLBuffersManager = joGLDrawingTools.getCanvas().getBuffersManager();
        Texture texture = appearance.getTexture();
        gL2.glEnable(2929);
        gL2.glDepthFunc(515);
        gL2.glBlendFunc(770, 771);
        gL2.glAlphaFunc(516, 0.0f);
        gL2.glEnable(2977);
        gL2.glEnable(3042);
        if (antiAliasing == AntiAliasing.ON) {
            gL2.glEnable(32925);
            n = 0;
            if (gL2.glGetError() == 0) {
                object = new int[]{0};
                gL2.glGetIntegerv(32936, (int[])object, 0);
                int[] nArray = new int[]{0};
                gL2.glGetIntegerv(32937, nArray, 0);
                if (object[0] == 1 && nArray[0] > 0) {
                    n = 1;
                }
            }
            if (n == 0) {
                gL2.glDisable(32925);
                gL2.glGetError();
            }
        } else {
            gL2.glDisable(32925);
            gL2.glGetError();
            gL2.glDisable(2848);
        }
        n = joGLBuffersManager.bindVertexBuffer(gL2, geometry.getVertices());
        if (n == 0) {
            gL2.glDisableClientState(32884);
            return;
        }
        joGLBuffersManager.bindNormalsBuffer(gL2, geometry.getNormals());
        if (texture != null && geometry.getTextureCoordinates() != null) {
            Texture texture2 = texture;
            object = texture2;
            synchronized (texture2) {
                if (texture.isValid()) {
                    joGLDrawingTools.bind(texture);
                    joGLBuffersManager.bindTextureCoordinatesBuffer(gL2, geometry.getTextureCoordinates());
                }
                // ** MonitorExit[var9_9] (shouldn't be in output)
            }
        } else {
            joGLBuffersManager.bindColorsBuffer(gL2, geometry.getColors());
        }
        {
            int n2;
            if (geometry.getPolygonOffsetMode()) {
                gL2.glEnable(32823);
                gL2.glPolygonOffset(1.0f, 1.0f);
            }
            GLShortCuts.useColor(gL2, appearance.getFillColor());
            object = joGLDrawingTools.getLightManager();
            boolean bl = object.isLightningEnable();
            if (bl) {
                object.setMaterial(appearance.getMaterial());
                gL2.glEnable(2977);
            }
            IndicesBuffer indicesBuffer = geometry.getIndices();
            if (geometry.getFillDrawingMode() != Geometry.FillDrawingMode.NONE) {
                if (indicesBuffer != null) {
                    n2 = joGLBuffersManager.bindIndicesBuffer(gL2, indicesBuffer);
                    if (n2 > 0) {
                        gL2.glDrawElements(this.getGlMode(geometry.getFillDrawingMode()), n2, 5125, 0L);
                        gL2.glBindBuffer(34963, 0);
                    }
                } else {
                    n2 = geometry.getVertices().getSize();
                    if (n2 > 0) {
                        gL2.glDrawArrays(this.getGlMode(geometry.getFillDrawingMode()), 0, n2);
                    }
                }
            }
            if (geometry.getPolygonOffsetMode()) {
                gL2.glDisable(32823);
            }
            gL2.glDisableClientState(32886);
            gL2.glDisableClientState(32885);
            gL2.glDisableClientState(32888);
            gL2.glDisable(3553);
            object.setLightningEnable(false);
            gL2.glDisable(2977);
            if (geometry.getLineDrawingMode() != Geometry.LineDrawingMode.NONE) {
                gL2.glShadeModel(7424);
                if (appearance.getLineColor() != null || geometry.getColors() != null) {
                    GLShortCuts.useLineAppearance(gL2, appearance);
                    if (appearance.getLineColor() == null) {
                        joGLBuffersManager.bindColorsBuffer(gL2, geometry.getColors());
                    }
                    if (geometry.getWireIndices() != null) {
                        n2 = joGLBuffersManager.bindIndicesBuffer(gL2, geometry.getWireIndices());
                        if (n2 > 0) {
                            gL2.glDrawElements(this.getGlMode(geometry.getLineDrawingMode()), n2, 5125, 0L);
                            gL2.glBindBuffer(34963, 0);
                        }
                    } else {
                        n2 = geometry.getVertices().getSize();
                        if (n2 > 0) {
                            gL2.glDrawArrays(this.getGlMode(geometry.getLineDrawingMode()), 0, n2);
                        }
                    }
                    gL2.glDisableClientState(32886);
                }
            }
            gL2.glDisableClientState(32884);
            object.setLightningEnable(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directDrawing(JoGLDrawingTools joGLDrawingTools, Geometry geometry, Appearance appearance) throws SciRendererException {
        int n;
        IntBuffer intBuffer;
        boolean bl;
        double d;
        double d2;
        FloatBuffer floatBuffer;
        Object object;
        float[] fArray = new float[4];
        GL2 gL2 = joGLDrawingTools.getGl().getGL2();
        if (geometry.getVertices() == null) {
            return;
        }
        FloatBuffer floatBuffer2 = geometry.getVertices().getData();
        IndicesBuffer indicesBuffer = geometry.getIndices();
        FloatBuffer floatBuffer3 = geometry.getColors() != null ? geometry.getColors().getData() : null;
        FloatBuffer floatBuffer4 = geometry.getNormals() != null ? geometry.getNormals().getData() : null;
        Texture texture = appearance.getTexture();
        if (texture != null && geometry.getTextureCoordinates() != null) {
            object = texture;
            synchronized (object) {
                joGLDrawingTools.bind(texture);
                floatBuffer = geometry.getTextureCoordinates().getData();
                d2 = texture.getSScaleFactor();
                d = texture.getTScaleFactor();
            }
        } else {
            floatBuffer = null;
            d2 = 1.0;
            d = 1.0;
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glEnable(32823);
            gL2.glPolygonOffset(1.0f, 1.0f);
        }
        if (bl = (object = joGLDrawingTools.getLightManager()).isLightningEnable()) {
            object.setMaterial(appearance.getMaterial());
        }
        if (geometry.getFillDrawingMode() != Geometry.FillDrawingMode.NONE) {
            GLShortCuts.useColor(gL2, appearance.getFillColor());
            gL2.glShadeModel(7424);
            gL2.glBegin(this.getGlMode(geometry.getFillDrawingMode()));
            if (indicesBuffer != null) {
                intBuffer = indicesBuffer.getData();
                intBuffer.rewind();
                for (n = 0; n < intBuffer.limit(); ++n) {
                    int n2 = intBuffer.get(n);
                    if (n2 * 4 >= floatBuffer2.limit()) continue;
                    if (floatBuffer3 != null) {
                        floatBuffer3.position(n2 * 4);
                        gL2.glColor4fv(floatBuffer3);
                    }
                    if (floatBuffer4 != null) {
                        floatBuffer4.position(n2 * 4);
                        gL2.glNormal3fv(floatBuffer4);
                    }
                    if (floatBuffer != null) {
                        floatBuffer.position(n2 * 4);
                        floatBuffer.get(fArray);
                        gL2.glTexCoord4f((float)(d2 * (double)fArray[0]), (float)(d * (double)fArray[1]), fArray[2], fArray[3]);
                    }
                    floatBuffer2.position(n2 * 4);
                    gL2.glVertex4fv(floatBuffer2);
                }
            } else {
                floatBuffer2.rewind();
                if (floatBuffer3 != null) {
                    floatBuffer3.rewind();
                }
                if (floatBuffer4 != null) {
                    floatBuffer4.rewind();
                }
                for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                    if (floatBuffer3 != null) {
                        floatBuffer3.position(i);
                        gL2.glColor4fv(floatBuffer3);
                    }
                    if (floatBuffer4 != null) {
                        floatBuffer4.position(i);
                        gL2.glNormal3fv(floatBuffer4);
                    }
                    if (floatBuffer != null) {
                        floatBuffer.position(i);
                        gL2.glTexCoord4fv(floatBuffer);
                    }
                    floatBuffer2.position(i);
                    gL2.glVertex4fv(floatBuffer2);
                }
            }
            gL2.glEnd();
        }
        if (geometry.getPolygonOffsetMode()) {
            gL2.glDisable(32823);
        }
        gL2.glDisable(3553);
        object.setLightningEnable(false);
        if (geometry.getLineDrawingMode() != Geometry.LineDrawingMode.NONE) {
            GLShortCuts.useLineAppearance(gL2, appearance);
            if (appearance.getLineColor() != null) {
                gL2.glBegin(this.getGlMode(geometry.getLineDrawingMode()));
                if (geometry.getWireIndices() != null) {
                    intBuffer = geometry.getWireIndices().getData();
                    intBuffer.rewind();
                    while (intBuffer.remaining() != 0) {
                        n = intBuffer.get();
                        if (n * 4 >= floatBuffer2.limit()) continue;
                        floatBuffer2.position(n * 4);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                } else {
                    for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                        floatBuffer2.position(i);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                }
                gL2.glEnd();
            } else if (floatBuffer3 != null) {
                gL2.glBegin(this.getGlMode(geometry.getLineDrawingMode()));
                if (geometry.getWireIndices() != null) {
                    intBuffer = geometry.getWireIndices().getData();
                    intBuffer.rewind();
                    while (intBuffer.remaining() != 0) {
                        n = intBuffer.get();
                        if (n * 4 >= floatBuffer2.limit()) continue;
                        floatBuffer3.position(n * 4);
                        gL2.glColor4fv(floatBuffer3);
                        floatBuffer2.position(n * 4);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                } else {
                    for (int i = 0; i < floatBuffer2.limit(); i += 4) {
                        floatBuffer3.position(i);
                        floatBuffer2.position(i);
                        gL2.glColor4fv(floatBuffer3);
                        gL2.glVertex4fv(floatBuffer2);
                    }
                }
                gL2.glEnd();
            }
        }
        object.setLightningEnable(bl);
    }

    private int getGlMode(Geometry.FillDrawingMode fillDrawingMode) {
        switch (fillDrawingMode) {
            case TRIANGLE_FAN: {
                return 6;
            }
            case TRIANGLE_STRIP: {
                return 5;
            }
            case TRIANGLES: {
                return 4;
            }
        }
        return 4;
    }

    private int getGlMode(Geometry.LineDrawingMode lineDrawingMode) {
        switch (lineDrawingMode) {
            case SEGMENTS: {
                return 1;
            }
            case SEGMENTS_LOOP: {
                return 2;
            }
            case SEGMENTS_STRIP: {
                return 3;
            }
        }
        return 1;
    }

    public static enum AntiAliasing {
        OFF,
        ON;

    }
}

