/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.buffers;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Collection;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.buffers.JoGLDataBuffer;

public class JoGLIndicesBuffer
extends JoGLDataBuffer
implements IndicesBuffer {
    private IntBuffer data = null;

    JoGLIndicesBuffer() {
    }

    @Override
    public void setData(int[] nArray) {
        IntBuffer intBuffer = IntBuffer.allocate(nArray.length);
        intBuffer.rewind();
        intBuffer.put(nArray);
        intBuffer.rewind();
        this.data = intBuffer;
        this.setDataUploaded(false);
    }

    @Override
    public void setData(Collection<Integer> collection) {
        IntBuffer intBuffer = IntBuffer.allocate(collection.size());
        intBuffer.rewind();
        for (int n : collection) {
            intBuffer.put(n);
        }
        intBuffer.rewind();
        this.data = intBuffer;
        this.setDataUploaded(false);
    }

    @Override
    public void setData(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = IntBuffer.allocate(intBuffer.limit());
        intBuffer2.rewind();
        intBuffer.rewind();
        intBuffer2.put(intBuffer);
        intBuffer2.rewind();
        intBuffer.rewind();
        this.data = intBuffer2;
        this.setDataUploaded(false);
    }

    @Override
    public int getSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.limit();
    }

    @Override
    public IntBuffer getData() {
        return this.data.asReadOnlyBuffer();
    }

    @Override
    public int getByteSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.limit() * 4;
    }

    @Override
    protected Buffer getByteBuffer() {
        if (this.data != null) {
            this.data.rewind();
        }
        return this.data;
    }

    @Override
    protected int getGLBindDestination() {
        return 34963;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.data = null;
    }
}

