/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.lighting;

import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.implementation.g2d.lighting.G2DLight;
import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.shapes.appearance.Material;
import org.scilab.forge.scirenderer.tranformations.Vector3f;

public class G2DLightManager
implements LightManager {
    private final G2DDrawingTools drawingTools;
    private final G2DLight[] lights;
    private boolean isLightningEnable = false;
    private Material material;

    public G2DLightManager(G2DDrawingTools g2DDrawingTools) {
        this.drawingTools = g2DDrawingTools;
        this.lights = new G2DLight[this.getLightNumber()];
    }

    @Override
    public int getLightNumber() {
        return 16;
    }

    @Override
    public Light getLight(int n) {
        if (n < 0 || n >= this.getLightNumber()) {
            return null;
        }
        if (this.lights[n] == null) {
            this.lights[n] = new G2DLight(n);
        }
        return this.lights[n];
    }

    @Override
    public void setLightningEnable(boolean bl) {
        this.isLightningEnable = bl;
    }

    @Override
    public boolean isLightningEnable() {
        return this.isLightningEnable;
    }

    @Override
    public void setMaterial(Material material) {
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public Vector3f getCameraPosition() {
        double[] dArray = this.drawingTools.getTransformationManager().getTransformation().getMatrix();
        return new Vector3f((float)dArray[12], (float)dArray[13], (float)dArray[14]);
    }

    public float[] getVertexTransform() {
        float[] fArray = new float[16];
        double[] dArray = this.drawingTools.getTransformationManager().getTransformation().getMatrix();
        for (int i = 0; i < 16; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public float[] getNormalTransform() {
        float[] fArray = new float[16];
        double[] dArray = this.drawingTools.getTransformationManager().getTransformation().getInverseTransformation().getMatrix();
        fArray[0] = (float)dArray[0];
        fArray[4] = (float)dArray[1];
        fArray[8] = (float)dArray[2];
        fArray[12] = 0.0f;
        fArray[1] = (float)dArray[4];
        fArray[5] = (float)dArray[5];
        fArray[9] = (float)dArray[6];
        fArray[13] = 0.0f;
        fArray[2] = (float)dArray[8];
        fArray[6] = (float)dArray[9];
        fArray[10] = (float)dArray[10];
        fArray[14] = 0.0f;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
        return fArray;
    }
}

