/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.clipping;

import java.util.ArrayList;
import java.util.List;
import org.scilab.forge.scirenderer.clipping.ClippingManager;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.implementation.g2d.clipping.G2DClippingPlane;

public class G2DClippingManager
implements ClippingManager {
    private final G2DDrawingTools drawingTools;
    private final List<ClippingPlane> clippingPlanes;

    public G2DClippingManager(G2DDrawingTools g2DDrawingTools) {
        this.drawingTools = g2DDrawingTools;
        this.clippingPlanes = new ArrayList<ClippingPlane>(6);
    }

    public List<ClippingPlane> getClippingPlanes() {
        return this.clippingPlanes;
    }

    @Override
    public int getClippingPlaneNumber() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ClippingPlane getClippingPlane(int n) {
        if (n < 0 || n >= this.getClippingPlaneNumber()) {
            return null;
        }
        if (n >= this.clippingPlanes.size() || this.clippingPlanes.get(n) == null) {
            this.clippingPlanes.add(n, new G2DClippingPlane(n, this.drawingTools));
        }
        return this.clippingPlanes.get(n);
    }

    @Override
    public void disableClipping() {
        for (ClippingPlane clippingPlane : this.clippingPlanes) {
            if (clippingPlane == null) continue;
            clippingPlane.setEnable(false);
        }
    }
}

