/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.buffers;

import java.nio.IntBuffer;
import java.util.Collection;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;

public class G2DIndicesBuffer
implements IndicesBuffer,
DataBuffer {
    private IntBuffer data = null;

    G2DIndicesBuffer() {
    }

    @Override
    public void setData(int[] nArray) {
        IntBuffer intBuffer = IntBuffer.allocate(nArray.length);
        intBuffer.rewind();
        intBuffer.put(nArray);
        intBuffer.rewind();
        this.data = intBuffer;
    }

    @Override
    public void setData(Collection<Integer> collection) {
        IntBuffer intBuffer = IntBuffer.allocate(collection.size());
        intBuffer.rewind();
        for (int n : collection) {
            intBuffer.put(n);
        }
        intBuffer.rewind();
        this.data = intBuffer;
    }

    @Override
    public void setData(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = IntBuffer.allocate(intBuffer.limit());
        intBuffer2.rewind();
        intBuffer.rewind();
        intBuffer2.put(intBuffer);
        intBuffer2.rewind();
        intBuffer.rewind();
        this.data = intBuffer2;
    }

    @Override
    public int getSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.limit();
    }

    @Override
    public IntBuffer getData() {
        return this.data.asReadOnlyBuffer();
    }

    @Override
    public void clear() {
        this.data.clear();
        this.data = null;
    }
}

