/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.fop;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.fop.JLaTeXMathObj;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class JLaTeXMathElement
extends JLaTeXMathObj {
    private float size;
    private Color fg;
    private TeXIcon icon = null;
    private boolean bool = true;
    private String PR_COLOR = "PR_COLOR";

    public JLaTeXMathElement(FONode parent) {
        super(parent);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        super.processNode(elementName, locator, attlist, propertyList);
        Element e = this.createBasicDocument().getDocumentElement();
        e.setAttribute("size", "" + this.size);
        e.setAttribute("fg", "" + this.fg.getRGB());
    }

    public Point2D getDimension(Point2D p) {
        if (this.icon == null) {
            this.icon = JLaTeXMathElement.calculate(this.doc, this.size);
        }
        return new Point2D.Float(this.icon.getTrueIconWidth(), this.icon.getTrueIconHeight());
    }

    public Length getIntrinsicAlignmentAdjust() {
        if (this.icon == null) {
            this.icon = JLaTeXMathElement.calculate(this.doc, this.size);
        }
        return FixedLength.getInstance((double)(-this.icon.getTrueIconDepth()), (String)"px");
    }

    public static float getFWidth(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        int sum = 0;
        while (tok.hasMoreTokens()) {
            int i;
            String s = tok.nextToken();
            for (i = 0; i < s.length() && !Character.isLetter(s.charAt(i)); ++i) {
            }
            double w = 0.0;
            try {
                w = Double.parseDouble(s.substring(0, i));
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
            String unit = "px";
            if (i != s.length()) {
                unit = s.substring(i).toLowerCase();
            }
            sum += FixedLength.getInstance((double)w, (String)unit).getValue();
        }
        return (float)sum / 1000.0f;
    }

    public static TeXIcon calculate(Document doc, float size) {
        Element e = doc.getDocumentElement();
        String code = e.getTextContent();
        String style = e.getAttribute("style");
        int st = 0;
        if ("text".equals(style)) {
            st = 2;
        } else if ("script".equals(style)) {
            st = 4;
        } else if ("script_script".equals(style)) {
            st = 6;
        }
        NamedNodeMap attributes = e.getAttributes();
        int len = attributes.getLength();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            map.put(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
        }
        String stfw = e.getAttribute("fwidth");
        TeXIcon icon = stfw.length() != 0 ? new TeXFormula(code, map).createTeXIcon(st, size, 2, JLaTeXMathElement.getFWidth(stfw), 2) : new TeXFormula(code, map).createTeXIcon(st, size, true);
        return icon;
    }

    protected PropertyList createPropertyList(PropertyList pList, FOEventHandler foEventHandler) throws FOPException {
        FOUserAgent userAgent = this.getUserAgent();
        CommonFont commonFont = pList.getFontProps();
        this.size = (float)commonFont.fontSize.getNumericValue() / 1000.0f;
        int n = 72;
        try {
            n = Constants.class.getDeclaredField(this.PR_COLOR).getInt(null);
        }
        catch (Exception e) {
            System.err.println("Error in getting field:\n" + e);
        }
        Property colorProp = pList.get(n);
        this.fg = colorProp != null ? colorProp.getColor(userAgent) : null;
        return super.createPropertyList(pList, foEventHandler);
    }
}

