/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.Presentation;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class WindowPresentation
extends Presentation {
    private HelpSet.Presentation hsPres = null;
    private JFrame frame = null;
    private JHelp jhelp = null;
    private JDialog dialog = null;
    private Window ownerWindow = null;
    private boolean modallyActivated = false;
    private Point location = null;
    private String title = null;
    private Image image = null;
    private String currentView = null;
    private boolean viewDisplayed = true;
    private boolean toolbarDisplayed = true;
    private boolean destroyOnExit = false;
    private boolean titleFromDocument = false;
    private WindowPropertyChangeListener propertyChangeListener = null;
    private int screen = 0;
    WindowListener dl;
    boolean modalDeactivated = true;
    private static final boolean debug = false;

    public WindowPresentation(HelpSet hs) {
        this.setHelpSet(hs);
    }

    public void setHelpSetPresentation(HelpSet.Presentation hsPres) {
        Map.ID imageID;
        String title;
        WindowPresentation.debug("setHelpSetPrsentation");
        if (hsPres == null) {
            return;
        }
        super.setHelpSetPresentation(hsPres);
        Point location = hsPres.getLocation();
        if (location != null) {
            this.setLocation(location);
        }
        if ((title = hsPres.getTitle()) != null) {
            this.setTitle(title);
        }
        if ((imageID = hsPres.getImageID()) != null) {
            ImageIcon icon = null;
            try {
                Map map = this.getHelpSet().getCombinedMap();
                URL url = map.getURLFromID(imageID);
                icon = new ImageIcon(url);
                this.image = icon.getImage();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (hsPres.isToolbar()) {
            this.setToolbarDisplayed(true);
        }
        if (hsPres.isViewDisplayed()) {
            this.setViewDisplayed(true);
        }
        this.hsPres = hsPres;
    }

    public HelpSet.Presentation getHelpSetPresentation() {
        return this.hsPres;
    }

    public Window getActivationWindow() {
        WindowPresentation.debug("getActivationWindow");
        return this.ownerWindow;
    }

    public void setActivationWindow(Window window) {
        WindowPresentation.debug("setActivationWindow");
        if (window != null && window instanceof Dialog) {
            Dialog tmpDialog = (Dialog)window;
            if (tmpDialog.isModal()) {
                this.ownerWindow = window;
                this.modallyActivated = true;
            } else {
                this.ownerWindow = null;
                this.modallyActivated = false;
            }
        } else {
            this.ownerWindow = null;
            this.modallyActivated = false;
        }
    }

    public void setActivationObject(Object comp) {
        WindowPresentation.debug("setActivationObject");
        while (comp instanceof MenuComponent) {
            comp = ((MenuComponent)comp).getParent();
        }
        Window owner = null;
        if (comp instanceof Frame) {
            owner = (Window)comp;
        } else if (comp instanceof Component) {
            owner = SwingUtilities.windowForComponent((Component)comp);
        }
        this.setActivationWindow(owner);
    }

    public String getCurrentView() {
        WindowPresentation.debug("getCurrentView");
        if (this.jhelp != null) {
            this.currentView = this.jhelp.getCurrentNavigator().getNavigatorName();
        }
        return this.currentView;
    }

    public void setCurrentView(String name) {
        WindowPresentation.debug("setCurrentView");
        if (this.jhelp != null) {
            JHelpNavigator nav = this.getNavigatorByName(name);
            if (nav == null) {
                throw new IllegalArgumentException("Invalid view name");
            }
            this.jhelp.setCurrentNavigator(nav);
        } else {
            HelpSet hs = this.getHelpSet();
            NavigatorView view = hs.getNavigatorView(name);
            if (view == null) {
                throw new IllegalArgumentException("Invalid view name");
            }
        }
        this.currentView = name;
    }

    private JHelpNavigator getNavigatorByName(String name) {
        JHelpNavigator nav = null;
        if (this.jhelp != null) {
            Enumeration e = this.jhelp.getHelpNavigators();
            while (e.hasMoreElements() && !(nav = (JHelpNavigator)e.nextElement()).getNavigatorName().equals(name)) {
                nav = null;
            }
        }
        return nav;
    }

    public boolean isDestroyedOnExit() {
        WindowPresentation.debug("isDestoryedOnExit");
        return this.destroyOnExit;
    }

    public void setDestroyOnExit(boolean destroy) {
        WindowPresentation.debug("setDestoryOnExit");
        this.destroyOnExit = destroy;
    }

    public void destroy() {
        this.frame = null;
        this.jhelp = null;
        this.dialog = null;
        this.ownerWindow = null;
        this.location = null;
        this.title = null;
        this.currentView = null;
        this.propertyChangeListener = null;
        this.screen = 0;
    }

    public void setHelpSet(HelpSet hs) {
        WindowPresentation.debug("setHelpSet");
        HelpSet helpset = super.getHelpSet();
        if (hs != null && helpset != hs) {
            super.setHelpSet(hs);
            if (this.jhelp != null) {
                this.jhelp.setModel(super.getHelpModel());
            }
        }
    }

    public void setDisplayed(boolean b) {
        WindowPresentation.debug("setDisplayed");
        if (this.jhelp == null && !b) {
            return;
        }
        this.createHelpWindow();
        if (this.modallyActivated) {
            if (b) {
                this.dialog.show();
            } else {
                this.dialog.hide();
            }
        } else {
            this.frame.setVisible(b);
            try {
                Class[] types = new Class[]{Integer.TYPE};
                Method m = Frame.class.getMethod("setState", types);
                if (m != null) {
                    Object[] args = new Object[]{new Integer(0)};
                    m.invoke((Object)this.frame, args);
                }
            }
            catch (NoSuchMethodError ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isDisplayed() {
        WindowPresentation.debug("isDisplayed");
        if (this.jhelp == null) {
            return false;
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.isShowing();
            }
            return false;
        }
        if (this.frame != null) {
            if (!this.frame.isShowing()) {
                return false;
            }
            try {
                Method m = Frame.class.getMethod("getState", null);
                if (m != null) {
                    int value = (Integer)m.invoke((Object)this.frame, (Object[])null);
                    return value == 0;
                }
            }
            catch (NoSuchMethodError ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setFont(Font f) {
        WindowPresentation.debug("setFont");
        super.setFont(f);
        if (this.jhelp != null && f != null) {
            this.jhelp.setFont(f);
        }
    }

    public Font getFont() {
        WindowPresentation.debug("getFont");
        Font font = super.getFont();
        if (font == null) {
            if (this.jhelp == null) {
                this.createHelpWindow();
            }
            return this.jhelp.getFont();
        }
        return font;
    }

    public void setLocale(Locale l) {
        WindowPresentation.debug("setLocale");
        super.setLocale(l);
        if (this.jhelp != null) {
            this.jhelp.setLocale(l);
        }
    }

    private boolean isXinerama() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        if (gds.length == 1) {
            return false;
        }
        for (int i = 0; i < gds.length; ++i) {
            GraphicsConfiguration loopgc = gds[i].getDefaultConfiguration();
            Rectangle bounds = loopgc.getBounds();
            if (bounds.x == 0 && bounds.y == 0) continue;
            return true;
        }
        return false;
    }

    public Point getLocation() {
        WindowPresentation.debug("getLocation");
        if (this.location != null && this.jhelp == null) {
            return this.location;
        }
        if (this.jhelp == null) {
            this.createHelpWindow();
        }
        if (this.modallyActivated) {
            Point dlocation = this.dialog.getLocation();
            if (this.isXinerama()) {
                GraphicsConfiguration gc = this.dialog.getGraphicsConfiguration();
                Rectangle gcBounds = gc.getBounds();
                return new Point(dlocation.x - gcBounds.x, dlocation.y - gcBounds.y);
            }
            return dlocation;
        }
        Point flocation = this.frame.getLocation();
        if (this.isXinerama()) {
            GraphicsConfiguration gc = this.frame.getGraphicsConfiguration();
            Rectangle gcBounds = gc.getBounds();
            return new Point(flocation.x - gcBounds.x, flocation.y - gcBounds.y);
        }
        return flocation;
    }

    public void setLocation(Point p) {
        WindowPresentation.debug("setLocation");
        this.location = p;
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                if (this.dialog != null) {
                    GraphicsConfiguration gc = this.dialog.getGraphicsConfiguration();
                    Rectangle gcBounds = gc.getBounds();
                    Point loc = new Point(gcBounds.x + p.x, gcBounds.y + p.y);
                    this.dialog.setLocation(loc);
                }
            } else if (this.frame != null) {
                GraphicsConfiguration gc = this.frame.getGraphicsConfiguration();
                Rectangle gcBounds = gc.getBounds();
                Point loc = new Point(gcBounds.x + p.x, gcBounds.y + p.y);
                this.frame.setLocation(loc);
            }
        }
    }

    public int getScreen() {
        WindowPresentation.debug("getScreen");
        if (this.jhelp == null) {
            return this.screen;
        }
        GraphicsConfiguration gc = null;
        if (this.modallyActivated) {
            if (this.dialog != null) {
                gc = this.dialog.getGraphicsConfiguration();
            }
        } else if (this.frame != null) {
            gc = this.frame.getGraphicsConfiguration();
        }
        if (gc != null) {
            GraphicsDevice device = gc.getDevice();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            for (int i = 0; i < gs.length; ++i) {
                if (gs[i] != device) continue;
                this.screen = i;
                return this.screen;
            }
        }
        return this.screen;
    }

    public void setScreen(int screen) {
        WindowPresentation.debug("setScreen");
        if (screen == this.screen) {
            return;
        }
        if (screen < 0) {
            throw new IllegalArgumentException("Invalid screen");
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (gs.length <= screen) {
            throw new IllegalArgumentException("Invalid Screen");
        }
        this.screen = screen;
        if (this.jhelp != null) {
            boolean xinerama = this.isXinerama();
            GraphicsDevice gd = gs[screen];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle gcBounds = gc.getBounds();
            if (this.modallyActivated) {
                if (this.dialog != null) {
                    if (xinerama) {
                        Point p = this.getLocation();
                        Point loc = new Point(gcBounds.x + p.x, gcBounds.y + p.y);
                        this.dialog.setLocation(loc);
                    } else {
                        this.location = this.getLocation();
                        this.dialog.hide();
                        this.dialog = null;
                        this.createHelpWindow();
                    }
                }
            } else if (this.frame != null) {
                if (xinerama) {
                    Point p = this.getLocation();
                    Point loc = new Point(gcBounds.x + p.x, gcBounds.y + p.y);
                    this.frame.setLocation(loc);
                } else {
                    this.location = this.getLocation();
                    this.frame.setVisible(false);
                    this.frame = null;
                    this.createHelpWindow();
                }
            }
        }
    }

    public Dimension getSize() {
        WindowPresentation.debug("getSize");
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                if (this.dialog != null) {
                    return this.dialog.getSize();
                }
            } else if (this.frame != null) {
                return this.frame.getSize();
            }
        }
        return super.getSize();
    }

    public void setSize(Dimension d) {
        WindowPresentation.debug("setSize");
        super.setSize(d);
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                this.dialog.setSize(d);
                this.dialog.validate();
            } else {
                this.frame.setSize(d);
                this.frame.validate();
            }
        }
    }

    public String getTitle() {
        String docTitle;
        WindowPresentation.debug("getTitle");
        if (this.titleFromDocument && this.jhelp != null && (docTitle = this.jhelp.getContentViewer().getDocumentTitle()) != null) {
            return docTitle;
        }
        if (this.title != null) {
            return this.title;
        }
        HelpSet hs = this.getHelpSet();
        if (hs != null) {
            this.title = hs.getTitle();
        }
        return this.title;
    }

    public void setTitle(String title) {
        WindowPresentation.debug("setTitle");
        this.title = title;
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                this.dialog.setTitle(title);
                this.dialog.validate();
            } else {
                this.frame.setTitle(title);
                this.frame.validate();
            }
        }
    }

    public boolean isTitleSetFromDocument() {
        WindowPresentation.debug("isTitleSetFromDocument");
        return this.titleFromDocument;
    }

    public void setTitleFromDocument(boolean b) {
        WindowPresentation.debug("setTitleFromDocument");
        if (this.titleFromDocument != b) {
            this.titleFromDocument = b;
            if (this.titleFromDocument) {
                this.propertyChangeListener = new WindowPropertyChangeListener();
                if (this.jhelp != null) {
                    this.jhelp.getContentViewer().addPropertyChangeListener("page", this.propertyChangeListener);
                }
            } else if (this.jhelp != null) {
                this.jhelp.getContentViewer().removePropertyChangeListener("page", this.propertyChangeListener);
            }
        }
    }

    public boolean isViewDisplayed() {
        WindowPresentation.debug("isViewDisplayed");
        if (this.jhelp != null) {
            return this.jhelp.isNavigatorDisplayed();
        }
        return this.viewDisplayed;
    }

    public void setViewDisplayed(boolean displayed) {
        WindowPresentation.debug("setViewDisplayed");
        if (this.jhelp != null) {
            this.jhelp.setNavigatorDisplayed(displayed);
        }
        this.viewDisplayed = displayed;
    }

    public boolean isToolbarDisplayed() {
        WindowPresentation.debug("isToolbarDisplayed");
        if (this.jhelp != null) {
            return this.jhelp.isToolbarDisplayed();
        }
        return this.toolbarDisplayed;
    }

    public void setToolbarDisplayed(boolean displayed) {
        WindowPresentation.debug("setToolbarDisplayed=" + displayed);
        if (this.jhelp != null) {
            this.jhelp.setToolbarDisplayed(displayed);
        }
        this.toolbarDisplayed = displayed;
    }

    private synchronized void createJHelp() {
        WindowPresentation.debug("createJHelp");
        if (this.jhelp == null) {
            JHelpNavigator nav;
            Locale locale;
            this.jhelp = new JHelp(this.getHelpModel(), null, this.getHelpSetPresentation());
            Font font = super.getFont();
            if (font != null) {
                this.jhelp.setFont(font);
            }
            if ((locale = this.getLocale()) != null) {
                this.jhelp.setLocale(locale);
            }
            this.jhelp.setToolbarDisplayed(this.toolbarDisplayed);
            this.jhelp.setNavigatorDisplayed(this.viewDisplayed);
            if (this.currentView != null && (nav = this.getNavigatorByName(this.currentView)) != null) {
                this.jhelp.setCurrentNavigator(nav);
            }
            if (this.titleFromDocument) {
                this.jhelp.getContentViewer().addPropertyChangeListener("page", this.propertyChangeListener);
            }
        }
    }

    public synchronized void createHelpWindow() {
        WindowPresentation.debug("createHelpWindow");
        Point pos = null;
        Dimension size = this.getSize();
        JDialog tmpDialog = null;
        this.createJHelp();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        GraphicsDevice gd = gds[this.screen];
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Rectangle gcBounds = gc.getBounds();
        if (this.modallyActivated) {
            Window owner = null;
            try {
                Method m = Window.class.getMethod("getOwner", null);
                if (m != null && this.dialog != null) {
                    owner = (Window)m.invoke((Object)this.dialog, (Object[])null);
                }
            }
            catch (NoSuchMethodError ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
            if (this.dialog == null || owner != this.ownerWindow || this.modalDeactivated) {
                if (this.frame != null) {
                    pos = this.frame.getLocation();
                    size = this.frame.getSize();
                    this.frame = null;
                }
                if (this.dialog != null) {
                    pos = this.dialog.getLocation();
                    size = this.dialog.getSize();
                    tmpDialog = this.dialog;
                }
                this.dialog = new JDialog((Dialog)this.ownerWindow, this.getTitle(), false, gc);
                this.dl = new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        WindowPresentation.debug("modal window closing");
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                        if (WindowPresentation.this.dialog.isShowing()) {
                            WindowPresentation.this.dialog.hide();
                        }
                        if (WindowPresentation.this.ownerWindow != null) {
                            WindowPresentation.this.ownerWindow.removeWindowListener(WindowPresentation.this.dl);
                        }
                        WindowPresentation.this.ownerWindow = null;
                        WindowPresentation.this.modalDeactivated = true;
                    }

                    public void windowClosed(WindowEvent e) {
                        WindowPresentation.debug("modal window closing");
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                    }
                };
                WindowPresentation.debug("adding windowlistener");
                this.ownerWindow.addWindowListener(this.dl);
                this.modalDeactivated = false;
                if (size != null) {
                    this.dialog.setSize(size);
                } else {
                    this.dialog.setSize(this.getSize());
                }
                if (pos != null) {
                    this.dialog.setLocation(pos);
                } else {
                    Point loc = null;
                    if (this.location != null) {
                        loc = this.isXinerama() ? new Point(gcBounds.x + this.location.x, gcBounds.y + this.location.y) : this.location;
                        this.dialog.setLocation(loc);
                    }
                }
                this.dialog.setTitle(this.getTitle());
                this.dialog.getContentPane().add(this.jhelp);
                if (tmpDialog != null) {
                    tmpDialog.hide();
                    tmpDialog = null;
                }
            }
        } else {
            if (this.frame == null) {
                this.frame = new JFrame(this.getTitle(), gc);
                WindowAdapter l = new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                        WindowPresentation.this.frame.setVisible(false);
                    }

                    public void windowClosed(WindowEvent e) {
                        WindowPresentation.this.frame.setVisible(false);
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                    }
                };
                this.frame.addWindowListener(l);
                if (this.image != null) {
                    this.frame.setIconImage(this.image);
                }
            }
            if (this.dialog != null) {
                pos = this.dialog.getLocation();
                size = this.dialog.getSize();
                this.dialog.hide();
                this.dialog = null;
                this.ownerWindow = null;
            }
            if (size != null) {
                this.frame.setSize(size);
            } else {
                this.frame.setSize(this.getSize());
            }
            if (pos != null) {
                this.frame.setLocation(pos);
            } else {
                Point loc = null;
                if (this.location != null) {
                    loc = this.isXinerama() ? new Point(gcBounds.x + this.location.x, gcBounds.y + this.location.y) : this.location;
                    this.frame.setLocation(loc);
                }
            }
            this.frame.getContentPane().add(this.jhelp);
            this.frame.setTitle(this.getTitle());
        }
    }

    public Window getHelpWindow() {
        if (this.modallyActivated) {
            return this.dialog;
        }
        return this.frame;
    }

    private static void debug(Object msg) {
    }

    private class WindowPropertyChangeListener
    implements PropertyChangeListener {
        private WindowPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String changeName = event.getPropertyName();
            if (changeName.equals("page")) {
                String title = WindowPresentation.this.getTitle();
                if (WindowPresentation.this.modallyActivated) {
                    WindowPresentation.this.dialog.setTitle(title);
                } else {
                    WindowPresentation.this.frame.setTitle(title);
                }
            }
        }
    }
}

