/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.Map;

public class TreeItem
implements Serializable {
    public static final int DEFAULT_EXPANSION = -1;
    public static final int COLLAPSE = 0;
    public static final int EXPAND = 1;
    private String name;
    private Map.ID id;
    protected Locale locale;
    private String mergeType;
    private int expand = -1;
    private String presentation;
    private String presentationName;
    private HelpSet hs;

    public TreeItem(Map.ID id, HelpSet hs, Locale locale) {
        this.id = id;
        this.hs = hs;
        this.locale = locale;
    }

    public TreeItem(Map.ID id, Locale locale) {
        this(id, null, locale);
    }

    public TreeItem(String name) {
        this(null, null, null);
        this.setName(name);
    }

    public TreeItem() {
        this(null, null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setID(Map.ID id) {
        this.id = id;
    }

    public Map.ID getID() {
        return this.id;
    }

    public URL getURL() {
        try {
            return this.id.getURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setHelpSet(HelpSet hs) {
        this.hs = hs;
    }

    public HelpSet getHelpSet() {
        return this.hs;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setMergeType(String mergeType) {
        this.mergeType = mergeType;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public void setExpansionType(int type) {
        if (type < -1 || type > 1) {
            throw new IllegalArgumentException("Invalid expansion type");
        }
        this.expand = type;
    }

    public int getExpansionType() {
        return this.expand;
    }

    public void setPresentation(String presentation) {
        this.presentation = presentation;
    }

    public String getPresentation() {
        return this.presentation;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String toString() {
        return this.id + "(" + this.name + ")";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

