/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptList;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NonnegativeIntegerGenerator;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import com.sun.java.help.search.Schema;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.SearchItem;

class SearchEnvironment {
    private IntegerArray concepts;
    private IntegerArray offsets;
    private byte[] allLists;
    private IntegerArray concepts3;
    private IntegerArray offsets3;
    private byte[] allChildren;
    private IntegerArray documents;
    private IntegerArray offsets2;
    private IntegerArray titles;
    private RAFFile positionsFile = null;
    private byte[] positions;
    private ByteArrayDecompressor compr;
    private BtreeDict tmap;
    private URL base;
    private String indexDir;
    private static boolean debugFlag = false;

    public SearchEnvironment(String indexDir, URL hsBase) throws Exception {
        this.base = hsBase;
        this.indexDir = indexDir;
        this.readFromDB();
        this.compr = new ByteArrayDecompressor(null, 0);
    }

    public int fetch(String conceptName) throws Exception {
        return this.tmap.fetch(conceptName);
    }

    public String fetch(int conceptID) throws Exception {
        return this.tmap.fetch(conceptID);
    }

    public SearchItem makeItem(QueryHit hit) throws Exception {
        Vector<String> concepts = new Vector<String>();
        int[] conceptIDs = hit.getArray();
        for (int i = 0; i < conceptIDs.length; ++i) {
            if (conceptIDs[i] <= 0) continue;
            concepts.addElement(this.fetch(conceptIDs[i]));
        }
        int begin = hit.getBegin();
        int end = hit.getEnd();
        return new SearchItem(this.base, this.fetch(this.titles.at(hit.getDocument())), Locale.getDefault().toString(), this.fetch(this.documents.at(hit.getDocument())), hit.getScore(), begin, end, concepts);
    }

    public String hitToString(QueryHit hit) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append(hit.getScore());
        result.append(" ");
        result.append(this.fetch(this.documents.at(hit.getDocument())));
        result.append(" [");
        int begin = hit.getBegin();
        int end = hit.getEnd();
        result.append(begin);
        result.append(", ");
        result.append(end);
        result.append("], {");
        int[] concepts = hit.getArray();
        for (int i = 0; i < concepts.length; ++i) {
            if (concepts[i] > 0) {
                result.append(this.fetch(concepts[i]));
            } else {
                result.append("--");
            }
            if (i >= concepts.length - 1) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    public byte[] getPositions(int docId) throws IOException {
        int offset = this.offsets2.at(docId);
        int upto = docId + 1 == this.offsets2.cardinality() ? (int)this.positionsFile.length() : this.offsets2.at(docId + 1);
        this.positions = new byte[upto - offset];
        this.positionsFile.seek(offset);
        this.positionsFile.read(this.positions, 0, upto - offset);
        return this.positions;
    }

    public int getDocumentIndex(int docId) {
        return this.offsets2.at(docId);
    }

    public void close() throws IOException {
        this.positionsFile.close();
    }

    public boolean occursInText(int concept) {
        return this.concepts.indexOf(concept) >= 0;
    }

    public NonnegativeIntegerGenerator getDocumentIterator(int concept) {
        int index = this.concepts.indexOf(concept);
        if (index >= 0) {
            return new ConceptList(this.allLists, this.offsets.at(index));
        }
        return null;
    }

    public NonnegativeIntegerGenerator getChildIterator(int concept) {
        int index = this.concepts3.indexOf(concept);
        if (index >= 0) {
            return new ConceptList(this.allChildren, this.offsets3.at(index));
        }
        return null;
    }

    public void getChildren(int concept, IntegerArray array) throws Exception {
        int index = this.concepts3.indexOf(concept);
        if (index >= 0) {
            int where = this.offsets3.at(index);
            this.compr.initReading(this.allChildren, where + 1);
            this.compr.ascDecode(this.allChildren[where], array);
        }
    }

    public int getConceptLength(int concept) throws Exception {
        return this.tmap.fetch(concept).length();
    }

    private URL getURL(String s) throws MalformedURLException {
        URL hsBase = this.base;
        String dir = this.indexDir;
        URL baseURL = null;
        if (hsBase == null) {
            File file = new File(dir);
            if (file.exists()) {
                if (File.separatorChar != '/') {
                    dir = dir.replace(File.separatorChar, '/');
                }
                if (dir.lastIndexOf(47) != dir.length() - 1) {
                    dir = dir.concat("/");
                }
                SearchEnvironment.debug("file:" + dir);
                baseURL = new URL("file", "", dir);
            } else {
                baseURL = new URL(dir);
            }
        }
        URL back = hsBase != null ? new URL(hsBase, dir + "/" + s) : new URL(baseURL, s);
        return back;
    }

    private void readChildrenData() throws Exception {
        try {
            URL url = this.getURL("CHILDREN.TAB");
            URLConnection connect = url.openConnection();
            InputStream ois = connect.getInputStream();
            if (ois == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            BufferedInputStream in = new BufferedInputStream(ois);
            int k1 = in.read();
            this.concepts3 = new IntegerArray(4096);
            StreamDecompressor sddocs = new StreamDecompressor(in);
            sddocs.ascDecode(k1, this.concepts3);
            int k2 = in.read();
            this.offsets3 = new IntegerArray(this.concepts3.cardinality() + 1);
            this.offsets3.add(0);
            StreamDecompressor sdoffsets = new StreamDecompressor(in);
            sdoffsets.ascDecode(k2, this.offsets3);
            in.close();
            url = this.getURL("CHILDREN");
            connect = url.openConnection();
            ois = connect.getInputStream();
            if (ois == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            in = new BufferedInputStream(ois);
            int length = connect.getContentLength();
            this.allChildren = new byte[length];
            in.read(this.allChildren);
            in.close();
        }
        catch (MalformedURLException e) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (FileNotFoundException e2) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (IOException e2) {
            this.concepts3 = new IntegerArray(1);
        }
    }

    private void readFromDB() throws Exception {
        BufferedInputStream in = null;
        Schema schema = new Schema(this.base, this.indexDir, false);
        BtreeDictParameters params = new BtreeDictParameters(schema, "TMAP");
        params.readState();
        this.tmap = new BtreeDict(params);
        this.readChildrenData();
        URL url = this.getURL("DOCS.TAB");
        URLConnection connect = url.openConnection();
        in = new BufferedInputStream(connect.getInputStream());
        int k1 = in.read();
        this.concepts = new IntegerArray(4096);
        StreamDecompressor sddocs = new StreamDecompressor(in);
        sddocs.ascDecode(k1, this.concepts);
        int k2 = in.read();
        this.offsets = new IntegerArray(this.concepts.cardinality() + 1);
        this.offsets.add(0);
        StreamDecompressor sdoffsets = new StreamDecompressor(in);
        sdoffsets.ascDecode(k2, this.offsets);
        in.close();
        url = this.getURL("DOCS");
        connect = url.openConnection();
        in = new BufferedInputStream(connect.getInputStream());
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        int i = 0;
        while ((i = in.read(buff)) != -1) {
            data.write(buff, 0, i);
        }
        this.allLists = data.toByteArray();
        in.close();
        url = this.getURL("OFFSETS");
        connect = url.openConnection();
        in = new BufferedInputStream(connect.getInputStream());
        k1 = in.read();
        this.documents = new IntegerArray(4096);
        sddocs = new StreamDecompressor(in);
        sddocs.ascDecode(k1, this.documents);
        k2 = in.read();
        this.offsets2 = new IntegerArray(this.documents.cardinality() + 1);
        sdoffsets = new StreamDecompressor(in);
        sdoffsets.ascDecode(k2, this.offsets2);
        int k3 = in.read();
        this.titles = new IntegerArray(this.documents.cardinality());
        StreamDecompressor sdtitles = new StreamDecompressor(in);
        sdtitles.decode(k3, this.titles);
        in.close();
        RAFFileFactory factory = RAFFileFactory.create();
        url = this.getURL("POSITIONS");
        this.positionsFile = factory.get(url, false);
    }

    private static void debug(String str) {
        if (debugFlag) {
            System.out.println("SearchEnvironment: " + str);
        }
    }
}

