/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.PrintStream;

class IntegerArray {
    private int[] _array;
    private int _size;
    private int _free = 0;
    private static final int InitialSize = 128;

    public IntegerArray() {
        this._size = 128;
        this._array = new int[128];
    }

    public IntegerArray(int size) {
        this._size = size;
        this._array = new int[this._size];
    }

    public void clear() {
        this._free = 0;
    }

    public int at(int index) {
        return this._array[index];
    }

    public void add(int value) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = value;
    }

    private void growArray(int size) {
        this._size = size;
        int[] newArray = new int[this._size];
        System.arraycopy(this._array, 0, newArray, 0, this._free);
        this._array = newArray;
    }

    public int popLast() {
        return this._array[--this._free];
    }

    public int cardinality() {
        return this._free;
    }

    public void toDifferences(IntegerArray result) {
        if (result._size < this._size) {
            result.growArray(this._size);
        }
        if ((result._free = this._free) > 0) {
            result._array[0] = this._array[0];
            for (int i = 1; i < this._free; ++i) {
                result._array[i] = this._array[i] - this._array[i - 1];
            }
        }
    }

    public int indexOf(int value) {
        int i = 0;
        int j = this._free;
        while (i <= j) {
            int k = (i + j) / 2;
            if (this._array[k] < value) {
                i = k + 1;
                continue;
            }
            if (value < this._array[k]) {
                j = k - 1;
                continue;
            }
            return k;
        }
        return -1;
    }

    public void print(PrintStream out) {
        for (int i = 0; i < this._free - 1; ++i) {
            out.print(this._array[i]);
            out.print(' ');
        }
        out.println(this._array[this._free - 1]);
    }
}

