/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptGroupGenerator;
import com.sun.java.help.search.RoleFiller;

class GeneratorHeap {
    private static final int InitSize = 128;
    private int _heapSize = 0;
    private ConceptGroupGenerator[] _heap = new ConceptGroupGenerator[128];
    private int _size = 128;
    private int _free = 0;

    public void reset() {
        this._free = 0;
    }

    public void addGenerator(ConceptGroupGenerator gen) {
        if (this._free == this._size) {
            ConceptGroupGenerator[] newArray = new ConceptGroupGenerator[this._size *= 2];
            System.arraycopy(this._heap, 0, newArray, 0, this._free);
            this._heap = newArray;
        }
        this._heap[this._free++] = gen;
    }

    private void buildHeap() {
        for (int i = this._heapSize / 2; i >= 0; --i) {
            this.heapify(i);
        }
    }

    private void heapify(int i) {
        int smallest;
        int r = i + 1 << 1;
        int l = r - 1;
        int n = smallest = l < this._heapSize && this._heap[l].position() < this._heap[i].position() ? l : i;
        if (r < this._heapSize && this._heap[r].position() < this._heap[smallest].position()) {
            smallest = r;
        }
        if (smallest != i) {
            ConceptGroupGenerator temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            this.heapify(smallest);
        }
    }

    public boolean start(RoleFiller[] array) throws Exception {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            for (int i = 0; i < this._free; ++i) {
                this._heap[i].next();
            }
            this.buildHeap();
            this._heap[0].generateFillers(array);
            return true;
        }
        return false;
    }

    public boolean next(RoleFiller[] array) throws Exception {
        if (this._heapSize > 0) {
            if (!this._heap[0].next()) {
                if (this._heapSize > 1) {
                    this._heap[0] = this._heap[--this._heapSize];
                } else {
                    this._heapSize = 0;
                    return false;
                }
            }
            this.heapify(0);
            this._heap[0].generateFillers(array);
            return true;
        }
        return false;
    }
}

