/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.DataOutput;
import java.io.IOException;

class BitBuffer {
    private static final int InitSize = 256;
    private static final int NBits = 32;
    private static final int BitsInByte = 8;
    private static final int BytesInInt = 4;
    private int _avail = 32;
    private int _word = 0;
    private int _free = 0;
    private int _size = 256;
    private int[] _array = new int[256];

    BitBuffer() {
    }

    public void close() {
        if (this._avail < 32) {
            this.store(this._word << this._avail);
        } else {
            this._avail = 0;
        }
    }

    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < this._free - 1; ++i) {
            out.writeInt(this._array[i]);
        }
        int word = this._array[this._free - 1];
        int bytes = 4 - this._avail / 8;
        int shift = 32;
        while (bytes-- > 0) {
            out.writeByte(word >>> (shift -= 8) & 0xFF);
        }
    }

    public void clear() {
        this._word = 0;
        this._avail = 32;
        this._free = 0;
    }

    public int byteCount() {
        return this._free * 4 - this._avail / 8;
    }

    public int bitCount() {
        return 32 * this._free - this._avail;
    }

    public void setFrom(BitBuffer rhs) {
        this._word = rhs._word;
        this._avail = rhs._avail;
        this._free = rhs._free;
        if (this._free > this._size) {
            this._size = rhs._free;
            this._array = new int[this._size];
        }
        System.arraycopy(rhs._array, 0, this._array, 0, this._free);
    }

    private void growArray(int newSize) {
        this._size = newSize;
        int[] newArray = new int[this._size];
        System.arraycopy(this._array, 0, newArray, 0, this._free);
        this._array = newArray;
    }

    private void store(int value) {
        if (this._free == this._size) {
            this.growArray(this._size * 2);
        }
        this._array[this._free++] = value;
    }

    public void append(int bit) {
        this._word = this._word << 1 | bit;
        if (--this._avail == 0) {
            this.store(this._word);
            this._word = 0;
            this._avail = 32;
        }
    }

    public void append(int source, int kBits) {
        if (kBits < this._avail) {
            this._word = this._word << kBits | source;
            this._avail -= kBits;
        } else if (kBits > this._avail) {
            int leftover = kBits - this._avail;
            this.store(this._word << this._avail | source >>> leftover);
            this._word = source;
            this._avail = 32 - leftover;
        } else {
            this.store(this._word << kBits | source);
            this._word = 0;
            this._avail = 32;
        }
    }

    public void concatenate(BitBuffer bb) {
        if (32 * (this._size - this._free) + this._avail < bb.bitCount()) {
            this.growArray(this._free + bb._free + 1);
        }
        if (this._avail == 0) {
            System.arraycopy(bb._array, 0, this._array, this._free, bb._free);
            this._avail = bb._avail;
            this._free += bb._free;
        } else {
            int tp = this._free - 1;
            int sp = 0;
            do {
                int n = tp++;
                this._array[n] = this._array[n] | bb._array[sp] >>> 32 - this._avail;
                if (tp >= this._array.length) break;
                this._array[tp] = bb._array[sp++] << this._avail;
            } while (sp < bb._free);
            this._free += bb._free;
            if ((this._avail += bb._avail) >= 32) {
                this._avail -= 32;
                --this._free;
            }
        }
    }
}

