/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class mxEdgeHandler
extends mxCellHandler {
    protected boolean cloneEnabled = true;
    protected Point[] p;
    protected transient String error;
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected mxCellMarker marker = new mxCellMarker(this.graphComponent){
        private static final long serialVersionUID = 8826073441093831764L;

        @Override
        protected Object getCell(MouseEvent mouseEvent) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
            Object object = super.getCell(mouseEvent);
            if (object == mxEdgeHandler.this.state.getCell() || !mxGraph2.isConnectableEdges() && mxIGraphModel2.isEdge(object)) {
                object = null;
            }
            return object;
        }

        @Override
        protected boolean isValidState(mxCellState mxCellState2) {
            mxGraphView mxGraphView2 = this.graphComponent.getGraph().getView();
            mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
            Object object = mxEdgeHandler.this.state.getCell();
            boolean bl = mxEdgeHandler.this.isSource(mxEdgeHandler.this.index);
            mxCellState mxCellState3 = mxGraphView2.getTerminalPort(mxCellState2, mxGraphView2.getState(mxIGraphModel2.getTerminal(object, !bl)), !bl);
            Object object2 = mxCellState3 != null ? mxCellState3.getCell() : null;
            Object object3 = bl ? mxCellState2.getCell() : object2;
            Object object4 = bl ? object2 : mxCellState2.getCell();
            mxEdgeHandler.this.error = mxEdgeHandler.this.validateConnection(object3, object4);
            return mxEdgeHandler.this.error == null;
        }
    };

    public mxEdgeHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        super(mxGraphComponent2, mxCellState2);
    }

    public void setCloneEnabled(boolean bl) {
        this.cloneEnabled = bl;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    @Override
    protected boolean isIgnoredEvent(MouseEvent mouseEvent) {
        return !this.isFlipEvent(mouseEvent) && super.isIgnoredEvent(mouseEvent);
    }

    protected boolean isFlipEvent(MouseEvent mouseEvent) {
        return false;
    }

    public String validateConnection(Object object, Object object2) {
        return this.graphComponent.getGraph().getEdgeValidationError(this.state.getCell(), object, object2);
    }

    public boolean isSource(int n) {
        return n == 0;
    }

    public boolean isTarget(int n) {
        return n == this.getHandleCount() - 2;
    }

    @Override
    protected boolean isHandleVisible(int n) {
        return super.isHandleVisible(n) && (this.isSource(n) || this.isTarget(n) || this.isCellBendable());
    }

    protected boolean isCellBendable() {
        return this.graphComponent.getGraph().isCellBendable(this.state.getCell());
    }

    @Override
    protected Rectangle[] createHandles() {
        this.p = this.createPoints(this.state);
        Rectangle[] rectangleArray = new Rectangle[this.p.length + 1];
        for (int i = 0; i < rectangleArray.length - 1; ++i) {
            rectangleArray[i] = this.createHandle(this.p[i]);
        }
        rectangleArray[this.p.length] = this.createHandle(this.state.getAbsoluteOffset().getPoint(), mxConstants.LABEL_HANDLE_SIZE);
        return rectangleArray;
    }

    @Override
    protected Color getHandleFillColor(int n) {
        boolean bl = this.isSource(n);
        if (bl || this.isTarget(n)) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            Object object = mxGraph2.getModel().getTerminal(this.state.getCell(), bl);
            if (object == null && !this.graphComponent.getGraph().isTerminalPointMovable(this.state.getCell(), bl)) {
                return mxSwingConstants.LOCKED_HANDLE_FILLCOLOR;
            }
            if (object != null) {
                return this.graphComponent.getGraph().isCellDisconnectable(this.state.getCell(), object, bl) ? mxSwingConstants.CONNECT_HANDLE_FILLCOLOR : mxSwingConstants.LOCKED_HANDLE_FILLCOLOR;
            }
        }
        return super.getHandleFillColor(n);
    }

    @Override
    public int getIndexAt(int n, int n2) {
        int n3 = super.getIndexAt(n, n2);
        if (n3 < 0 && this.handles != null && this.handlesVisible && this.isLabelMovable() && this.state.getLabelBounds().getRectangle().contains(n, n2)) {
            n3 = this.handles.length - 1;
        }
        return n3;
    }

    protected Rectangle createHandle(Point point) {
        return this.createHandle(point, mxConstants.HANDLE_SIZE);
    }

    protected Rectangle createHandle(Point point, int n) {
        return new Rectangle(point.x - n / 2, point.y - n / 2, n, n);
    }

    protected Point[] createPoints(mxCellState mxCellState2) {
        Point[] pointArray = new Point[mxCellState2.getAbsolutePointCount()];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = mxCellState2.getAbsolutePoint(i).getPoint();
        }
        return pointArray;
    }

    @Override
    protected JComponent createPreview() {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -894546588972313020L;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!mxEdgeHandler.this.isLabel(mxEdgeHandler.this.index) && mxEdgeHandler.this.p != null) {
                    ((Graphics2D)graphics).setStroke(mxSwingConstants.PREVIEW_STROKE);
                    if (mxEdgeHandler.this.isSource(mxEdgeHandler.this.index) || mxEdgeHandler.this.isTarget(mxEdgeHandler.this.index)) {
                        if (mxEdgeHandler.this.marker.hasValidState() || mxEdgeHandler.this.graphComponent.getGraph().isAllowDanglingEdges()) {
                            graphics.setColor(mxSwingConstants.DEFAULT_VALID_COLOR);
                        } else {
                            graphics.setColor(mxSwingConstants.DEFAULT_INVALID_COLOR);
                        }
                    } else {
                        graphics.setColor(Color.BLACK);
                    }
                    Point point = this.getLocation();
                    Point point2 = mxEdgeHandler.this.p[0];
                    for (int i = 1; i < mxEdgeHandler.this.p.length; ++i) {
                        graphics.drawLine(point2.x - point.x, point2.y - point.y, mxEdgeHandler.this.p[i].x - point.x, mxEdgeHandler.this.p[i].y - point.y);
                        point2 = mxEdgeHandler.this.p[i];
                    }
                }
            }
        };
        if (this.isLabel(this.index)) {
            jPanel.setBorder(mxSwingConstants.PREVIEW_BORDER);
        }
        jPanel.setOpaque(false);
        jPanel.setVisible(false);
        return jPanel;
    }

    protected mxPoint convertPoint(mxPoint mxPoint2, boolean bl) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        double d = mxGraph2.getView().getScale();
        mxPoint mxPoint3 = mxGraph2.getView().getTranslate();
        double d2 = mxPoint2.getX() / d - mxPoint3.getX();
        double d3 = mxPoint2.getY() / d - mxPoint3.getY();
        if (bl) {
            d2 = mxGraph2.snap(d2);
            d3 = mxGraph2.snap(d3);
        }
        mxPoint2.setX(d2 - this.state.getOrigin().getX());
        mxPoint2.setY(d3 - this.state.getOrigin().getY());
        return mxPoint2;
    }

    protected Rectangle getPreviewBounds() {
        Rectangle rectangle = null;
        if (this.isLabel(this.index)) {
            rectangle = this.state.getLabelBounds().getRectangle();
        } else {
            rectangle = new Rectangle(this.p[0]);
            for (int i = 0; i < this.p.length; ++i) {
                rectangle.add(this.p[i]);
            }
            ++rectangle.height;
            ++rectangle.width;
        }
        return rectangle;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        mxGraph mxGraph2;
        mxIGraphModel mxIGraphModel2;
        Object object;
        super.mousePressed(mouseEvent);
        boolean bl = this.isSource(this.index);
        if ((bl || this.isTarget(this.index)) && ((object = (mxIGraphModel2 = (mxGraph2 = this.graphComponent.getGraph()).getModel()).getTerminal(this.state.getCell(), bl)) == null && !mxGraph2.isTerminalPointMovable(this.state.getCell(), bl) || object != null && !mxGraph2.isCellDisconnectable(this.state.getCell(), object, bl))) {
            this.first = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.first != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            boolean bl = this.isSource(this.index);
            boolean bl2 = this.isTarget(this.index);
            Object object = null;
            Object object2 = null;
            if (this.isLabel(this.index)) {
                mxPoint mxPoint2 = this.state.getAbsoluteOffset();
                double d = mxPoint2.getX() - (double)this.first.x;
                double d2 = mxPoint2.getY() - (double)this.first.y;
                mxPoint mxPoint3 = new mxPoint(mouseEvent.getPoint());
                if (this.gridEnabledEvent) {
                    mxPoint3 = this.graphComponent.snapScaledPoint(mxPoint3, d, d2);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                        mxPoint3.setY(mxPoint2.getY());
                    } else {
                        mxPoint3.setX(mxPoint2.getX());
                    }
                }
                Rectangle rectangle = this.getPreviewBounds();
                rectangle.translate((int)Math.round(mxPoint3.getX() - (double)this.first.x), (int)Math.round(mxPoint3.getY() - (double)this.first.y));
                this.preview.setBounds(rectangle);
            } else {
                Object object3;
                mxPoint mxPoint4;
                mxGeometry mxGeometry2 = this.graphComponent.getGraph().getCellGeometry(this.state.getCell());
                mxCellState mxCellState2 = (mxCellState)this.state.clone();
                List<mxPoint> list = mxGeometry2.getPoints();
                mxGraphView mxGraphView2 = mxCellState2.getView();
                if (bl || bl2) {
                    this.marker.process(mouseEvent);
                    mxPoint4 = this.marker.getValidState();
                    object2 = this.state.getVisibleTerminal(!bl);
                    if (mxPoint4 != null) {
                        object = ((mxCellState)mxPoint4).getCell();
                    } else {
                        object3 = new mxPoint(mouseEvent.getPoint());
                        if (this.gridEnabledEvent) {
                            object3 = this.graphComponent.snapScaledPoint((mxPoint)object3);
                        }
                        mxCellState2.setAbsoluteTerminalPoint((mxPoint)object3, bl);
                    }
                    if (!bl) {
                        object3 = object;
                        object = object2;
                        object2 = object3;
                    }
                } else {
                    mxPoint4 = this.convertPoint(new mxPoint(mouseEvent.getPoint()), this.gridEnabledEvent);
                    if (list == null) {
                        list = Arrays.asList(mxPoint4);
                    } else if (this.index - 1 < list.size()) {
                        list = new ArrayList<mxPoint>(list);
                        list.set(this.index - 1, mxPoint4);
                    }
                    object = mxGraphView2.getVisibleTerminal(this.state.getCell(), true);
                    object2 = mxGraphView2.getVisibleTerminal(this.state.getCell(), false);
                }
                mxPoint4 = mxGraphView2.getState(object);
                object3 = mxGraphView2.getState(object2);
                mxConnectionConstraint mxConnectionConstraint2 = this.graphComponent.getGraph().getConnectionConstraint(mxCellState2, (mxCellState)mxPoint4, true);
                mxConnectionConstraint mxConnectionConstraint3 = this.graphComponent.getGraph().getConnectionConstraint(mxCellState2, (mxCellState)object3, false);
                if (!bl || mxPoint4 != null) {
                    mxGraphView2.updateFixedTerminalPoint(mxCellState2, (mxCellState)mxPoint4, true, mxConnectionConstraint2);
                }
                if (!bl2 || object3 != null) {
                    mxGraphView2.updateFixedTerminalPoint(mxCellState2, (mxCellState)object3, false, mxConnectionConstraint3);
                }
                mxGraphView2.updatePoints(mxCellState2, list, (mxCellState)mxPoint4, (mxCellState)object3);
                mxGraphView2.updateFloatingTerminalPoints(mxCellState2, (mxCellState)mxPoint4, (mxCellState)object3);
                this.p = this.createPoints(mxCellState2);
                this.preview.setBounds(this.getPreviewBounds());
            }
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(mouseEvent.getX() - this.first.x, mouseEvent.getY() - this.first.y)) {
                this.preview.setVisible(true);
            } else if (this.preview.isVisible()) {
                this.preview.repaint();
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        double d;
        double d2;
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        if (!mouseEvent.isConsumed() && this.first != null && this.graphComponent.isSignificant(d2 = (double)(mouseEvent.getX() - this.first.x), d = (double)(mouseEvent.getY() - this.first.y))) {
            if (this.error != null) {
                if (this.error.length() > 0) {
                    JOptionPane.showMessageDialog(this.graphComponent, this.error);
                }
            } else if (this.isLabel(this.index)) {
                mxPoint mxPoint2 = this.state.getAbsoluteOffset();
                d2 = mxPoint2.getX() - (double)this.first.x;
                d = mxPoint2.getY() - (double)this.first.y;
                mxPoint mxPoint3 = new mxPoint(mouseEvent.getPoint());
                if (this.gridEnabledEvent) {
                    mxPoint3 = this.graphComponent.snapScaledPoint(mxPoint3, d2, d);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(mouseEvent.getX() - this.first.x) > Math.abs(mouseEvent.getY() - this.first.y)) {
                        mxPoint3.setY(mxPoint2.getY());
                    } else {
                        mxPoint3.setX(mxPoint2.getX());
                    }
                }
                this.moveLabelTo(this.state, mxPoint3.getX() + d2, mxPoint3.getY() + d);
            } else if (this.marker.hasValidState() && (this.isSource(this.index) || this.isTarget(this.index))) {
                this.connect(this.state.getCell(), this.marker.getValidState().getCell(), this.isSource(this.index), this.graphComponent.isCloneEvent(mouseEvent) && this.isCloneEnabled());
            } else if (!this.isSource(this.index) && !this.isTarget(this.index) || this.graphComponent.getGraph().isAllowDanglingEdges()) {
                this.movePoint(this.state.getCell(), this.index, this.convertPoint(new mxPoint(mouseEvent.getPoint()), this.gridEnabledEvent));
            }
            mouseEvent.consume();
        }
        if (!mouseEvent.isConsumed() && this.isFlipEvent(mouseEvent)) {
            mxGraph2.flipEdge(this.state.getCell());
            mouseEvent.consume();
        }
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void reset() {
        super.reset();
        this.marker.reset();
        this.error = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void movePoint(Object object, int n, mxPoint mxPoint2) {
        mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            mxIGraphModel2.beginUpdate();
            try {
                mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                if (this.isSource(this.index) || this.isTarget(this.index)) {
                    this.connect(object, null, this.isSource(this.index), false);
                    mxGeometry2.setTerminalPoint(mxPoint2, this.isSource(this.index));
                } else {
                    List<mxPoint> list = mxGeometry2.getPoints();
                    if (list == null) {
                        list = new ArrayList<mxPoint>();
                        mxGeometry2.setPoints(list);
                    }
                    if (list != null) {
                        if (n <= list.size()) {
                            list.set(n - 1, mxPoint2);
                        } else if (n - 1 <= list.size()) {
                            list.add(n - 1, mxPoint2);
                        }
                    }
                }
                mxIGraphModel2.setGeometry(object, mxGeometry2);
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxIGraphModel2.beginUpdate();
        try {
            if (bl2) {
                Object object3 = mxGraph2.cloneCells(new Object[]{object})[0];
                Object object4 = mxIGraphModel2.getParent(object);
                mxGraph2.addCells(new Object[]{object3}, object4);
                Object object5 = mxIGraphModel2.getTerminal(object, !bl);
                mxGraph2.connectCell(object3, object5, !bl);
                mxGraph2.setSelectionCell(object3);
                object = object3;
            }
            mxGraph2.connectCell(object, object2, bl, new mxConnectionConstraint());
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
    }

    protected void moveLabelTo(mxCellState mxCellState2, double d, double d2) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(this.state.getCell());
        if (mxGeometry2 != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxPoint mxPoint2 = mxGraph2.getView().getRelativePoint(mxCellState2, d, d2);
            mxGeometry2.setX(mxPoint2.getX());
            mxGeometry2.setY(mxPoint2.getY());
            double d3 = mxGraph2.getView().getScale();
            mxGeometry2.setOffset(new mxPoint(0.0, 0.0));
            mxPoint2 = mxGraph2.getView().getPoint(mxCellState2, mxGeometry2);
            mxGeometry2.setOffset(new mxPoint(Math.round((d - mxPoint2.getX()) / d3), Math.round((d2 - mxPoint2.getY()) / d3)));
            mxIGraphModel2.setGeometry(mxCellState2.getCell(), mxGeometry2);
        }
    }

    @Override
    protected Cursor getCursor(MouseEvent mouseEvent, int n) {
        Cursor cursor = null;
        cursor = this.isLabel(n) ? new Cursor(13) : new Cursor(12);
        return cursor;
    }

    @Override
    public Color getSelectionColor() {
        return mxSwingConstants.EDGE_SELECTION_COLOR;
    }

    @Override
    public Stroke getSelectionStroke() {
        return mxSwingConstants.EDGE_SELECTION_STROKE;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.getSelectionStroke());
        graphics.setColor(this.getSelectionColor());
        Point point = this.state.getAbsolutePoint(0).getPoint();
        for (int i = 1; i < this.state.getAbsolutePointCount(); ++i) {
            Point point2 = this.state.getAbsolutePoint(i).getPoint();
            Line2D.Float float_ = new Line2D.Float(point.x, point.y, point2.x, point2.y);
            Rectangle rectangle = graphics2D.getStroke().createStrokedShape(float_).getBounds();
            if (graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                graphics2D.draw(float_);
            }
            point = point2;
        }
        graphics2D.setStroke(stroke);
        super.paint(graphics);
    }
}

