/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.util;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.scirenderer.texture.TextEntity;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureDrawingTools;
import org.scilab.modules.console.utils.ScilabSpecialTextUtilities;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.textObject.Font;
import org.scilab.modules.graphic_objects.textObject.FormattedText;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.utils.textRendering.FontManager;

public class FormattedTextSpriteDrawer
implements TextureDrawer {
    private TextEntity textEntity;
    private Dimension dimension;
    private int descent;
    private Icon icon = null;

    public FormattedTextSpriteDrawer(ColorMap colorMap, FormattedText formattedText) {
        String string = formattedText.getText();
        String string2 = FormattedText.InterpreterType.enumToString((FormattedText.InterpreterType)formattedText.getInterpreterAsEnum());
        Font font = formattedText.getFont();
        boolean bl = true;
        if (string != null && font != null) {
            if (this.isLatex(string) && string2.equals("auto") || string2.equals("latex")) {
                LoadClassPath.loadOnUse((String)"graphics_latex_textrendering");
                try {
                    TeXFormula teXFormula = new TeXFormula(this.formatLaTeXString(string));
                    teXFormula.setColor((Color)ColorFactory.createColor(colorMap, font.getColor()));
                    this.icon = teXFormula.createTeXIcon(0, FontManager.scilabSizeToAwtSize(font.getSize()));
                    this.descent = ((TeXIcon)this.icon).getIconDepth();
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else if (FormattedTextSpriteDrawer.isMathML(string) && string2.equals("auto") || string2.equals("mathml")) {
                LoadClassPath.loadOnUse((String)"graphics_mathml_textrendering");
                try {
                    this.icon = ScilabSpecialTextUtilities.compileMathMLExpression((String)string, (int)((int)FontManager.scilabSizeToAwtSize(font.getSize() + 0.5)), (Color)ColorFactory.createColor(colorMap, font.getColor()));
                    this.descent = 0;
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                this.descent = 0;
            }
            if (this.icon != null) {
                this.textEntity = null;
                this.dimension = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight() + this.descent);
            } else {
                this.textEntity = new TextEntity(string);
                this.textEntity.setFont(FontManager.getSciFontManager().getFontFromIndex(font.getStyle(), font.getSize()));
                this.textEntity.setText(string);
                if (bl) {
                    this.textEntity.setTextColor(ColorFactory.createColor(colorMap, font.getColor()));
                } else {
                    this.textEntity.setTextColor(new org.scilab.forge.scirenderer.shapes.appearance.Color(1.0f, 0.0f, 0.0f));
                }
                this.textEntity.setTextUseFractionalMetrics(font.getFractional().booleanValue());
                this.textEntity.setTextAntiAliased(true);
                this.dimension = this.textEntity.getSize();
            }
        } else {
            this.icon = null;
            this.textEntity = null;
            this.dimension = new Dimension();
            this.descent = 0;
        }
    }

    public void draw(TextureDrawingTools textureDrawingTools) {
        if (this.textEntity != null) {
            textureDrawingTools.draw(this.textEntity, 0, 0);
        } else if (this.icon != null) {
            textureDrawingTools.draw(this.icon, 0, this.descent);
        }
    }

    public Dimension getTextureSize() {
        return new Dimension(this.dimension);
    }

    public TextureDrawer.OriginPosition getOriginPosition() {
        return TextureDrawer.OriginPosition.UPPER_LEFT;
    }

    public Dimension getSpriteSize() {
        return new Dimension(this.dimension);
    }

    public boolean isLatex(String string) {
        long l = string.chars().filter(n -> n == 36).count();
        return string.length() >= 2 && l == 2L && string.endsWith("$") && string.startsWith("$");
    }

    public String formatLaTeXString(String string) {
        Object object = "";
        object = this.isLatex(string) ? string.substring(1, string.length() - 1) : "\\text{" + string + "}";
        return object;
    }

    public static boolean isMathML(String string) {
        return string.length() >= 2 && string.endsWith(">") && string.startsWith("<");
    }
}

