/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.label;

import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.label.Label;
import org.scilab.modules.graphic_objects.textObject.TextObject;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.TextObjectSpriteDrawer;

public class LabelSpriteDrawer
extends TextObjectSpriteDrawer
implements TextureDrawer {
    public LabelSpriteDrawer(ColorMap colorMap, Label label) {
        super(colorMap, (TextObject)label);
        this.setAlignmentFactor(0.0f);
        Appearance appearance = this.computeAppearance(colorMap, label);
        this.setAppearance(appearance);
        this.setThickness((int)Math.ceil(appearance.getLineWidth()));
    }

    private Appearance computeAppearance(ColorMap colorMap, Label label) {
        Color color;
        Appearance appearance = new Appearance();
        if (label.getFillMode().booleanValue()) {
            color = ColorFactory.createColor(colorMap, label.getBackground());
            appearance.setFillColor(color);
        } else {
            appearance.setFillColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }
        if (label.getLineMode().booleanValue() && label.getFillMode().booleanValue()) {
            color = ColorFactory.createColor(colorMap, label.getLineColor());
            appearance.setLineColor(color);
            appearance.setLineWidth(1.0f);
        } else {
            appearance.setLineWidth(0.0f);
        }
        return appearance;
    }
}

