/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction.util;

import java.awt.Point;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.renderer.JoGLView.interaction.util.AbstractPointComputer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointComputer;

public class PointBComputer
extends AbstractPointComputer
implements PointComputer {
    private final int firstAxisIndex;
    private final boolean is2D;
    private Vector3d firstPosition;
    private Vector3d secondPosition;

    public PointBComputer(Axes axes, PointComputer pointComputer, Point point) {
        super(axes, point);
        this.firstAxisIndex = pointComputer.getFirstAxisIndex();
        if (this.firstAxisIndex != -1) {
            double d = pointComputer.getFirstPosition().getData()[this.firstAxisIndex];
            double d2 = this.computeLambda(d, this.firstAxisIndex);
            Vector3d vector3d = this.computeCoordinate(d2, d, this.firstAxisIndex);
            this.firstPosition = pointComputer.getFirstPosition();
            this.secondPosition = this.clamp(vector3d);
            if (this.check2D()) {
                double[] dArray = this.firstPosition.getData();
                dArray[this.firstAxisIndex] = -1.7976931348623157E308;
                this.firstPosition = this.clamp(new Vector3d(dArray));
                dArray = this.secondPosition.getData();
                dArray[this.firstAxisIndex] = Double.MAX_VALUE;
                this.secondPosition = this.clamp(new Vector3d(dArray));
                this.is2D = true;
            } else {
                this.is2D = false;
            }
        } else {
            this.is2D = false;
            this.firstPosition = null;
            this.secondPosition = null;
        }
    }

    private boolean check2D() {
        boolean bl = true;
        Double[] doubleArray = this.getAxes().getDataBounds();
        float[] fArray = new float[]{(float)(doubleArray[0] + doubleArray[1]) / 2.0f, (float)(doubleArray[2] + doubleArray[3]) / 2.0f, (float)(doubleArray[4] + doubleArray[5]) / 2.0f};
        for (int i = 0; i < 3; ++i) {
            if (i == this.firstAxisIndex) continue;
            double d = this.computeLambda(fArray[i], i);
            bl &= !(d >= 0.0) || !(d <= 1.0);
        }
        return bl;
    }

    @Override
    public final boolean isValid() {
        return this.secondPosition != null;
    }

    @Override
    public final boolean is2D() {
        return this.is2D;
    }

    @Override
    public final int getFirstAxisIndex() {
        return this.firstAxisIndex;
    }

    @Override
    public final Vector3d getFirstPosition() {
        return this.firstPosition;
    }

    @Override
    public final Vector3d getSecondPosition() {
        return this.secondPosition;
    }
}

