/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction.util;

import java.nio.FloatBuffer;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBox;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointComputer;

public class HelpersGeometry
extends DefaultGeometry {
    private static final double HELPERS_SIZE = 0.05;
    private static final int VERTEX_BUFFER_SIZE = 64;
    private final BuffersManager bufferManager;
    private final ElementsBuffer vertexBuffer;

    public HelpersGeometry(DrawingTools drawingTools) {
        this.bufferManager = drawingTools.getCanvas().getBuffersManager();
        this.vertexBuffer = this.bufferManager.createElementsBuffer();
        this.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
        this.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
        this.setVertices(this.vertexBuffer);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.bufferManager.dispose((DataBuffer)this.vertexBuffer);
    }

    public void updateVertex(Axes axes, PointComputer pointComputer, Vector3d vector3d, RubberBox.Status status) {
        if (pointComputer != null && pointComputer.getFirstAxisIndex() != -1) {
            FloatBuffer floatBuffer;
            boolean bl;
            if (status == RubberBox.Status.WAIT_POINT_A || status == RubberBox.Status.WAIT_POINT_B) {
                bl = false;
                floatBuffer = FloatBuffer.allocate(128);
            } else {
                bl = true;
                floatBuffer = FloatBuffer.allocate(64);
            }
            Double[] doubleArray = axes.getCorrectedBounds();
            int n = (pointComputer.getFirstAxisIndex() + 1) % 3;
            for (int i = 0; i < 3; ++i) {
                if (!(n != i ^ bl)) continue;
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        double[] dArray = vector3d.getData();
                        dArray[i] = doubleArray[i * 2 + j];
                        int n2 = (i + 1) % 3;
                        dArray[n2] = doubleArray[n2 * 2 + k];
                        float[] fArray = this.asFloatArray(dArray);
                        floatBuffer.put(fArray);
                        fArray[i] = fArray[i] + (float)(0.05 * (doubleArray[i * 2 + (1 - j)] - doubleArray[i * 2 + j]));
                        floatBuffer.put(fArray);
                        fArray[i] = doubleArray[i * 2 + j].floatValue();
                        floatBuffer.put(fArray);
                        fArray[n2] = fArray[n2] + (float)(0.05 * (doubleArray[n2 * 2 + (1 - k)] - doubleArray[n2 * 2 + k]));
                        floatBuffer.put(fArray);
                    }
                }
            }
            floatBuffer.rewind();
            this.getVertices().setData(floatBuffer, 3);
        } else {
            this.getVertices().setData(new Float[0], 4);
        }
    }

    private float[] asFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }
}

