/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction.util;

import java.awt.Point;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.renderer.JoGLView.interaction.util.AbstractPointComputer;

public abstract class CubeFacesPointComputer
extends AbstractPointComputer {
    private final Vector3d position;
    private final int axisIndex;
    private static final double threshold = 0.05;

    public CubeFacesPointComputer(Axes axes, Point point) {
        super(axes, point);
        Double[] doubleArray = axes.getCorrectedBounds();
        double d = -1.7976931348623157E308;
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        double d2 = Double.MAX_VALUE;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < 3; ++i) {
            double d3 = -1.7976931348623157E308;
            int n3 = -1;
            Vector3d vector3d3 = null;
            for (int j = 0; j < 2; ++j) {
                double d4 = doubleArray[i * 2 + j];
                double d5 = this.computeLambda(d4, i);
                if (!(d5 > d)) continue;
                Vector3d vector3d4 = this.computeCoordinate(d5, d4, i);
                if (this.inBounds(vector3d4)) {
                    d = d5;
                    vector3d = vector3d4;
                    n2 = i;
                    continue;
                }
                if (!this.isValid(vector3d4) || !(d5 > d3)) continue;
                d3 = d5;
                vector3d3 = this.clamp(vector3d4);
                n3 = i;
            }
            if (!(d2 > d3) && !this.check2D()) continue;
            d2 = d3;
            n = n3;
            vector3d2 = vector3d3;
        }
        if (vector3d != null) {
            this.axisIndex = n2;
            this.position = this.check2D() ? vector3d : this.applyThreshold(vector3d);
        } else {
            this.axisIndex = n;
            this.position = this.check2D() ? vector3d2 : this.applyThreshold(vector3d2);
        }
    }

    private boolean check2D() {
        int n = 0;
        Double[] doubleArray = this.getAxes().getDataBounds();
        float[] fArray = new float[]{(float)(doubleArray[0] + doubleArray[1]) / 2.0f, (float)(doubleArray[2] + doubleArray[3]) / 2.0f, (float)(doubleArray[4] + doubleArray[5]) / 2.0f};
        for (int i = 0; i < 3; ++i) {
            double d = this.computeLambda(fArray[i], i);
            n = !(d >= 0.0) || !(d <= 1.0) ? n + 1 : n;
        }
        return n >= 2;
    }

    private Vector3d applyThreshold(Vector3d vector3d) {
        double[] dArray = vector3d.getData();
        double d = dArray[0] < 0.0 ? (dArray[0] - 0.05 < -1.0 ? -1.0 : dArray[0]) : (dArray[0] = dArray[0] + 0.05 > 1.0 ? 1.0 : dArray[0]);
        double d2 = dArray[1] < 0.0 ? (dArray[1] - 0.05 < -1.0 ? -1.0 : dArray[1]) : (dArray[1] = dArray[1] + 0.05 > 1.0 ? 1.0 : dArray[1]);
        dArray[2] = dArray[2] < 0.0 ? (dArray[2] - 0.05 < -1.0 ? -1.0 : dArray[2]) : (dArray[2] + 0.05 > 1.0 ? 1.0 : dArray[2]);
        return new Vector3d(dArray);
    }

    protected final int getAxisIndex() {
        return this.axisIndex;
    }

    public final Vector3d getPosition() {
        return this.position;
    }
}

