/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction.util;

import java.awt.Point;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.interaction.util.PointComputer;

public abstract class AbstractPointComputer
implements PointComputer {
    private final Vector3d min;
    private final Vector3d max;
    private final Axes axes;

    public AbstractPointComputer(Axes axes, Point point) {
        this.axes = axes;
        this.min = AxesDrawer.unProject(axes, new Vector3d((double)point.x, (double)point.y, -1.0));
        this.max = AxesDrawer.unProject(axes, new Vector3d((double)point.x, (double)point.y, 1.0));
    }

    protected final Axes getAxes() {
        return this.axes;
    }

    protected final double computeLambda(double d, int n) {
        double d2 = this.min.getData()[n];
        double d3 = this.max.getData()[n];
        return (d - d3) / (d2 - d3);
    }

    protected final Vector3d computeCoordinate(double d, double d2, int n) {
        double[] dArray = this.min.times(d).plus(this.max.times(1.0 - d)).getData();
        dArray[n] = d2;
        return new Vector3d(dArray);
    }

    protected final boolean inBounds(Vector3d vector3d) {
        Double[] doubleArray = this.axes.getCorrectedBounds();
        double[] dArray = vector3d.getData();
        for (int i = 0; i < 3; ++i) {
            if (!(doubleArray[i * 2] > dArray[i]) && !(doubleArray[i * 2 + 1] < dArray[i])) continue;
            return false;
        }
        return true;
    }

    protected final boolean isValid(Vector3d vector3d) {
        double[] dArray = vector3d.getData();
        for (int i = 0; i < 3; ++i) {
            if (!Double.isNaN(dArray[i]) && !Double.isInfinite(dArray[i])) continue;
            return false;
        }
        return true;
    }

    protected final Vector3d clamp(Vector3d vector3d) {
        Double[] doubleArray = this.axes.getCorrectedBounds();
        double[] dArray = vector3d.getData();
        for (int i = 0; i < 3; ++i) {
            if (dArray[i] < doubleArray[i * 2]) {
                dArray[i] = doubleArray[i * 2];
                continue;
            }
            if (!(dArray[i] > doubleArray[i * 2 + 1])) continue;
            dArray[i] = doubleArray[i * 2 + 1];
        }
        return new Vector3d(dArray);
    }

    protected final Vector3d setCoordinate(Vector3d vector3d, Vector3d vector3d2, int n) {
        double[] dArray = vector3d.getData();
        dArray[n] = vector3d2.getData()[n];
        return this.clamp(new Vector3d(dArray));
    }
}

