/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.interaction;

import java.awt.event.MouseEvent;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.interaction.RubberBox;
import org.scilab.modules.renderer.JoGLView.util.ScaleUtils;

public class ZoomRubberBox
extends RubberBox {
    public ZoomRubberBox(DrawerVisitor drawerVisitor) {
        super(drawerVisitor);
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
        this.mouseButton = mouseEvent.getButton();
        if (mouseEvent.getButton() == 1) {
            switch (this.status) {
                case WAIT_POINT_A: {
                    if (this.setPointA(mouseEvent.getPoint())) {
                        this.status = RubberBox.Status.WAIT_POINT_B;
                        break;
                    }
                    this.setEnable(false);
                    this.fireRubberBoxEnd();
                    break;
                }
                case WAIT_POINT_B: {
                    this.setPointB(mouseEvent.getPoint());
                    if (!this.valid3D()) {
                        this.process();
                        this.setEnable(false);
                        this.fireRubberBoxEnd();
                        break;
                    }
                    this.status = RubberBox.Status.WAIT_POINT_C;
                    break;
                }
                case WAIT_POINT_C: {
                    this.setPointC(mouseEvent.getPoint());
                    this.status = RubberBox.Status.WAIT_POINT_D;
                    break;
                }
                case WAIT_POINT_D: {
                    this.setPointD(mouseEvent.getPoint());
                    this.process();
                    this.setEnable(false);
                    this.fireRubberBoxEnd();
                    break;
                }
            }
            this.updateInfoMessage(mouseEvent.getPoint());
        }
        if (mouseEvent.getButton() == 3) {
            this.setEnable(false);
            this.fireRubberBoxEnd();
        }
    }

    @Override
    protected void process() {
        for (RubberBox.AxesZoom axesZoom : this.axesZoomList) {
            Double[] doubleArray = new Double[]{Math.min(axesZoom.firstPoint.getX(), axesZoom.secondPoint.getX()), Math.max(axesZoom.firstPoint.getX(), axesZoom.secondPoint.getX()), Math.min(axesZoom.firstPoint.getY(), axesZoom.secondPoint.getY()), Math.max(axesZoom.firstPoint.getY(), axesZoom.secondPoint.getY()), Math.min(axesZoom.firstPoint.getZ(), axesZoom.secondPoint.getZ()), Math.max(axesZoom.firstPoint.getZ(), axesZoom.secondPoint.getZ())};
            if (doubleArray[0].compareTo(doubleArray[1]) == 0 || doubleArray[2].compareTo(doubleArray[3]) == 0 || doubleArray[4].compareTo(doubleArray[5]) == 0) continue;
            Boolean bl = this.tightZoomBounds(axesZoom.axes, doubleArray);
            double[][] dArray = axesZoom.axes.getScaleTranslateFactors();
            doubleArray[0] = (doubleArray[0] - dArray[1][0]) / dArray[0][0];
            doubleArray[1] = (doubleArray[1] - dArray[1][0]) / dArray[0][0];
            doubleArray[2] = (doubleArray[2] - dArray[1][1]) / dArray[0][1];
            doubleArray[3] = (doubleArray[3] - dArray[1][1]) / dArray[0][1];
            doubleArray[4] = (doubleArray[4] - dArray[1][2]) / dArray[0][2];
            doubleArray[5] = (doubleArray[5] - dArray[1][2]) / dArray[0][2];
            boolean[] blArray = new boolean[]{axesZoom.axes.getXAxisLogFlag(), axesZoom.axes.getYAxisLogFlag(), axesZoom.axes.getZAxisLogFlag()};
            ScaleUtils.applyInverseLogScaleToBounds(doubleArray, blArray);
            GraphicController.getController().setProperty(axesZoom.axes.getIdentifier(), 180, (Object)doubleArray);
            GraphicController.getController().setProperty(axesZoom.axes.getIdentifier(), 179, (Object)bl);
            this.getDrawerVisitor().getCanvas().redraw();
        }
    }
}

