/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.texture.AbstractTextureDataProvider;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.modules.graphic_objects.MainDataLoader;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.util.BufferAllocation;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

public class ScilabTextureManager {
    private final Map<Integer, Texture> hashMap = new HashMap<Integer, Texture>();
    private final DrawerVisitor drawerVisitor;
    private final Canvas canvas;

    public ScilabTextureManager(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
        this.canvas = drawerVisitor.getCanvas();
    }

    public Texture getTexture(Integer n) {
        Texture texture = this.hashMap.get(n);
        if (texture == null) {
            texture = this.canvas.getTextureManager().createTexture();
            texture.setDataProvider((TextureDataProvider)new ScilabTextureDataProvider(n));
            texture.setMagnificationFilter(Texture.Filter.NEAREST);
            texture.setMinifyingFilter(Texture.Filter.NEAREST);
            this.hashMap.put(n, texture);
        }
        return texture;
    }

    public void dispose(Integer n) {
        Texture texture = this.hashMap.get(n);
        if (texture != null) {
            this.hashMap.remove(n);
            this.canvas.getTextureManager().dispose(texture);
        }
    }

    public void disposeAll() {
        for (Map.Entry<Integer, Texture> entry : this.hashMap.entrySet()) {
            Texture texture = entry.getValue();
            if (texture == null) continue;
            this.canvas.getTextureManager().dispose(texture);
        }
        this.hashMap.clear();
    }

    private class ScilabTextureDataProvider
    extends AbstractTextureDataProvider
    implements GraphicView {
        private final Integer identifier;
        private Dimension dimension;
        private int datatype = -1;
        private int iType = -1;
        private boolean isValid;
        private boolean isRowOrder;
        private ByteBuffer buffer;

        public ScilabTextureDataProvider(Integer n) {
            this.identifier = n;
            boolean bl = this.isValid = n != null;
            if (this.isValid()) {
                this.updateData();
            }
            GraphicController.getController().register((GraphicView)this);
        }

        public boolean isRowMajorOrder() {
            return this.isRowOrder;
        }

        private void updateData() {
            int n = MainDataLoader.getTextureWidth((Integer)this.identifier);
            int n2 = MainDataLoader.getTextureHeight((Integer)this.identifier);
            int n3 = MainDataLoader.getTextureGLType((Integer)this.identifier);
            int n4 = MainDataLoader.getTextureImageType((Integer)this.identifier);
            int n5 = MainDataLoader.getTextureDataType((Integer)this.identifier);
            boolean bl = MainDataLoader.isTextureRowOrder((Integer)this.identifier);
            this.imageType = TextureDataProvider.ImageType.fromInt((int)n3);
            if (this.dimension == null || this.dimension.width != n || this.dimension.height != n2 || n4 != this.iType || this.isRowOrder != bl || this.datatype != n5) {
                this.dimension = new Dimension(n, n2);
                this.isRowOrder = bl;
                this.datatype = n5;
                this.dispose(this.iType == 3);
                this.iType = n4;
            }
            this.fireUpdate();
        }

        public void dispose(boolean bl) {
            if (this.buffer != null) {
                if (bl) {
                    MainDataLoader.disposeTextureData((Integer)this.identifier, (ByteBuffer)this.buffer);
                }
                this.buffer = null;
            }
        }

        public Dimension getTextureSize() {
            if (this.isValid()) {
                return new Dimension(this.dimension);
            }
            return null;
        }

        public ByteBuffer getData() {
            if (this.buffer == null) {
                this.buffer = MainDataLoader.getTextureData((Integer)this.identifier);
                this.updateData();
            }
            if (this.iType == 3) {
                MainDataLoader.fillTextureData((Integer)this.identifier, (ByteBuffer)this.buffer, (int)this.buffer.capacity());
            }
            return this.buffer;
        }

        public ByteBuffer getSubData(int n, int n2, int n3, int n4) {
            ByteBuffer byteBuffer;
            int n5 = n3 * n4 * 4;
            try {
                byteBuffer = BufferAllocation.newByteBuffer(n5);
            }
            catch (OutOfMemoryException outOfMemoryException) {
                ScilabTextureManager.this.drawerVisitor.invalidate(GraphicController.getController().getObjectFromId(this.identifier), outOfMemoryException);
                return null;
            }
            MainDataLoader.fillTextureData((Integer)this.identifier, (ByteBuffer)byteBuffer, (int)n5, (int)n, (int)n2, (int)n3, (int)n4);
            byteBuffer.rewind();
            return byteBuffer;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public void updateObject(Integer n, int n2) {
            if (this.isValid() && this.identifier.equals(n)) {
                this.updateData();
            }
        }

        public void deleteObject(Integer n) {
            if (this.isValid() && this.identifier.equals(n)) {
                this.isValid = false;
                GraphicController.getController().unregister((GraphicView)this);
                this.dispose(this.iType == 3);
            }
        }

        public void createObject(Integer n) {
        }
    }
}

