/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.DefaultGeometry;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AbstractTextureDataProvider;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.surface.Fac3d;
import org.scilab.modules.renderer.JoGLView.DataManager;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.mark.MarkSpriteManager;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.LightingUtils;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

class Fac3dDrawer {
    private static final Set<Integer> TEXTURE_PROPERTIES = new HashSet<Integer>(Arrays.asList(228, 229, 30, 227));
    private final DrawerVisitor drawerVisitor;
    private final Map<Integer, Texture> textureMap;

    Fac3dDrawer(DrawerVisitor drawerVisitor) {
        this.drawerVisitor = drawerVisitor;
        this.textureMap = new HashMap<Integer, Texture>();
    }

    public void draw(Fac3d fac3d) throws ObjectRemovedException, OutOfMemoryException {
        if (fac3d.getVisible().booleanValue()) {
            DrawingTools drawingTools = this.drawerVisitor.getDrawingTools();
            DataManager dataManager = this.drawerVisitor.getDataManager();
            ColorMap colorMap = this.drawerVisitor.getColorMap();
            AxesDrawer axesDrawer = this.drawerVisitor.getAxesDrawer();
            Axes axes = this.drawerVisitor.getAxes();
            MarkSpriteManager markSpriteManager = this.drawerVisitor.getMarkManager();
            try {
                Object object;
                Texture texture;
                DefaultGeometry defaultGeometry;
                if (fac3d.getSurfaceMode().booleanValue()) {
                    defaultGeometry = new DefaultGeometry();
                    defaultGeometry.setVertices(dataManager.getVertexBuffer(fac3d.getIdentifier()));
                    defaultGeometry.setNormals(dataManager.getNormalBuffer(fac3d.getIdentifier()));
                    defaultGeometry.setIndices(dataManager.getIndexBuffer(fac3d.getIdentifier()));
                    defaultGeometry.setPolygonOffsetMode(true);
                    texture = new Appearance();
                    texture.setMaterial(LightingUtils.getMaterial(fac3d.getMaterial()));
                    LightingUtils.setupLights(drawingTools.getLightManager(), axes);
                    if (fac3d.getColorMode() != 0) {
                        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.TRIANGLES);
                        if (fac3d.getHiddenColor() > 0) {
                            defaultGeometry.setFaceCullingMode(axesDrawer.getBackFaceCullingMode());
                            object = new Appearance();
                            object.setFillColor(ColorFactory.createColor(colorMap, fac3d.getHiddenColor()));
                            drawingTools.draw((Geometry)defaultGeometry, (Appearance)object);
                            defaultGeometry.setFaceCullingMode(axesDrawer.getFrontFaceCullingMode());
                        } else {
                            defaultGeometry.setFaceCullingMode(Geometry.FaceCullingMode.BOTH);
                        }
                        if (fac3d.getColorFlag() == 0) {
                            texture.setFillColor(ColorFactory.createColor(colorMap, Math.abs(fac3d.getColorMode())));
                        } else if (fac3d.getColorFlag() > 0) {
                            defaultGeometry.setTextureCoordinates(dataManager.getTextureCoordinatesBuffer(fac3d.getIdentifier()));
                            texture.setTexture(this.getTexture(fac3d));
                        } else {
                            defaultGeometry.setColors(null);
                        }
                    } else {
                        defaultGeometry.setFillDrawingMode(Geometry.FillDrawingMode.NONE);
                    }
                    if (fac3d.getColorMode() >= 0 && fac3d.getLineThickness() > 0.0) {
                        defaultGeometry.setLineDrawingMode(Geometry.LineDrawingMode.SEGMENTS);
                        defaultGeometry.setWireIndices(dataManager.getWireIndexBuffer(fac3d.getIdentifier()));
                        object = fac3d.getSelected() != false ? fac3d.getSelectedColor() : fac3d.getLineColor();
                        texture.setLineColor(ColorFactory.createColor(colorMap, (Integer)object));
                        texture.setLineWidth(fac3d.getLineThickness().floatValue());
                    }
                    drawingTools.draw((Geometry)defaultGeometry, (Appearance)texture);
                    LightingUtils.setLightingEnable(drawingTools.getLightManager(), false);
                }
                if (fac3d.getMarkMode().booleanValue()) {
                    defaultGeometry = null;
                    if (fac3d.getLineThickness() > 0.0) {
                        defaultGeometry = new Appearance();
                        defaultGeometry.setLineWidth(fac3d.getLineThickness().floatValue());
                    }
                    texture = markSpriteManager.getMarkSprite((ContouredObject)fac3d, colorMap, (Appearance)defaultGeometry);
                    object = dataManager.getVertexBuffer(fac3d.getIdentifier());
                    drawingTools.draw(texture, AnchorPosition.CENTER, (ElementsBuffer)object);
                }
            }
            catch (SciRendererException sciRendererException) {
                System.err.println("A '" + fac3d.getType() + "' is not drawable because: '" + sciRendererException.getMessage() + "'");
            }
        }
    }

    private Texture getTexture(Fac3d fac3d) {
        Texture texture = this.textureMap.get(fac3d.getIdentifier());
        if (texture == null) {
            texture = this.drawerVisitor.getCanvas().getTextureManager().createTexture();
            texture.setSWrappingMode(Texture.Wrap.CLAMP);
            texture.setTWrappingMode(Texture.Wrap.CLAMP);
            texture.setMagnificationFilter(Texture.Filter.NEAREST);
            texture.setMinifyingFilter(Texture.Filter.NEAREST);
            this.textureMap.put(fac3d.getIdentifier(), texture);
        }
        if (texture.getDataProvider() == null) {
            texture.setDataProvider((TextureDataProvider)new Fac3dColorTexture(fac3d));
        }
        return texture;
    }

    public void update(Integer n, int n2) {
        Texture texture;
        if (TEXTURE_PROPERTIES.contains(n2) && (texture = this.textureMap.get(n)) != null) {
            texture.setDataProvider(null);
        }
    }

    void updateAll() throws ObjectRemovedException, OutOfMemoryException {
        for (Map.Entry<Integer, Texture> entry : this.textureMap.entrySet()) {
            this.drawerVisitor.getDataManager().updateTextureCoordinatesBuffer(entry.getKey());
            entry.getValue().setDataProvider(null);
        }
    }

    public void dispose(Integer n) {
        this.textureMap.remove(n);
    }

    private class Fac3dColorTexture
    extends AbstractTextureDataProvider {
        private final Fac3d fac3d;

        public Fac3dColorTexture(Fac3d fac3d) {
            this.fac3d = fac3d;
            this.imageType = TextureDataProvider.ImageType.RGBA_BYTE;
        }

        public Dimension getTextureSize() {
            return new Dimension(this.getTextureLength(), 1);
        }

        public ByteBuffer getData() {
            int n;
            int n2;
            ColorMap colorMap = Fac3dDrawer.this.drawerVisitor.getColorMap();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * this.getTextureLength());
            if (this.useColorRange()) {
                Integer[] integerArray = this.fac3d.getColorRange();
                n2 = Math.max(1, integerArray[0]);
                n = Math.min(colorMap.getSize(), integerArray[1]);
            } else {
                n2 = 1;
                n = colorMap.getSize();
            }
            byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, n2)));
            for (int i = n2; i <= n; ++i) {
                byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, i)));
            }
            byteBuffer.put(this.toByte(ColorFactory.createRGBAColor(colorMap, n)));
            byteBuffer.rewind();
            return byteBuffer;
        }

        public ByteBuffer getSubData(int n, int n2, int n3, int n4) {
            ByteBuffer byteBuffer = this.getData();
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4 * n3 * n4);
            byteBuffer.position(n + n2 * this.getTextureLength());
            byte[] byArray = new byte[4];
            for (int i = n; i < n + n3; ++i) {
                for (int j = n2; j < n2 + n4; ++j) {
                    byteBuffer.get(byArray);
                    byteBuffer2.put(byArray);
                }
            }
            byteBuffer2.rewind();
            byteBuffer.rewind();
            return byteBuffer2;
        }

        public boolean isValid() {
            return true;
        }

        private boolean useColorRange() {
            Integer[] integerArray = this.fac3d.getColorRange();
            return integerArray != null && integerArray.length == 2 && (integerArray[0] != 0 || integerArray[1] != 0);
        }

        private int getTextureLength() {
            ColorMap colorMap = Fac3dDrawer.this.drawerVisitor.getColorMap();
            if (this.useColorRange()) {
                Integer[] integerArray = this.fac3d.getColorRange();
                int n = Math.max(1, integerArray[0]);
                int n2 = Math.min(colorMap.getSize(), integerArray[1]);
                var2_5 = 1 + n2 - n;
            } else {
                var2_5 = colorMap.getSize();
            }
            return var2_5 += 2;
        }
    }
}

