/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.modules.graphic_objects.MainDataLoader;
import org.scilab.modules.graphic_objects.ObjectRemovedException;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.renderer.JoGLView.util.BufferAllocation;
import org.scilab.modules.renderer.JoGLView.util.OutOfMemoryException;

public class DataManager {
    private static final Set<Integer> FAC3D_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30, 251, 250, 228, 229, 227));
    private static final Set<Integer> FEC_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30, 225, 227, 226));
    private static final Set<Integer> GRAYPLOT_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30, 228));
    private static final Set<Integer> MATPLOT_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30));
    private static final Set<Integer> POLYLINE_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30, 241, 192, 248, 239, 196, 242, 244));
    private static final Set<Integer> PLOT3D_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(30));
    private static final Set<Integer> ARC_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(104, 105, 106, 107, 108));
    private static final Set<Integer> CHAMP_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(262, 263, 264, 266, 267, 268, 271));
    private static final Set<Integer> RECTANGLE_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(104, 105, 106));
    private static final Set<Integer> SEGS_DATA_PROPERTIES = new HashSet<Integer>(Arrays.asList(261, 265, 270));
    private static final double[] DEFAULT_SCALE = new double[]{1.0, 1.0, 1.0};
    private static final double[] DEFAULT_TRANSLATE = new double[]{0.0, 0.0, 0.0};
    private static final int DEFAULT_LOG_MASK = 0;
    private final Map<Integer, TransformedElementsBuffer> vertexBufferMap = new HashMap<Integer, TransformedElementsBuffer>();
    private final Map<Integer, ElementsBuffer> normalBufferMap = new HashMap<Integer, ElementsBuffer>();
    private final Map<Integer, ElementsBuffer> colorBufferMap = new ConcurrentHashMap<Integer, ElementsBuffer>();
    private final Map<Integer, ElementsBuffer> texturesCoordinatesBufferMap = new HashMap<Integer, ElementsBuffer>();
    private final Map<Integer, IndicesBuffer> indexBufferMap = new HashMap<Integer, IndicesBuffer>();
    private final Map<Integer, IndicesBuffer> wireIndexBufferMap = new HashMap<Integer, IndicesBuffer>();
    private final Canvas canvas;

    public DataManager(Canvas canvas) {
        this.canvas = canvas;
    }

    public ElementsBuffer getVertexBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        Object object;
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(graphicObject.getParentAxes());
        double[][] dArray = axes.getScaleTranslateFactors();
        if (this.vertexBufferMap.containsKey(n) && ((TransformedElementsBuffer)(object = this.vertexBufferMap.get(n))).isSameFactors(dArray)) {
            return ((TransformedElementsBuffer)object).getBuffer();
        }
        object = this.canvas.getBuffersManager().createElementsBuffer();
        this.fillVertexBuffer((ElementsBuffer)object, n, dArray[0], dArray[1]);
        this.vertexBufferMap.put(n, new TransformedElementsBuffer((ElementsBuffer)object, dArray));
        return object;
    }

    public ElementsBuffer getNormalBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        if (this.normalBufferMap.containsKey(n)) {
            return this.normalBufferMap.get(n);
        }
        ElementsBuffer elementsBuffer = this.canvas.getBuffersManager().createElementsBuffer();
        this.fillNormalBuffer(elementsBuffer, n);
        this.normalBufferMap.put(n, elementsBuffer);
        return elementsBuffer;
    }

    public ElementsBuffer getTextureCoordinatesBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        if (this.texturesCoordinatesBufferMap.containsKey(n)) {
            return this.texturesCoordinatesBufferMap.get(n);
        }
        ElementsBuffer elementsBuffer = this.canvas.getBuffersManager().createElementsBuffer();
        this.fillTextureCoordinatesBuffer(elementsBuffer, n);
        this.texturesCoordinatesBufferMap.put(n, elementsBuffer);
        return elementsBuffer;
    }

    public ElementsBuffer getColorBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        if (this.colorBufferMap.containsKey(n)) {
            return this.colorBufferMap.get(n);
        }
        ElementsBuffer elementsBuffer = this.canvas.getBuffersManager().createElementsBuffer();
        this.fillColorBuffer(elementsBuffer, n);
        this.colorBufferMap.put(n, elementsBuffer);
        return elementsBuffer;
    }

    public IndicesBuffer getIndexBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        if (this.indexBufferMap.containsKey(n)) {
            return this.indexBufferMap.get(n);
        }
        IndicesBuffer indicesBuffer = this.canvas.getBuffersManager().createIndicesBuffer();
        this.fillIndexBuffer(indicesBuffer, n);
        this.indexBufferMap.put(n, indicesBuffer);
        return indicesBuffer;
    }

    public IndicesBuffer getWireIndexBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        if (this.wireIndexBufferMap.containsKey(n)) {
            return this.wireIndexBufferMap.get(n);
        }
        IndicesBuffer indicesBuffer = this.canvas.getBuffersManager().createIndicesBuffer();
        this.fillWireIndexBuffer(indicesBuffer, n);
        this.wireIndexBufferMap.put(n, indicesBuffer);
        return indicesBuffer;
    }

    public void updateTextureCoordinatesBuffer(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        ElementsBuffer elementsBuffer = this.texturesCoordinatesBufferMap.get(n);
        if (elementsBuffer != null) {
            this.fillTextureCoordinatesBuffer(elementsBuffer, n);
        }
    }

    public void update(Integer n, int n2) throws OutOfMemoryException {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 29);
        try {
            if (this.vertexBufferMap.containsKey(n) && (n3.equals(6) && FAC3D_DATA_PROPERTIES.contains(n2) || n3.equals(7) && FEC_DATA_PROPERTIES.contains(n2) || n3.equals(10) && GRAYPLOT_DATA_PROPERTIES.contains(n2) || n3.equals(13) && MATPLOT_DATA_PROPERTIES.contains(n2) || n3.equals(15) && POLYLINE_DATA_PROPERTIES.contains(n2) || n3.equals(14) && PLOT3D_DATA_PROPERTIES.contains(n2) || n3.equals(0) && ARC_DATA_PROPERTIES.contains(n2) || n3.equals(4) && CHAMP_DATA_PROPERTIES.contains(n2) || n3.equals(16) && RECTANGLE_DATA_PROPERTIES.contains(n2) || n3.equals(17) && SEGS_DATA_PROPERTIES.contains(n2))) {
                this.fillBuffers(n);
            }
            if (n2 == 117) {
                this.updateChildrenVertexIndex(n, 1);
            }
            if (n2 == 134) {
                this.updateChildrenVertexIndex(n, 2);
            }
            if (n2 == 151) {
                this.updateChildrenVertexIndex(n, 4);
            }
        }
        catch (ObjectRemovedException objectRemovedException) {
            // empty catch block
        }
    }

    private void updateChildrenVertexIndex(Integer n, int n2) throws ObjectRemovedException, OutOfMemoryException {
        IndicesBuffer indicesBuffer;
        IndicesBuffer indicesBuffer2;
        ElementsBuffer elementsBuffer;
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(graphicObject.getParentAxes());
        double[][] dArray = axes.getScaleTranslateFactors();
        TransformedElementsBuffer transformedElementsBuffer = this.vertexBufferMap.get(n);
        if (transformedElementsBuffer != null) {
            this.updateVertexBuffer(transformedElementsBuffer.getBuffer(), n, n2, dArray[0], dArray[1]);
        }
        if ((elementsBuffer = this.normalBufferMap.get(n)) != null) {
            this.fillNormalBuffer(elementsBuffer, n);
        }
        if ((indicesBuffer2 = this.indexBufferMap.get(n)) != null) {
            this.fillIndexBuffer(indicesBuffer2, n);
        }
        if ((indicesBuffer = this.wireIndexBufferMap.get(n)) != null) {
            this.fillWireIndexBuffer(indicesBuffer, n);
        }
        for (Integer n3 : (Integer[])GraphicController.getController().getProperty(n, 22)) {
            this.updateChildrenVertexIndex(n3, n2);
        }
    }

    public void dispose(Integer n) {
        if (this.vertexBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.vertexBufferMap.get(n).getBuffer());
            this.vertexBufferMap.remove(n);
        }
        if (this.normalBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.normalBufferMap.get(n));
            this.normalBufferMap.remove(n);
        }
        if (this.colorBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.colorBufferMap.get(n));
            this.colorBufferMap.remove(n);
        }
        if (this.texturesCoordinatesBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.texturesCoordinatesBufferMap.get(n));
            this.texturesCoordinatesBufferMap.remove(n);
        }
        if (this.indexBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.indexBufferMap.get(n));
            this.indexBufferMap.remove(n);
        }
        if (this.wireIndexBufferMap.containsKey(n)) {
            this.canvas.getBuffersManager().dispose((DataBuffer)this.wireIndexBufferMap.get(n));
            this.wireIndexBufferMap.remove(n);
        }
    }

    public void disposeAllColorBuffers() {
        this.canvas.getBuffersManager().dispose(this.colorBufferMap.values());
        this.colorBufferMap.clear();
    }

    public void disposeAllTextureCoordinatesBuffers() {
        this.canvas.getBuffersManager().dispose(this.texturesCoordinatesBufferMap.values());
        this.texturesCoordinatesBufferMap.clear();
    }

    private void fillBuffers(Integer n) throws ObjectRemovedException, OutOfMemoryException {
        IndicesBuffer indicesBuffer;
        IndicesBuffer indicesBuffer2;
        ElementsBuffer elementsBuffer;
        ElementsBuffer elementsBuffer2;
        ElementsBuffer elementsBuffer3;
        TransformedElementsBuffer transformedElementsBuffer = this.vertexBufferMap.get(n);
        if (transformedElementsBuffer != null) {
            this.fillVertexBuffer(transformedElementsBuffer.getBuffer(), n, transformedElementsBuffer.getScale(), transformedElementsBuffer.getTranslate());
        }
        if ((elementsBuffer3 = this.normalBufferMap.get(n)) != null) {
            this.fillNormalBuffer(elementsBuffer3, n);
        }
        if ((elementsBuffer2 = this.colorBufferMap.get(n)) != null) {
            this.fillColorBuffer(elementsBuffer2, n);
        }
        if ((elementsBuffer = this.texturesCoordinatesBufferMap.get(n)) != null) {
            this.fillTextureCoordinatesBuffer(elementsBuffer, n);
        }
        if ((indicesBuffer2 = this.indexBufferMap.get(n)) != null) {
            this.fillIndexBuffer(indicesBuffer2, n);
        }
        if ((indicesBuffer = this.wireIndexBufferMap.get(n)) != null) {
            this.fillWireIndexBuffer(indicesBuffer, n);
        }
    }

    private void fillVertexBuffer(ElementsBuffer elementsBuffer, Integer n, double[] dArray, double[] dArray2) throws ObjectRemovedException, OutOfMemoryException {
        this.fillVertexBuffer(elementsBuffer, n, 15, dArray, dArray2);
    }

    private void fillVertexBuffer(ElementsBuffer elementsBuffer, Integer n, int n2, double[] dArray, double[] dArray2) throws ObjectRemovedException, OutOfMemoryException {
        int n3 = MainDataLoader.getLogMask((Integer)n);
        int n4 = MainDataLoader.getDataSize((Integer)n);
        FloatBuffer floatBuffer = BufferAllocation.newFloatBuffer(n4 * 4);
        MainDataLoader.fillVertices((Integer)n, (FloatBuffer)floatBuffer, (int)4, (int)n2, (double[])dArray, (double[])dArray2, (int)n3);
        elementsBuffer.setData(floatBuffer, 4);
    }

    private void fillNormalBuffer(ElementsBuffer elementsBuffer, Integer n) throws ObjectRemovedException, OutOfMemoryException {
        int n2 = MainDataLoader.getDataSize((Integer)n);
        FloatBuffer floatBuffer = BufferAllocation.newFloatBuffer(n2 * 4);
        MainDataLoader.fillNormals((Integer)n, (FloatBuffer)this.getVertexBuffer(n).getData(), (FloatBuffer)floatBuffer, (int)4);
        elementsBuffer.setData(floatBuffer, 4);
    }

    private void updateVertexBuffer(ElementsBuffer elementsBuffer, Integer n, int n2, double[] dArray, double[] dArray2) throws ObjectRemovedException {
        int n3 = MainDataLoader.getLogMask((Integer)n);
        FloatBuffer floatBuffer = elementsBuffer.getData();
        MainDataLoader.fillVertices((Integer)n, (FloatBuffer)floatBuffer, (int)4, (int)n2, (double[])dArray, (double[])dArray2, (int)n3);
        elementsBuffer.setData(floatBuffer, 4);
    }

    private void fillTextureCoordinatesBuffer(ElementsBuffer elementsBuffer, Integer n) throws ObjectRemovedException, OutOfMemoryException {
        int n2 = MainDataLoader.getDataSize((Integer)n);
        FloatBuffer floatBuffer = BufferAllocation.newFloatBuffer(n2 * 4);
        MainDataLoader.fillTextureCoordinates((Integer)n, (FloatBuffer)floatBuffer, (int)n2);
        elementsBuffer.setData(floatBuffer, 4);
    }

    private void fillColorBuffer(ElementsBuffer elementsBuffer, Integer n) throws ObjectRemovedException, OutOfMemoryException {
        int n2 = MainDataLoader.getDataSize((Integer)n);
        FloatBuffer floatBuffer = BufferAllocation.newFloatBuffer(n2 * 4);
        MainDataLoader.fillColors((Integer)n, (FloatBuffer)floatBuffer, (int)4);
        elementsBuffer.setData(floatBuffer, 4);
    }

    private void fillIndexBuffer(IndicesBuffer indicesBuffer, Integer n) throws ObjectRemovedException, OutOfMemoryException {
        int n2 = MainDataLoader.getIndicesSize((Integer)n);
        IntBuffer intBuffer = BufferAllocation.newIntBuffer(n2);
        int n3 = 0;
        if (n2 != 0) {
            int n4 = MainDataLoader.getLogMask((Integer)n);
            n3 = MainDataLoader.fillIndices((Integer)n, (IntBuffer)intBuffer, (int)n4);
        }
        intBuffer.limit(n3);
        indicesBuffer.setData(intBuffer);
    }

    private void fillWireIndexBuffer(IndicesBuffer indicesBuffer, Integer n) throws ObjectRemovedException, OutOfMemoryException {
        int n2 = MainDataLoader.getWireIndicesSize((Integer)n);
        IntBuffer intBuffer = BufferAllocation.newIntBuffer(n2);
        int n3 = 0;
        if (n2 != 0) {
            int n4 = MainDataLoader.getLogMask((Integer)n);
            n3 = MainDataLoader.fillWireIndices((Integer)n, (IntBuffer)intBuffer, (int)n4);
        }
        intBuffer.limit(n3);
        indicesBuffer.setData(intBuffer);
    }

    private static class TransformedElementsBuffer {
        ElementsBuffer buffer;
        double[][] factors;

        TransformedElementsBuffer(ElementsBuffer elementsBuffer, double[][] dArray) {
            this.buffer = elementsBuffer;
            this.factors = dArray;
        }

        ElementsBuffer getBuffer() {
            return this.buffer;
        }

        double[] getScale() {
            return this.factors[0];
        }

        double[] getTranslate() {
            return this.factors[1];
        }

        boolean isSameFactors(double[][] dArray) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.factors[i][j] == dArray[i][j]) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

