/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer;

import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.datatip.Datatip;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.renderer.JoGLView.DrawerVisitor;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.JoGLView.datatip.DatatipTextDrawer;
import org.scilab.modules.renderer.JoGLView.text.TextManager;

public final class CallRenderer {
    public static void startInteractiveZoom(int n) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(n);
        if (drawerVisitor != null) {
            drawerVisitor.getInteractionManager().startInteractiveZoom();
        }
    }

    public static void start_zoom(int n) {
        CallRenderer.startInteractiveZoom(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n));
    }

    public static double[] clickRubberBox(int n, double[] dArray) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(n);
        if (drawerVisitor != null) {
            return drawerVisitor.getInteractionManager().startClickRubberBox(dArray);
        }
        return new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    }

    public static double[] dragRubberBox(int n) {
        DrawerVisitor drawerVisitor = DrawerVisitor.getVisitor(n);
        if (drawerVisitor != null) {
            return drawerVisitor.getInteractionManager().startDragRubberBox();
        }
        return new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    }

    public static void updateSubwinScale(int n) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null && graphicObject instanceof Axes) {
            AxesDrawer.updateAxesTransformation((Axes)graphicObject);
        }
    }

    public static void updateTextBounds(int n) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null) {
            if (graphicObject instanceof Datatip) {
                DatatipTextDrawer.updateTextCorners((Datatip)graphicObject);
            } else if (graphicObject instanceof Text) {
                TextManager.updateTextCorners((Text)graphicObject);
            }
        }
    }

    public static double[] get2dViewCoordinates(int n, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null && graphicObject instanceof Axes) {
            double[] dArray3 = AxesDrawer.compute2dViewCoordinates((Axes)graphicObject, dArray);
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
        }
        return dArray2;
    }

    public static double[] getPixelFrom2dViewCoordinates(int n, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null && graphicObject instanceof Axes) {
            double[] dArray3 = AxesDrawer.computePixelFrom2dViewCoordinates((Axes)graphicObject, dArray);
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
        }
        return dArray2;
    }

    public static double[] get2dViewFromPixelCoordinates(int n, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0};
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null && graphicObject instanceof Axes) {
            double[] dArray3 = AxesDrawer.compute2dViewFromPixelCoordinates((Axes)graphicObject, dArray);
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
        }
        return dArray2;
    }

    public static double[][] getPixelFrom3dCoordinates(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject instanceof Axes) {
            return AxesDrawer.computePixelFrom3dCoordinates((Axes)graphicObject, dArray, dArray2, dArray3);
        }
        return null;
    }

    public static double[] getPixelFrom3dCoordinates(int n, double[] dArray) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject instanceof Axes) {
            return AxesDrawer.computePixelFrom3dCoordinates((Axes)graphicObject, dArray);
        }
        return null;
    }

    public static double[] getViewingArea(int n) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(Integer.valueOf(n));
        if (graphicObject != null && graphicObject instanceof Axes) {
            double[] dArray2 = AxesDrawer.getViewingArea((Axes)graphicObject);
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = dArray2[2];
            dArray[3] = dArray2[3];
        }
        return dArray;
    }
}

