/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabTList
extends ArrayList<ScilabType>
implements ScilabType {
    private static final long serialVersionUID = 8080160982092586620L;
    private static final int VERSION = 0;
    private String varName;

    public ScilabTList() {
    }

    public ScilabTList(String string) {
        this.varName = string;
    }

    public ScilabTList(String[] stringArray) {
        String[][] stringArray2 = new String[1][stringArray.length];
        stringArray2[0] = stringArray;
        this.add(new ScilabString(stringArray2));
    }

    public ScilabTList(String[] stringArray, Collection<? extends ScilabType> collection) {
        super(collection.size() + 1);
        String[][] stringArray2 = new String[1][stringArray.length];
        stringArray2[0] = stringArray;
        this.add(new ScilabString(stringArray2));
        this.addAll(collection);
    }

    public ScilabTList(String string, int n) {
        super(n);
        this.varName = string;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return false;
    }

    public Map<String, ScilabType> getTListFields() {
        HashMap<String, ScilabType> hashMap = new HashMap<String, ScilabType>();
        if (this.isEmpty()) {
            return hashMap;
        }
        ScilabString scilabString = (ScilabString)this.get(0);
        if (scilabString.isEmpty()) {
            return hashMap;
        }
        String[] stringArray = scilabString.getData()[0];
        for (int i = 1; i < stringArray.length; ++i) {
            if (i < this.size()) {
                hashMap.put(stringArray[i], (ScilabType)this.get(i));
                continue;
            }
            hashMap.put(stringArray[i], null);
        }
        return hashMap;
    }

    public String getTListType() {
        if (this.isEmpty()) {
            return null;
        }
        ScilabString scilabString = (ScilabString)this.get(0);
        if (scilabString.isEmpty()) {
            return null;
        }
        return scilabString.getData()[0][0];
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_tlist;
    }

    @Override
    public int getHeight() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getWidth() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.size();
    }

    public Object[] getSerializedObject() {
        int[] nArray = new int[this.size()];
        Object[] objectArray = new Object[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            ScilabType scilabType = (ScilabType)this.get(i);
            nArray[i] = scilabType.getType().swigValue();
            objectArray[i + 1] = scilabType.getSerializedObject();
        }
        objectArray[0] = nArray;
        return objectArray;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                int n2 = objectInput.readInt();
                this.ensureCapacity(n2 + 1);
                ScilabTList scilabTList = this;
                for (int i = 0; i < n2; ++i) {
                    scilabTList.add(objectInput.readObject());
                }
                this.varName = (String)objectInput.readObject();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabTList with a version " + n + " does not exist");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this.size());
        for (Object e : this) {
            objectOutput.writeObject(e);
        }
        objectOutput.writeObject(this.varName);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty()) {
            return "tlist()";
        }
        stringBuffer.append("tlist(");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i));
            if (i == this.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

