/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.scilab.modules.types.ScilabInteger;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabIntegerReference
extends ScilabInteger {
    private LongBuffer longBuffer;
    private IntBuffer intBuffer;
    private ShortBuffer shortBuffer;
    private ByteBuffer byteBuffer;
    private final int nbRows;
    private final int nbCols;

    public ScilabIntegerReference() {
        this.nbRows = 0;
        this.nbCols = 0;
    }

    ScilabIntegerReference(String string, ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        this.varName = string;
        this.byteBuffer = byteBuffer;
        this.nbRows = n;
        this.nbCols = n2;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint8 : ScilabIntegerTypeEnum.sci_int8;
        this.byref = true;
        this.swaped = false;
    }

    ScilabIntegerReference(String string, ShortBuffer shortBuffer, int n, int n2, boolean bl) {
        this.varName = string;
        this.shortBuffer = shortBuffer;
        this.nbRows = n;
        this.nbCols = n2;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint16 : ScilabIntegerTypeEnum.sci_int16;
        this.byref = true;
        this.swaped = false;
    }

    ScilabIntegerReference(String string, IntBuffer intBuffer, int n, int n2, boolean bl) {
        this.varName = string;
        this.intBuffer = intBuffer;
        this.nbRows = n;
        this.nbCols = n2;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint32 : ScilabIntegerTypeEnum.sci_int32;
        this.byref = true;
        this.swaped = false;
    }

    ScilabIntegerReference(String string, LongBuffer longBuffer, int n, int n2, boolean bl) {
        this.varName = string;
        this.longBuffer = longBuffer;
        this.nbRows = n;
        this.nbCols = n2;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint64 : ScilabIntegerTypeEnum.sci_int64;
        this.byref = true;
        this.swaped = false;
    }

    @Override
    public byte getByteElement(int n, int n2) {
        return this.byteBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public short getShortElement(int n, int n2) {
        return this.shortBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public int getIntElement(int n, int n2) {
        return this.intBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public long getLongElement(int n, int n2) {
        return this.longBuffer.get(n + this.nbRows * n2);
    }

    @Override
    public void setByteElement(int n, int n2, byte by) {
        this.byteBuffer.put(n + this.nbRows * n2, by);
    }

    @Override
    public void setShortElement(int n, int n2, short s) {
        this.shortBuffer.put(n + this.nbRows * n2, s);
    }

    @Override
    public void setIntElement(int n, int n2, int n3) {
        this.intBuffer.put(n + this.nbRows * n2, n3);
    }

    @Override
    public void setLongElement(int n, int n2, long l) {
        this.longBuffer.put(n + this.nbRows * n2, l);
    }

    @Override
    public void setData(byte[][] byArray, boolean bl) {
        ScilabTypeUtils.setPart(this.byteBuffer, byArray);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint8 : ScilabIntegerTypeEnum.sci_int8;
    }

    @Override
    public void setData(short[][] sArray, boolean bl) {
        ScilabTypeUtils.setPart(this.shortBuffer, sArray);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint16 : ScilabIntegerTypeEnum.sci_int16;
    }

    @Override
    public void setData(int[][] nArray, boolean bl) {
        ScilabTypeUtils.setPart(this.intBuffer, nArray);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint32 : ScilabIntegerTypeEnum.sci_int32;
    }

    @Override
    public void setData(long[][] lArray, boolean bl) {
        ScilabTypeUtils.setPart(this.longBuffer, lArray);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint64 : ScilabIntegerTypeEnum.sci_int64;
    }

    @Override
    public short[][] getDataAsShort() {
        short[][] sArray = new short[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(sArray, this.shortBuffer);
        return sArray;
    }

    @Override
    public byte[][] getDataAsByte() {
        byte[][] byArray = new byte[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(byArray, this.byteBuffer);
        return byArray;
    }

    @Override
    public int[][] getDataAsInt() {
        int[][] nArray = new int[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(nArray, this.intBuffer);
        return nArray;
    }

    @Override
    public long[][] getDataAsLong() {
        long[][] lArray = new long[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(lArray, this.longBuffer);
        return lArray;
    }

    @Override
    public int getHeight() {
        return this.nbRows;
    }

    @Override
    public int getWidth() {
        return this.nbCols;
    }

    @Override
    public boolean isEmpty() {
        return this.nbRows == 0 || this.nbCols == 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabInteger) {
            ScilabInteger scilabInteger = (ScilabInteger)object;
            if (this.isEmpty() && scilabInteger.isEmpty()) {
                return true;
            }
            if (this.getWidth() != scilabInteger.getWidth() || this.getHeight() != scilabInteger.getHeight()) {
                return false;
            }
            return ScilabTypeUtils.equalsInteger(this.getRawData(), this.isSwaped(), scilabInteger.getRawData(), scilabInteger.isSwaped());
        }
        return false;
    }

    @Override
    public Object getRawData() {
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                return this.byteBuffer;
            }
            case sci_int16: 
            case sci_uint16: {
                return this.shortBuffer;
            }
            case sci_int32: 
            case sci_uint32: {
                return this.intBuffer;
            }
            case sci_int64: 
            case sci_uint64: {
                return this.longBuffer;
            }
        }
        return null;
    }

    @Override
    public Object getCorrectData() {
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                return this.getDataAsByte();
            }
            case sci_int16: 
            case sci_uint16: {
                return this.getDataAsShort();
            }
            case sci_int32: 
            case sci_uint32: {
                return this.getDataAsInt();
            }
            case sci_int64: 
            case sci_uint64: {
                return this.getDataAsLong();
            }
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        switch (this.precision) {
            case sci_int8: {
                return new ScilabInteger(this.varName, this.byteData, false, this.swaped);
            }
            case sci_uint8: {
                return new ScilabInteger(this.varName, this.byteData, true, this.swaped);
            }
            case sci_int16: {
                return new ScilabInteger(this.varName, this.shortData, false, this.swaped);
            }
            case sci_uint16: {
                return new ScilabInteger(this.varName, this.shortData, true, this.swaped);
            }
            case sci_int32: {
                return new ScilabInteger(this.varName, this.intData, false, this.swaped);
            }
            case sci_uint32: {
                return new ScilabInteger(this.varName, this.intData, true, this.swaped);
            }
            case sci_int64: {
                return new ScilabInteger(this.varName, this.longData, false, this.swaped);
            }
            case sci_uint64: {
                return new ScilabInteger(this.varName, this.longData, true, this.swaped);
            }
        }
        return this;
    }
}

