/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabBoolean
implements ScilabType {
    private static final long serialVersionUID = 6511497080095473901L;
    private static final int VERSION = 0;
    protected boolean[][] data;
    protected String varName;
    protected boolean swaped;
    protected transient boolean byref;

    public ScilabBoolean() {
        this.data = null;
    }

    public ScilabBoolean(boolean[][] blArray) {
        this.data = blArray;
    }

    public ScilabBoolean(String string, boolean[][] blArray, boolean bl) {
        this.varName = string;
        this.data = blArray;
        this.swaped = bl;
    }

    public ScilabBoolean(boolean bl) {
        this.data = new boolean[1][1];
        this.data[0][0] = bl;
    }

    @Override
    public boolean isReference() {
        return this.byref;
    }

    public void setData(boolean[][] blArray) {
        this.data = blArray;
    }

    public boolean[][] getData() {
        return this.data;
    }

    public Object getRawData() {
        return this.data;
    }

    public boolean getElement(int n, int n2) {
        return this.data[n][n2];
    }

    public void setElement(int n, int n2, boolean bl) {
        this.data[n][n2] = bl;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return this.swaped;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_boolean;
    }

    @Override
    public int getHeight() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public int getWidth() {
        if (this.data == null) {
            return 0;
        }
        return this.data[0].length;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabBoolean) {
            ScilabBoolean scilabBoolean = (ScilabBoolean)object;
            if (this.isEmpty() && scilabBoolean.isEmpty()) {
                return true;
            }
            if (this.getWidth() != scilabBoolean.getWidth() || this.getHeight() != scilabBoolean.getHeight()) {
                return false;
            }
            return ScilabTypeUtils.equalsBoolean(this.getRawData(), this.isSwaped(), scilabBoolean.getRawData(), scilabBoolean.isSwaped());
        }
        return false;
    }

    @Override
    public Object getSerializedObject() {
        return this.getData();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.data = (boolean[][])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                this.swaped = objectInput.readBoolean();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabBoolean with a version " + n + " does not exist");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.getData());
        objectOutput.writeObject(this.varName);
        objectOutput.writeBoolean(this.swaped);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            return "[]";
        }
        stringBuilder.append("[");
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                if (this.getElement(i, j)) {
                    stringBuilder.append("%t");
                } else {
                    stringBuilder.append("%f");
                }
                if (j == this.getWidth() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i == this.getHeight() - 1) continue;
            stringBuilder.append(" ; ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

