/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ScilabScrollPane
extends JScrollPane {
    private static final Color MARKCOLOR = new Color(229, 192, 0);
    private List<Rectangle> marks;

    public ScilabScrollPane(Component component) {
        super(component);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new ScilabVerticalScrollBar();
    }

    public void putMarks(List<Rectangle> list) {
        this.marks = list;
        this.getVerticalScrollBar().repaint();
    }

    public void removeMarks() {
        this.marks = null;
        this.getVerticalScrollBar().repaint();
    }

    protected class ScilabVerticalScrollBar
    extends JScrollPane.ScrollBar {
        private Field trackRect;
        private Field thumbRect;
        private ScrollBarUI ui;

        public ScilabVerticalScrollBar() {
            super(ScilabScrollPane.this, 1);
            this.ui = this.getUI();
            this.initFields();
        }

        private void initFields() {
            if (this.ui instanceof BasicScrollBarUI) {
                try {
                    this.trackRect = BasicScrollBarUI.class.getDeclaredField("trackRect");
                    this.trackRect.setAccessible(true);
                    this.thumbRect = BasicScrollBarUI.class.getDeclaredField("thumbRect");
                    this.thumbRect.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(MARKCOLOR);
            ScrollBarUI scrollBarUI = this.getUI();
            if (this.ui != scrollBarUI) {
                this.ui = scrollBarUI;
                this.initFields();
            }
            if (scrollBarUI instanceof BasicScrollBarUI && this.trackRect != null && this.thumbRect != null) {
                BasicScrollBarUI basicScrollBarUI = (BasicScrollBarUI)scrollBarUI;
                try {
                    Rectangle rectangle = (Rectangle)this.trackRect.get(basicScrollBarUI);
                    Rectangle rectangle2 = (Rectangle)this.thumbRect.get(basicScrollBarUI);
                    double d = (double)rectangle.height / (double)this.getMaximum();
                    if (ScilabScrollPane.this.marks != null) {
                        for (Rectangle rectangle3 : ScilabScrollPane.this.marks) {
                            Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y + (int)((double)(rectangle3.y + rectangle3.height) * d), rectangle.width, 2);
                            if (rectangle2.contains(rectangle4)) continue;
                            graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

