/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import com.artenum.rosetta.interfaces.core.CompletionItem;
import com.artenum.rosetta.interfaces.core.CompletionManager;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.scilab.modules.completion.AbstractSciCompletionWindow;
import org.scilab.modules.completion.Completion;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;

public class SciNotesCompletionWindow
extends AbstractSciCompletionWindow {
    private SciNotes editor;
    private CompletionManager completionManager;

    public SciNotesCompletionWindow(SciNotes sciNotes, CompletionManager completionManager) {
        this.editor = sciNotes;
        this.completionManager = completionManager;
    }

    public JTextComponent getTextComponent() {
        return this.editor.getTextPane();
    }

    public List<CompletionItem> getCompletionItems() {
        return this.completionManager.getCompletionItems();
    }

    public void setGraphicalContext(Component component) {
        this.setFocusOut((JComponent)component);
        super.setGraphicalContext(component);
    }

    public void show(List<CompletionItem> list, Point point) {
        this.currentCaretPosition = this.inputParsingManager.getCaretPosition();
        if (list != null) {
            ScilabEditorPane scilabEditorPane = this.editor.getTextPane();
            int n = scilabEditorPane.getScrollPane().getVerticalScrollBar().getValue();
            int n2 = scilabEditorPane.getScrollPane().getHeight();
            if (scilabEditorPane.getOtherPaneInSplit() != null) {
                this.getTextComponent().add(this.window);
            }
            if (this.window.getHeight() + point.y > n + n2) {
                try {
                    int n3 = scilabEditorPane.modelToView((int)this.currentCaretPosition).height;
                    point.y = point.y - this.window.getHeight() - n3;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.model.updateData(list);
            this.window.setLocation(point);
            this.window.setVisible(true);
            this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
            if (this.model.getSize() > 0) {
                this.listUI.setSelectedIndex(0);
            }
            this.listUI.grabFocus();
        }
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
        if (!bl) {
            this.editor.getTextPane().grabFocus();
        }
    }

    public void addCompletedWord(int n) {
        this.addCompletedWord(((CompletionItem)this.listUI.getSelectedValue()).getReturnValue(), n);
    }

    public void addCompletedWord(String string, int n) {
        String string2 = this.inputParsingManager.getCommandLine();
        Object object = string2.substring(0, string2.length() - Completion.getPartLevel((String)string2).length());
        object = (String)object + string;
        this.inputParsingManager.reset();
        this.inputParsingManager.append((String)object);
    }
}

