/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.text.Element;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.flexdock.docking.event.DockingEvent;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.tabfactory.CodeNavigatorTabFactory;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public final class NavigatorWindow
extends SwingScilabDockablePanel
implements DocumentListener,
TreeExpansionListener {
    private static final String EMPTY = "";
    private Map<ScilabEditorPane, DefaultMutableTreeNode> mapNode = new HashMap<ScilabEditorPane, DefaultMutableTreeNode>();
    private Map<ScilabEditorPane, TreePath> mapFunPath = new HashMap<ScilabEditorPane, TreePath>();
    private Map<ScilabEditorPane, TreePath> mapAnchorPath = new HashMap<ScilabEditorPane, TreePath>();
    private List<ScilabEditorPane> panes = new ArrayList<ScilabEditorPane>();
    private SciNotes editor;
    private JTree functionNavigator;
    private DefaultTreeModel model;
    private ScilabEditorPane pane;
    private ScilabDocument doc;
    private boolean alphaOrder;
    private boolean isAbsolute = true;
    private boolean lineNumberActive = true;
    private boolean locked;
    private boolean init;
    private JSeparator jSeparator1;
    private JLabel labelGotoLine;
    private JLabel labelNumerotation;
    private JTextField lineNumber;
    private JComboBox numType;
    private JScrollPane scrollPane;
    private SwingScilabWindow parentWindow;

    public NavigatorWindow(SciNotes sciNotes, String string) {
        super(SciNotesMessages.CODE_NAVIGATOR, string == null ? UUID.randomUUID().toString() : string);
        this.editor = sciNotes;
        sciNotes.addNavigator(this);
        this.setContentPane(new JPanel());
        ConfigSciNotesManager.saveCodeNavigatorState(sciNotes.getPersistentId(), this.getPersistentId());
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
    }

    public NavigatorWindow(SciNotes sciNotes) {
        this(sciNotes, null);
    }

    public void update(ScilabDocument scilabDocument) {
        if (!this.init) {
            this.initTree();
            this.initComponents();
            this.functionNavigator.addTreeExpansionListener(this);
            this.init = true;
        }
        if (scilabDocument != null) {
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            this.doc = scilabDocument;
            this.pane = scilabDocument.getEditorPane();
            this.doc.addDocumentListener(this);
            if (!this.mapNode.containsKey(this.pane)) {
                this.initTree();
            } else {
                this.updateTree();
            }
        }
    }

    public void addEditorPane(ScilabEditorPane scilabEditorPane) {
        this.panes.add(scilabEditorPane);
        this.update((ScilabDocument)scilabEditorPane.getDocument());
    }

    public void update() {
        this.updateTree();
    }

    public void activateNavigator(ScilabDocument scilabDocument) {
        this.initTree();
        this.update(scilabDocument);
    }

    public void setParentWindow() {
        this.parentWindow = SwingScilabWindow.createWindow((boolean)true);
        this.parentWindow.addTab((SwingScilabPanel)this);
        this.parentWindow.setVisible(true);
    }

    public SwingScilabWindow getParentWindow() {
        return this.parentWindow;
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public void closeNavigator() {
        this.editor.removeNavigator();
        this.mapNode.clear();
        this.mapFunPath.clear();
        this.mapAnchorPath.clear();
        this.functionNavigator = null;
        this.model = null;
        this.pane = null;
        this.doc = null;
        for (ScilabEditorPane scilabEditorPane : this.panes) {
            ((ScilabDocument)scilabEditorPane.getDocument()).removeDocumentListener(this);
        }
        this.panes.clear();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent.getOffset(), documentEvent.getLength());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void dockingComplete(DockingEvent dockingEvent) {
        super.dockingComplete(dockingEvent);
        this.changeToolBar();
    }

    public void changeToolBar() {
        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this));
        if (swingScilabWindow != null && swingScilabWindow.getDockingPort() != null) {
            Set set = swingScilabWindow.getDockingPort().getDockables();
            for (SwingScilabDockablePanel swingScilabDockablePanel : set) {
                if (swingScilabDockablePanel != this.editor) continue;
                this.addToolBar(this.editor.getToolBar());
                break;
            }
        }
    }

    public void undockingComplete(DockingEvent dockingEvent) {
        super.undockingComplete(dockingEvent);
        this.addToolBar(null);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (!this.locked) {
            TreePath treePath = treeExpansionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ScilabEditorPane scilabEditorPane = this.pane;
            ScilabDocument scilabDocument = this.doc;
            boolean bl = false;
            if (defaultMutableTreeNode.getUserObject() instanceof String && SciNotesMessages.FUNCTIONS.equals(defaultMutableTreeNode.getUserObject())) {
                this.pane = (ScilabEditorPane)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                this.doc = (ScilabDocument)this.pane.getDocument();
                this.locked = true;
                this.updateFunctions();
                this.functionNavigator.expandPath(this.mapFunPath.get(this.pane));
                bl = true;
            } else if (defaultMutableTreeNode.getUserObject() instanceof String && SciNotesMessages.ANCHORS.equals(defaultMutableTreeNode.getUserObject())) {
                this.pane = (ScilabEditorPane)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                this.doc = (ScilabDocument)this.pane.getDocument();
                this.locked = true;
                this.updateAnchors();
                this.functionNavigator.expandPath(this.mapAnchorPath.get(this.pane));
                bl = true;
            } else if (defaultMutableTreeNode.getUserObject() instanceof ScilabEditorPane) {
                this.pane = (ScilabEditorPane)defaultMutableTreeNode.getUserObject();
                this.doc = (ScilabDocument)this.pane.getDocument();
                boolean bl2 = this.functionNavigator.isExpanded(this.mapFunPath.get(this.pane));
                this.updateFunctions();
                if (bl2) {
                    this.locked = true;
                    this.functionNavigator.expandPath(this.mapFunPath.get(this.pane));
                }
                bl = true;
            }
            if (bl) {
                this.pane = scilabEditorPane;
                this.doc = scilabDocument;
            }
        } else {
            this.locked = false;
        }
    }

    public void changePaneOnSplit(ScilabEditorPane scilabEditorPane, ScilabEditorPane scilabEditorPane2) {
        if (this.mapNode.containsKey(scilabEditorPane)) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.mapNode.get(scilabEditorPane);
            defaultMutableTreeNode.setUserObject(scilabEditorPane2);
            this.mapNode.put(scilabEditorPane2, this.mapNode.get(scilabEditorPane));
            this.mapNode.remove(scilabEditorPane);
            this.mapFunPath.put(scilabEditorPane2, this.mapFunPath.get(scilabEditorPane));
            this.mapFunPath.remove(scilabEditorPane);
            this.mapAnchorPath.put(scilabEditorPane2, this.mapAnchorPath.get(scilabEditorPane));
            this.mapAnchorPath.remove(scilabEditorPane);
        }
    }

    public void removePane(ScilabEditorPane scilabEditorPane) {
        if (this.mapNode.containsKey(scilabEditorPane)) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.mapNode.get(scilabEditorPane);
            ((DefaultMutableTreeNode)this.model.getRoot()).remove(defaultMutableTreeNode);
            this.model.reload();
            this.mapNode.remove(scilabEditorPane);
            this.mapFunPath.remove(scilabEditorPane);
            this.mapAnchorPath.remove(scilabEditorPane);
            this.panes.remove(scilabEditorPane);
            this.pane = null;
            this.doc = null;
        }
    }

    private void initComponents() {
        this.labelNumerotation = new JLabel();
        this.lineNumber = new JTextField();
        this.numType = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.labelGotoLine = new JLabel();
        this.scrollPane = new JScrollPane();
        this.setTitle(SciNotesMessages.CODE_NAVIGATOR);
        this.updateUI();
        this.labelNumerotation.setText(SciNotesMessages.NUMEROTATION);
        this.labelNumerotation.setFocusable(false);
        this.lineNumber.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                NavigatorWindow.this.updateCaretPosition();
            }
        });
        this.lineNumber.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NavigatorWindow.this.updateCaretPosition();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.numType.setModel(new DefaultComboBoxModel<String>(new String[]{SciNotesMessages.ABSOLUTE, SciNotesMessages.RELATIVE}));
        this.numType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = NavigatorWindow.this.numType.getSelectedIndex();
                if (n == 0 && !NavigatorWindow.this.isAbsolute) {
                    NavigatorWindow.this.lineNumber.setText(NavigatorWindow.EMPTY);
                    NavigatorWindow.this.isAbsolute = true;
                } else if (n == 1 && NavigatorWindow.this.isAbsolute) {
                    NavigatorWindow.this.lineNumber.setText(NavigatorWindow.EMPTY);
                    NavigatorWindow.this.isAbsolute = false;
                }
            }
        });
        this.labelGotoLine.setText(SciNotesMessages.GO_TO_LINE);
        this.labelGotoLine.setFocusable(false);
        this.functionNavigator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = NavigatorWindow.this.functionNavigator.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.getClickCount() == 2) {
                    NavigatorWindow.this.handleSelectedItem(n);
                }
            }
        });
        this.functionNavigator.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "toggle");
        this.functionNavigator.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    int n = NavigatorWindow.this.functionNavigator.getMinSelectionRow();
                    NavigatorWindow.this.handleSelectedItem(n);
                }
            }
        });
        this.createPopupMenuOnJTree();
        this.scrollPane.setViewportView(this.functionNavigator);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 200, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 200, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelGotoLine).addComponent(this.labelNumerotation)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineNumber, -2, 58, -2).addComponent(this.numType, -2, -1, -2)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 439, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelGotoLine).addComponent(this.lineNumber, -2, -1, -2)).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNumerotation).addComponent(this.numType, -2, -1, -2)).addContainerGap()));
        ArrayList<Component> arrayList = new ArrayList<Component>(3);
        arrayList.add(this.functionNavigator);
        arrayList.add(this.lineNumber);
        arrayList.add(this.numType);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new NavigatorFocusTraversalPolicy(arrayList));
        this.setMinimumSize(new Dimension(224, 0));
        this.setPreferredSize(new Dimension(224, 543));
        CommonCallBack commonCallBack = new CommonCallBack(null){

            public void callBack() {
                ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)NavigatorWindow.this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.callBack();
            }
        };
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(SciNotesMessages.FILE);
        menu.setMnemonic(70);
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback(commonCallBack);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(SciNotes.getActionKeys().get("scinotes-exit"));
        menuItem.setText(SciNotesMessages.EXIT);
        menu.add(menuItem);
        menuBar.add(menu);
        Menu menu2 = ScilabMenu.createMenu();
        menu2.setText(SciNotesMessages.ORDER);
        menu2.setMnemonic(79);
        menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback(new CommonCallBack(null){

            public void callBack() {
                NavigatorWindow.this.doc.setAlphaOrderInTree(true);
                NavigatorWindow.this.updateTree();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.callBack();
            }
        });
        menuItem.setText(SciNotesMessages.ALPHABETIC_ORDER);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(KeyStroke.getKeyStroke("alt A"));
        menu2.add(menuItem);
        menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback(new CommonCallBack(null){

            public void callBack() {
                NavigatorWindow.this.doc.setAlphaOrderInTree(false);
                NavigatorWindow.this.updateTree();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.callBack();
            }
        });
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(KeyStroke.getKeyStroke("alt N"));
        menuItem.setText(SciNotesMessages.NATURAL_ORDER);
        menu2.add(menuItem);
        menuBar.add(menu2);
        this.addMenuBar(menuBar);
        TextBox textBox = ScilabTextBox.createTextBox();
        this.addInfoBar(textBox);
    }

    public void initTree() {
        this.mapNode.clear();
        this.mapFunPath.clear();
        if (this.functionNavigator == null) {
            this.functionNavigator = new JTree();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        for (ScilabEditorPane scilabEditorPane : this.panes) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(scilabEditorPane);
            this.mapNode.put(scilabEditorPane, defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(SciNotesMessages.FUNCTIONS);
            ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
            scilabDocument.fillTreeFuns(defaultMutableTreeNode3);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(SciNotesMessages.ANCHORS);
            scilabDocument.fillTreeAnchors(defaultMutableTreeNode4);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.mapFunPath.put(scilabEditorPane, new TreePath(this.model.getPathToRoot(defaultMutableTreeNode3)));
            this.mapAnchorPath.put(scilabEditorPane, new TreePath(this.model.getPathToRoot(defaultMutableTreeNode4)));
        }
        this.functionNavigator.setModel(this.model);
        this.functionNavigator.setRootVisible(false);
    }

    public void updateTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.mapNode.get(this.pane);
        TreePath treePath = this.mapFunPath.get(this.pane);
        TreePath treePath2 = this.mapAnchorPath.get(this.pane);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        boolean bl = false;
        boolean bl2 = false;
        if (this.functionNavigator.isExpanded(treePath) || defaultMutableTreeNode2.isLeaf()) {
            defaultMutableTreeNode.removeAllChildren();
            defaultMutableTreeNode2.removeAllChildren();
            this.doc.fillTreeFuns(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            this.model.reload(defaultMutableTreeNode);
            bl = true;
        }
        if (this.functionNavigator.isExpanded(treePath2) || defaultMutableTreeNode3.isLeaf()) {
            defaultMutableTreeNode.removeAllChildren();
            defaultMutableTreeNode3.removeAllChildren();
            this.doc.fillTreeAnchors(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            this.model.reload(defaultMutableTreeNode);
            bl2 = true;
        }
        if (bl) {
            this.functionNavigator.expandPath(treePath);
        }
        if (bl2) {
            this.functionNavigator.expandPath(treePath2);
        }
    }

    private void updateFunctions() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.mapNode.get(this.pane);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        defaultMutableTreeNode.removeAllChildren();
        defaultMutableTreeNode2.removeAllChildren();
        this.doc.fillTreeFuns(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.model.reload(defaultMutableTreeNode);
    }

    private void updateAnchors() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.mapNode.get(this.pane);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        defaultMutableTreeNode.removeAllChildren();
        defaultMutableTreeNode3.removeAllChildren();
        this.doc.fillTreeAnchors(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.model.reload(defaultMutableTreeNode);
    }

    private void createPopupMenuOnJTree() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SciNotesMessages.ALPHABETIC_ORDER);
        JMenuItem jMenuItem2 = new JMenuItem(SciNotesMessages.NATURAL_ORDER);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorWindow.this.handleOrder(true);
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigatorWindow.this.handleOrder(false);
            }
        });
        jPopupMenu.add(jMenuItem2);
        this.functionNavigator.setComponentPopupMenu(jPopupMenu);
    }

    private void handleOrder(boolean bl) {
        int n = this.functionNavigator.getMinSelectionRow();
        if (n == -1) {
            this.functionNavigator.setSelectionRow(0);
            n = 0;
        }
        TreePath treePath = this.functionNavigator.getPathForRow(n);
        ScilabDocument scilabDocument = this.doc;
        ScilabEditorPane scilabEditorPane = this.pane;
        this.doc = this.getDocumentInNode((DefaultMutableTreeNode)treePath.getLastPathComponent());
        this.pane = this.getPaneInNode((DefaultMutableTreeNode)treePath.getLastPathComponent());
        this.doc.setAlphaOrderInTree(bl);
        this.updateTree();
        this.doc = scilabDocument;
        this.pane = scilabEditorPane;
    }

    private void handleEvent(int n, int n2) {
        Element element = this.doc.getDefaultRootElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        if (element2 instanceof ScilabDocument.ScilabLeafElement) {
            ((ScilabDocument.ScilabLeafElement)element2).resetType();
            this.updateTree();
        }
    }

    private void handleSelectedItem(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.functionNavigator.getPathForRow(n);
        if (n != -1 && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf() && defaultMutableTreeNode.getUserObject() instanceof ScilabDocument.ScilabLeafElement) {
            ScilabEditorPane scilabEditorPane = (ScilabEditorPane)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent().getParent()).getUserObject();
            int n2 = ((ScilabDocument.ScilabLeafElement)defaultMutableTreeNode.getUserObject()).getStartOffset();
            if (n2 != -1) {
                scilabEditorPane.getEditor().getTabPane().setSelectedComponent(scilabEditorPane.getEditorComponent());
                scilabEditorPane.scrollTextToPos(n2);
                n2 = scilabEditorPane.getDocument().getDefaultRootElement().getElementIndex(n2) + 1;
                this.numType.setSelectedItem(SciNotesMessages.ABSOLUTE);
                this.lineNumber.setText(Integer.toString(n2));
            }
        }
    }

    private void updateCaretPosition() {
        int n = 0;
        boolean bl = false;
        TreePath treePath = this.functionNavigator.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (treePath != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        try {
            n = Integer.decode(this.lineNumber.getText());
            if (this.isAbsolute) {
                bl = true;
                n = this.correctLineNumber(n);
                this.updatePaneDoc(defaultMutableTreeNode);
            } else if (this.functionNavigator.getRowCount() >= 2) {
                int n2;
                if (this.functionNavigator.isSelectionEmpty()) {
                    this.functionNavigator.setSelectionRow(1);
                }
                if (defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof ScilabDocument.ScilabLeafElement && (n2 = ((ScilabDocument.ScilabLeafElement)defaultMutableTreeNode.getUserObject()).getStartOffset()) != -1) {
                    this.updatePaneDoc(defaultMutableTreeNode);
                    n += this.doc.getDefaultRootElement().getElementIndex(n2);
                    bl = true;
                    n = this.correctLineNumber(n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        this.setLineNumberColor(bl);
        if (bl) {
            this.pane.scrollTextToLineNumber(n, false);
        }
    }

    private void updatePaneDoc(DefaultMutableTreeNode defaultMutableTreeNode) {
        ScilabEditorPane scilabEditorPane;
        if (defaultMutableTreeNode != null && (scilabEditorPane = this.getPaneInNode(defaultMutableTreeNode)) != this.pane) {
            this.pane = scilabEditorPane;
            this.doc = (ScilabDocument)this.pane.getDocument();
            this.pane.getEditor().getTabPane().setSelectedComponent(this.pane.getEditorComponent());
        }
    }

    private ScilabDocument getDocumentInNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        return (ScilabDocument)this.getPaneInNode(defaultMutableTreeNode).getDocument();
    }

    private ScilabEditorPane getPaneInNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.isLeaf()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode3 != null && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()) != null && defaultMutableTreeNode2.getUserObject() instanceof ScilabEditorPane) {
                return (ScilabEditorPane)defaultMutableTreeNode2.getUserObject();
            }
        } else {
            if (defaultMutableTreeNode.getUserObject() instanceof String && SciNotesMessages.FUNCTIONS.equals(defaultMutableTreeNode.getUserObject())) {
                return (ScilabEditorPane)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            }
            if (defaultMutableTreeNode.getUserObject() instanceof ScilabEditorPane) {
                return (ScilabEditorPane)defaultMutableTreeNode.getUserObject();
            }
        }
        return this.pane;
    }

    private int correctLineNumber(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = this.doc.getDefaultRootElement().getElementCount();
        if (n >= n2) {
            return n2 - 1;
        }
        return n;
    }

    private void setLineNumberColor(boolean bl) {
        if (bl && !this.lineNumberActive) {
            this.lineNumber.setForeground(Color.BLACK);
            this.lineNumberActive = true;
        } else if (!bl && this.lineNumberActive) {
            this.lineNumber.setForeground(Color.RED);
            this.lineNumberActive = false;
        }
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)CodeNavigatorTabFactory.getInstance());
    }

    private static class NavigatorFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private List<Component> cycle;

        public NavigatorFocusTraversalPolicy(List<Component> list) {
            this.cycle = list;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.cycle.indexOf(component) + 1) % this.cycle.size();
            return this.cycle.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = (this.cycle.size() + this.cycle.indexOf(component) - 1) % this.cycle.size();
            return this.cycle.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.cycle.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.cycle.get(this.cycle.size() - 1);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.cycle.get(0);
        }
    }
}

